package com.bokesoft.yes.excel.document;

import java.util.HashMap;

public class ExcelDetailDataRow implements IExcelDataRow{
	// 记录datatable中对应的行数
	private int rowIndex = -1;
	// 一行明细行有多个"groupLevel#value"
	private HashMap<Integer, String> signMap = new HashMap<Integer, String>();
	private HashMap<String, Integer> definitionMap = new HashMap<String, Integer>();

	public void setRowIndex(int rowIndex) {
		this.rowIndex = rowIndex;
	}

	@Override
	public int getRowIndex() {
		return rowIndex;
	}

	@Override
	public String getType() {
		return "Detail";
	}
	
	public void addSign(Integer groupLevel, String sign) {
		if(sign != null) {
			signMap.put(groupLevel, sign);
		}
	}
	
	public void addDefinition(Integer groupLevel, String definition) {
		if(definition != null) {
			definitionMap.put(definition, groupLevel);
		}
	}
	
	public String getSign(Integer groupLevel) {
		return signMap.get(groupLevel);
	}
	
	public HashMap<Integer, String> getSignMap(){
		return signMap;
	}
	
	public Integer getGroupLevel(String definition) {
		return definitionMap.get(definition);
	}
	
	public HashMap<String, Integer> getDefinitionMap(){
		return definitionMap;
	}
}
