package com.bokesoft.yes.excel.cmd.stamp.output.strategy;

import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputRowProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputSheetProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputTableProcess;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;

/**
 * 数据输出行为定义
 * 
 * @author chenbb
 *
 */
public interface IOutputStrategy {
	
	default void preOutputExcel(ExcelTemplate templateExcel) {};
	
	default void preOutputSheet(OutputSheetProcess exportSheetProcess) {};
	
	default void preOutputTable(OutputTableProcess exportTableProcess) {};
	
	default void preOutputRow(OutputRowProcess exportRowProcess) {};
	
	public void outputCell(Object value, int rowIndex, int colIndex, ExcelTemplateField field, boolean isDtl);
	
	public void insertRow(int sheetRowIndex, OutputRowProcess exportRowProcess);
	
	default void postOutputRow(OutputRowProcess exportRowProcess) {};
	
	default void postOutputTable(OutputTableProcess exportTableProcess) {};
	
	default void postOutputSheet(OutputSheetProcess exportSheetProcess) {};
	
	default void postOutputExcel(ExcelTemplate templateTable) {};
	
}
