package com.bokesoft.yes.excel.cmd.stamp.output.process;

import com.bokesoft.yes.excel.cmd.stamp.output.strategy.IOutputStrategy;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.transformer.ExcelTransformerFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;

public class OutputTableProcess {
	
	private ExcelTemplateTable templateTable = null;
	private OutputRowProcess exportRowProcess = null;

	public OutputTableProcess(ExcelTemplateTable templateTable) {
		this.templateTable = templateTable;
	}
	
	public ExcelTemplateTable getTemplateTable() {
		return this.templateTable;
	}
	
	public String getTableKey() {
		return this.templateTable.getTableKey();
	}
	
	public void setExportRowProcess(OutputRowProcess exportRowProcess) {
		this.exportRowProcess = exportRowProcess;
	}
	
	private void exportRow(DataTable dataTable, ExcelTransformerFactory transformerFactory, DefaultContext context,
			IOutputStrategy action, boolean isLast, boolean isNeedResetCellIndex) throws Throwable {
		action.preOutputRow(exportRowProcess);
		exportRowProcess.doProcess(dataTable, transformerFactory, context, action, isLast, isNeedResetCellIndex);
		action.postOutputRow(exportRowProcess);
	}
	
	public void export(DataTable dataTable, ExcelTransformerFactory transformerFactory, DefaultContext context,
			IOutputStrategy action, boolean isNeedResetCellIndex) throws Throwable {
		if (dataTable != null) {
			dataTable.beforeFirst();
			while(dataTable.next(true)) {
				exportRow(dataTable, transformerFactory, context, action, dataTable.isLast(true), isNeedResetCellIndex);
			}
		} else {
			exportRow(dataTable, transformerFactory, context, action, false, isNeedResetCellIndex);
		}
	}
}
