package com.bokesoft.yes.excel.cmd.stamp.input.strategy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InTable4Expand;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InTable4Normal;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.constants.ExcelTemplateConstants;

public class SingleInputStrategy implements IInputStrategy {
	
	private ExcelTemplate excelTemplate = null;
	
	private IInputReaderBag workbookReader = null;
	
	private List<IInDocument<IInTable>> listInDocument = null;
	
	private ExcelProcessContext excelProcessContext = null;
	
	public SingleInputStrategy(ExcelTemplate excelTemplate, IInputReaderBag workbookReader, ExcelProcessContext excelProcessContext) {
		this.excelTemplate = excelTemplate;
		this.workbookReader = workbookReader;
		this.listInDocument = new ArrayList<>();
		this.excelProcessContext = excelProcessContext;
		this.init();
	}
	
	private void init() {
		this.listInDocument.add(getInDocument());
	}

	private InDocument<IInTable> getInDocument() {
		InDocument<IInTable> inDoc = new InDocument<>("", workbookReader);
		for (ExcelTemplateTable tableTemplate : excelTemplate.getTemplateTables4StampImport()) {
			IInTable inTable = null;
			int startRowNum = tableTemplate.getStartDtlRowIndex();
			if (tableTemplate.isDtlTable()) {
				int rowIndex = startRowNum + ExcelTemplateConstants.ROW_STEP_NEXT;
				while (rowIndex <= workbookReader.getLastRowNum(tableTemplate.getSheetName())) {
					if (workbookReader.isEmptySheetRow(tableTemplate.getSheetName(), rowIndex)) {
						break;
					}
					rowIndex ++;
				}
				if (tableTemplate.hasExpandField()) {
					inTable = new InTable4Expand(tableTemplate, startRowNum + ExcelTemplateConstants.ROW_STEP_NEXT, rowIndex, workbookReader);
				} else {
					inTable = new InTable4Normal(tableTemplate, startRowNum + ExcelTemplateConstants.ROW_STEP_NEXT, rowIndex, workbookReader);
				}
			} else {
				inTable = new InTable4Normal(tableTemplate, startRowNum, startRowNum, workbookReader);
			}
			inDoc.addTable(inTable);
		}
		return inDoc;
	}
	
	@Override
	public Iterator<IInDocument<IInTable>> iterator() {
		return new InDocumentListIterator(this.listInDocument);
	}
}
