package com.bokesoft.yes.excel.cmd.stamp.exportor;

import java.util.LinkedHashMap;

import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputSheetProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.IOutputStrategy;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.transformer.ExcelTransformerFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

/**
 * excel导出 输出对象
 * 
 * @author chenbb
 *
 */
public class DocumentExportor4Stamp implements IDocumentExportor {
	
	private DefaultContext context = null;
	
	private IOutputStrategy outputStrategy = null;
	
	private ExcelTemplate excelTemplate = null;
	
	private ExcelTransformerFactory transformerFactory = null;
	
	private LinkedHashMap<String, OutputSheetProcess> mapSheetProcess = null;
	
	public DocumentExportor4Stamp(IOutputStrategy outputStrategy, ExcelTemplate excelTemplate, ExcelTransformerFactory transformerFactory, DefaultContext context) {
		this.context = context;
		this.excelTemplate = excelTemplate;
		this.outputStrategy = outputStrategy;
		this.transformerFactory = transformerFactory;
		this.init();
	}
	
	private void init() {
		this.mapSheetProcess = new LinkedHashMap<>();
		for (ExcelTemplateSheet templateSheet : excelTemplate.getTemplateSheets()) {
			OutputSheetProcess sheetProcess = new OutputSheetProcess(templateSheet);
			mapSheetProcess.put(templateSheet.getSheetName(), sheetProcess);
		}
	}

	@Override
	public void export(Document document, String documentTitle) throws Throwable {
		context.setDocument(document);
		Object detailLinkedValue = getDetailLinkedValue(document);
		outputStrategy.preOutputExcel(excelTemplate);
		for (OutputSheetProcess exportSheetProcess : mapSheetProcess.values()) {
			outputStrategy.preOutputSheet(exportSheetProcess);
			exportSheetProcess.doProcess(document, detailLinkedValue, transformerFactory, context, outputStrategy, excelTemplate.isNeedResetCellIndex());
			outputStrategy.postOutputSheet(exportSheetProcess);
		}
		outputStrategy.postOutputExcel(excelTemplate);
	}
	
	private Object getDetailLinkedValue(Document doc) {
		Object detailLinkedValue = null;
		ExcelTemplateField field = excelTemplate.getDetailLinkedField();
		if (field != null) {
			DataTable table = doc.get(field.getTableKey());
			table.first();
			if (table != null) {
				detailLinkedValue = table.getObject(field.getDefine());
			}
		}
		return detailLinkedValue;
	}

}
