package com.bokesoft.yes.excel.cmd.stamp.expand;

import java.util.List;

import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.excel.cmd.stamp.expand.work.ExcelTableDetailExpandWork;
import com.bokesoft.yes.excel.cmd.stamp.expand.work.ExcelTableHeadExpandWork;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.mid.base.BaseContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.parser.IEval;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.expand.AbstractExpandMaster;
import com.bokesoft.yigo.struct.expand.processor.DimensionItem;
import com.bokesoft.yigo.struct.expand.work.DataTableExpandWork;

/**
 * 导出excel扩展处理入口
 * 
 * @author chenbb
 *
 */
public class ExcelExpandMaster extends AbstractExpandMaster<ExcelTemplateField, ExcelTemplateField> {
	
	private DefaultContext context = null;
	
	private Document document = null;
	
	private Workbook workbook;
	
	private StampExcelStyleFactory styleFactory;
	
	public ExcelExpandMaster(Document document, Workbook workbook, StampExcelStyleFactory styleFactory, DefaultContext context) {
		this.document = document;
		this.workbook = workbook;
		this.styleFactory = styleFactory;
		this.context = context;
	}

	public void doExpand(ExcelTemplate excelTemplate) throws Throwable {
		IEval<BaseContext> eval = context.getMidParser();
		IDictCacheProxy dictCache = context.getDictCache();
		
		List<DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField>> colRootDimensionItems = null;
		for (ExcelTemplateSheet templateSheet : excelTemplate.getTemplateSheets()) {
			for (ExcelTemplateTable templateTable : templateSheet.getTemplateTables()) {
				if (templateTable.hasExpandField()) {
					DataTable baseDataTable = document.get(templateTable.getTableKey());
					TemplateDimensionsCreator dimesionsCreator = new TemplateDimensionsCreator(baseDataTable, eval, dictCache);
					colRootDimensionItems = dimesionsCreator.createDimensions(templateTable);

					ExcelTableDetailExpandWork detailExpandWork = new ExcelTableDetailExpandWork(templateTable);
					this.addExpandWork(detailExpandWork);
					
					ExcelTableHeadExpandWork headExpandWork = new ExcelTableHeadExpandWork(this.workbook, templateTable, this.styleFactory);
					this.addExpandWork(headExpandWork);
					
					DataTableExpandWork<ExcelTemplateField, ExcelTemplateField> dataTableExpandWork = new DataTableExpandWork<>(baseDataTable, this.document);
					this.addExpandWork(dataTableExpandWork);
					
					List<String> fixedFieldKeys = templateTable.getFixedFieldKeys();
					this.doWorks(fixedFieldKeys, colRootDimensionItems, null);
					this.clearWorks();
				}
			}
		}
	}
}
