package com.bokesoft.yes.excel.cmd.normal;

import java.util.HashMap;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.excel.utils.ImportBillHandler;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import com.bokesoft.yigo.util.ExcelUtils;

public class ImportExcel4Bill implements IImport {

	private Workbook workbook = null;

	private ImportBillHandler handler = null;
	
	// 上下文关系
	private DefaultContext context = null;
	
	// 保存前处理事件
	private String postServiceName = null;
	
	public ImportExcel4Bill(DefaultContext context, Workbook workbook, String postServiceName) throws Throwable {
		this.context = context;
		// 将字节流转换为work
		this.workbook = workbook;
		this.postServiceName = postServiceName;
		handler = new ImportBillHandler(context, workbook);
	}

	public Object importData() throws Throwable {
		MetaDataObject metaDataObject = handler.getDataObject();
		Sheet mainSheet = handler.getMainSheet();

		int sheetCount = workbook.getNumberOfSheets();
		String primayKey = null;
		// 第一行为隐藏行，第二行为标题行，数据从第三行开始
		int rowIndex = 2;
		
		// 记录明细表已导入的行数
		HashMap<String, Integer> sheetRow = new HashMap<String, Integer>();
		while (true) {
			String tableKey = mainSheet.getSheetName();
			MetaTable metaTable = metaDataObject.getTable(tableKey);
			if(metaTable == null) {
				LogSvr.getInstance().info("导入excel未配置主表: " + tableKey);
				return true;
			}
			
			primayKey = handler.getPrimayKey(mainSheet, rowIndex, true);
			if (primayKey.isEmpty()) {
				break;
			}
						
			Document document = DocumentUtil.newDocument(metaDataObject);
			document.setNew();
			
			DataTable dataTable = document.get(tableKey);
			if (metaTable.getTableMode() == TableMode.DETAIL) {
				DocumentUtil.newRow(metaTable, dataTable);
			} else {
				dataTable.first();
			}
			
			handler.fillImportField(metaTable, dataTable, mainSheet, rowIndex);
			
			for(int sheetIndex = 1; sheetIndex < sheetCount; sheetIndex++) {
				fillTableData(workbook.getSheetAt(sheetIndex), metaDataObject, document, sheetRow, primayKey);
			}
			
			DefaultContext newContext = new DefaultContext(context);
			newContext.setFormKey(context.getFormKey());
			
			// 参考SingleImportExcel这么写
			if (postServiceName != null && !postServiceName.isEmpty()) {
				@SuppressWarnings("unchecked")
				IServiceProcess<IServiceContext> process = (IServiceProcess<IServiceContext>) ReflectHelper.newInstance(context.getVE(), postServiceName);
				if (process != null) {
					newContext.setDocument(document);
					newContext.setDataObject(metaDataObject);
					process.process(newContext);
				}
			}
			
			//计算默认值公式
			ExcelUtils.calcDefaultFormula(document, handler.getImportFields(), context);
			
			SaveData saveData = new SaveData(metaDataObject, null, document);
			saveData.save(newContext);
			
			++rowIndex;
		}
		
		return true;
	}
	
	private void fillTableData(Sheet sheet, MetaDataObject metaDataObject, Document document, HashMap<String, Integer> sheetRow, String primayKey) throws Throwable {
		String tableKey = sheet.getSheetName();
		MetaTable metaTable = metaDataObject.getTable(tableKey);
		if (metaTable == null) {
			return;
		}
		
		int rowIndex = 2;
		if (sheetRow.containsKey(tableKey)) {
			rowIndex = sheetRow.get(tableKey);
		}
		
		DataTable dataTable = document.get(tableKey);
		dataTable.first();
		
		while(true) {
			String curPrimayKey = handler.getPrimayKey(sheet, rowIndex, false); 
			if (!curPrimayKey.equalsIgnoreCase(primayKey)) {
				sheetRow.put(tableKey, rowIndex);
				break;
			}
			
			if (metaTable.getTableMode() == TableMode.DETAIL) {
				DocumentUtil.newRow(metaTable, dataTable);
			}
			
			handler.fillImportField(metaTable, dataTable, sheet, rowIndex);
			rowIndex++;
		}
	}
}
