package com.bokesoft.yes.excel.cmd.normal;

import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.csv.cmd.normal.IExportPostProcess;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.excel.IExportService;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.usrpara.Paras;
import com.bokesoft.yigo.util.ExcelUtils;

public class ExportExcelCmd extends DefaultServiceCmd {

	private String formKey = null;
	private Document document = null;
	private FilterMap filterMap = null;
	private ConditionParas condParameters = null;
	private String exportTables = null;
	private boolean onlyCurrentPage = false;
	private String exportServiceName = null;
	private String postExportServiceName = null;
	private String exportFileName=null;
	private boolean needDownload = false;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		String parameters = TypeConvertor.toString(arguments.get("parameters"));
		if (parameters != null && !parameters.isEmpty()) {
			JSONObject json = new JSONObject(parameters);
			Paras formParameters = new Paras();
			formParameters.fromJSON(json);
			context.setParas(formParameters);
		}
		
		formKey = arguments.get("formKey").toString();
		exportTables = arguments.get("exportTables").toString();
		onlyCurrentPage = TypeConvertor.toBoolean(arguments.get("onlyCurrentPage"));
		needDownload = TypeConvertor.toBoolean(arguments.get("needDownload"));
		exportServiceName = TypeConvertor.toString(arguments.get("exportServiceName"));
		postExportServiceName = TypeConvertor.toString(arguments.get("postExportServiceName"));
		exportFileName=TypeConvertor.toString(arguments.get("exportFileName"));
		
		JSONObject documentObj = new JSONObject(arguments.get("document").toString());
		long oid = TypeConvertor.toLong(arguments.get("OID"));
		
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
		
		filterMap = new FilterMap();
		filterMap.setOID(oid);
		String filterMapJSONStr = arguments.get("filterMap").toString();
		filterMap.fromJSON(new JSONObject(filterMapJSONStr));
		
		// 处理查询条件
		String conditions = arguments.get("condition").toString();
		if ( conditions != null && !conditions.isEmpty() ) {
			condParameters = new ConditionParas();
			condParameters.fromJSON(new JSONObject(conditions));
		}
		
		document = new Document(metaDataObject, oid);
		document.fromJSON(documentObj);
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		
		if( document == null ){
			return null;
		}
	
		context.setFormKey(formKey);
		
		// 如果没有二开,使用平台默认实现
		IExportService importService = ExcelUtils.getExpService(context, exportServiceName);
		if (importService == null) {
			importService = new DefaultExportExcelService();
		}
		
		FileData fileData = importService.exportData(context, document, filterMap, condParameters, exportTables, postExportServiceName, onlyCurrentPage, exportFileName,needDownload);
		
		IExportPostProcess process = ExcelUtils.getPostExtProcess(context, postExportServiceName);
		if( process != null ) {
			process.process(context, fileData);
		}
		if(needDownload){
			return fileData;
		}else{
			return new FileData();
		}
		
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ExportExcelCmd();
	}

	@Override
	public String getCmd() {
		return "ExportExcel";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}