package com.bokesoft.yes.dts.util;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.meta.factory.MetaFactory;

public class FileUtil {
	
	public static FileData toFileData(File file){
		FileData fileData = new FileData();
		fileData.setFileName(file.getName());
		fileData.setData(com.bokesoft.yigo.common.util.FileUtil.File2byte(file));
		return fileData;
	}
	
	public static List<FileData> toFileDatas(List<File> list) {

		List<FileData> fileDatas = null;
		if(list != null && !list.isEmpty()){
			fileDatas = new ArrayList<FileData>();
			for(File f : list){
				fileDatas.add(toFileData(f));
			}
		}
		
		return fileDatas;
	}
	
	public static File createTempFile(FileData fileData, String folderName) throws Throwable{
		Date curDateTime = new Date();
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
		String date = dateFormat.format(curDateTime);

		String dirPath = MetaFactory.getGlobalInstance().getSolution().getDataPath();
		if (dirPath == null || dirPath.equals("")) {
			dirPath = System.getProperty("java.io.tmpdir");
		}
		
		String dataPath = dirPath + File.separator + "Temp" + File.separator + folderName + File.separator + date;

		String suffix = getSuffix(fileData.getFileName());
		String filePath = dataPath + File.separator + UUID.randomUUID();
		if(suffix != null && !suffix.isEmpty()){
			filePath += "."+suffix;
		}
		
		File file = new File(filePath);
		if (!file.getParentFile().exists()) {
			file.getParentFile().mkdirs();
		}
		FileOutputStream fout = null;
		try {
			fout = new FileOutputStream(file);
			fout.write(fileData.getData());
		} catch(Throwable e){
			e.printStackTrace();
			return null;
		} finally {
			if (fout != null) {
				fout.close();
			}
		}

		return file;
	}

	/**
	 * 获取后缀名
	 * @param path 文件路径
	 * @return
	 */
	private static String getSuffix(String path) {
		int index = path.lastIndexOf(".");
		if(index > 0){
			return path.substring(path.lastIndexOf(".") + 1);
		}
		return "";
	}
	
	public static void deleteFile(String filePath) {
		File file = new File(filePath);
		if (file.exists()) {
			file.delete();
		}
	}
	
	public static void deleteFiles(List<String> filePathList) {
		for (String filePath : filePathList) {
			File file = new File(filePath);
			if (file.exists()) {
				file.delete();
			}
		}
	}

}
