/**
 * 
 */
package com.bokesoft.yes.dts.result;

import java.util.List;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.dts.DTSException;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 默认的结果提供者
 * @author lingc
 *
 */
public class ResultProvider implements IResultProvider {
		
	public Object getResult(
			Document doc, 
			List<String> returnFields, 
			Map<String, Integer[]> bookmarksMap) throws Throwable{
		if(returnFields == null)
			return true;
		/*如果最后没有数据返回，不是返回{}，而是返回true*/
		boolean hasData = false;
		
		JSONObject result = new JSONObject();
		for(String field: returnFields){
			String[] tokens = field.split("\\.");
			//没有表名，默认主表字段
			if(tokens.length == 1){
				String columnKey = tokens[0];
				String mainTableKey = doc.getMetaDataObject().getMainTableKey();
				DataTable mainTable = doc.get(mainTableKey);
				if(mainTable == null)
					throw new DTSException(DTSException.NO_PRIMARY, "没有主表: "+mainTableKey);
				Object value = null;
				//指定的需要返回的字段不一定有效，如果无效就忽略它。
				try{
					value = mainTable.getObject(0, columnKey);
				}
				catch(IndexOutOfBoundsException e){
					/*columnKey不正确, 忽略这个字段*/
					continue;
				}
				//如果是null值，需要特别地指定JSONObject.NULL
				if(value != null)
					result.put(columnKey, value);
				else
					result.put(columnKey, JSONObject.NULL);
				hasData = true;
			}
			//表名.列名
			else if(tokens.length == 2){
				String tableKey = tokens[0];
				String columnKey = tokens[1];
				Integer[] bookmarks = null;
				/*如果没有bookmarksMap， 就是返回所有*/
				if(bookmarksMap != null)
					bookmarks = bookmarksMap.get(tableKey);
				DataTable table = doc.get(tableKey);
				/*无效的tableKey, 忽略*/
				if(table == null)
					continue;
				JSONArray jsonTable = null;
				/*如果有这张表就get，没有就put*/
				if(result.has(tableKey)){
					jsonTable = result.getJSONArray(tableKey);
				}
				else{
					jsonTable = new JSONArray();
					int length;
					if(bookmarks == null)
						length = table.size();
					else
						length = bookmarks.length;
					for(int i = 0; i < length; i++){
						JSONObject row = new JSONObject();
						jsonTable.put(row);
					}
					result.put(tableKey, jsonTable);
				}
				/*有了table之后，往jsonarray的每一个元素中添加column*/
				if(bookmarks != null){
					for(int i = 0; i < bookmarks.length; i++){		
						/*setPos , get*/
						table.setBookmark(bookmarks[i]);
						Object value = null;
						try{
							value = table.getObject(columnKey);
						}
						catch(IndexOutOfBoundsException e){
							/*columnKey不正确, 忽略这个字段*/
							break;
						}
						JSONObject row = (JSONObject)jsonTable.get(i);
						if(value != null)
							row.put(columnKey, value);
						else
							row.put(columnKey, JSONObject.NULL);
					}
				}
				else{
					table.beforeFirst();
					for(int i = 0; i < table.size(); i++){
						table.next();
						Object value = null;
						try{
							value = table.getObject(columnKey);
						}
						catch(IndexOutOfBoundsException e){
							/*columnKey不正确, 忽略这个字段*/
							break;
						}
						JSONObject row = (JSONObject)jsonTable.get(i);
						//row.put(columnKey, value);
						if(value != null)
							row.put(columnKey, value);
						else
							row.put(columnKey, JSONObject.NULL);
					}
				}
				hasData = true;
			}
			//错误的字段格式
			else{
				continue;
			}
		}
		if(hasData == true)
			return result;
		else
			return true;
	}
	
	
}
	
	

