/**
 * 
 */
package com.bokesoft.yes.dts.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.dts.types.OperationTypes;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import com.bokesoft.yigo.tools.document.DocumentUtil;

/**
 * 默认的DTSData提供者
 * @author lingc
 *
 */
public class DTSDataProvider implements IDTSDataProvider{

	public DTSDataProvider(){
		
	}
	
	private DTSDataBuilder builder = new DTSDataBuilder();
	
	public DTSData getDTSData(String jsonString, DefaultContext context) throws Throwable {
		JSONObject jsonObject = new JSONObject(jsonString);
		
		String operation = jsonObject.optString(META_KEY_OP_PLAN, null);
		OperationTypes type = OperationTypes.DEFAULT;
		if (operation != null && !operation.isEmpty()) {
			type = getOperationType(operation);
		}
		
		/*处理formkey，dataobjectkey. 获取MetaDataObject*/
		MetaDataObject metaDataObject = null;
		String formKey = jsonObject.optString(META_KEY_FORMKEY, null);
		if(formKey != null ){
			MetaForm metaForm = context.getVE().getMetaFactory().getMetaForm(formKey);
			metaDataObject = metaForm.getDataSource().getDataObject();
			builder.formKey(formKey);
			builder.dataObjectKey(metaDataObject.getKey());
		}else{
			String dataObjectKey = jsonObject.optString(META_KEY_THING_NAME,null);
			if(dataObjectKey == null)
				throw new RuntimeException("找不到数据对象配置，form key:"+formKey+" data object key:"+dataObjectKey); 
			metaDataObject = context.getVE().getMetaFactory().getDataObject(dataObjectKey);	
			builder.dataObjectKey(dataObjectKey);
		}
		/*document*/
		
		Document document = null;
		if (type == OperationTypes.UPDATE || type == OperationTypes.I_OR_U ) {
			document = new Document(metaDataObject, -1);

			MetaTableCollection metaTableCollection = metaDataObject.getTableCollection();
			Iterator<MetaTable> it = metaTableCollection.iterator();
			MetaTable metaTable = null;
			while (it.hasNext()) {
				metaTable = it.next();
				DataTable table = DataTableUtil.newEmptyDataTable(metaTable);
				if (metaTable.getTableMode() == TableMode.HEAD) {
					table.append();
				}
				document.add(metaTable.getKey(), table);
			}
		} else {
			document = DocumentUtil.newDocument(metaDataObject);
		}
		builder.document(document);
		
		//遍历
		Set<String> tableKeySet = new HashSet<String>();
		Map<String, List<String>> primaryMap = new HashMap<String, List<String>>();
		Map<String, List<OperationTypes>> opMap = new HashMap<String, List<OperationTypes>>();
		/*用来保存主表字段*/
		Map<String, String> hashMap = new HashMap<String,String>();
		/*遍历json的key集合*/
		for(Object obj: jsonObject.keySet()){
			String key = (String) obj;
			Object value = jsonObject.get(key);
			if( value == null || value == JSONObject.NULL){
				/*没有指定key对应的值*/
				//throw new RuntimeException(key+"没有值");
			}
			else if( value instanceof Integer){
				/*不是属性, 头表的字段*/
				if(searchArray(key) == false)
					hashMap.put(key, value.toString());				
			}
			/*value是JSONArray, 表示一张表*/
			else if( value instanceof JSONArray){
				JSONArray jsonArray = (JSONArray)value;
				/*表的结构要根据实际数据来构造*/
				if( jsonArray.length() == 0)
					throw new IllegalArgumentException("表: "+key+" 没有数据. json: "+value.toString());
				/*第一行数据*/
				Object firstRow = jsonArray.get(0);
				/*每一行数据都必须是JSONObject*/
				if( firstRow instanceof JSONObject == false)
					throw new IllegalArgumentException("表:"+key+"第一行格式错误."+firstRow.toString());
				JSONObject peek = (JSONObject)firstRow;
//				/*根据第一行数据得到业务关键字, 保存到dtsData*/
				List<String> ids = getIDs(peek);
				primaryMap.put(key, ids);
//				/*根据第一行数据得到表的结构*/
//				DataTable dataTable = newEmptyDataTable(peek);
				DataTable dataTable = document.get(key);
				/*保存每一行操作的数组*/
				int length = jsonArray.length();
				List<OperationTypes> opArray = new ArrayList<OperationTypes>();
				/*开始处理每一行*/
				dataTable.first();
				for(int i = 0; i < length; i++){
					/*每一行数据都必须是JSONObject, 否则会抛出异常*/
					JSONObject row = jsonArray.getJSONObject(i);
					OperationTypes op = append(document, row, dataTable, metaDataObject.getMetaTable(key), primaryMap, opMap, tableKeySet, -1);
					opArray.add(op);
				}
				/*保存操作类型*/
				opMap.put(key, opArray);
				tableKeySet.add(key);
			} else {
				/*不是属性, 头表的字段*/
				if(searchArray(key) == false)
					hashMap.put(key, TypeConvertor.toString(value));
			}
			
		}
		//主表的数据
		String mainKey = metaDataObject.getMainTableKey();
		DataTable mainTable = document.get(mainKey);
		for(MetaColumn metaColumn: metaDataObject.getMetaTable(mainKey)){
			String columnKey = metaColumn.getKey();
			String raw = hashMap.get(columnKey);
			//穿过来的数据有这一列的值
			if(raw != null){
				Object value = TypeConvertor.toDataType(metaColumn.getDataType(), raw);
				mainTable.setObject(columnKey, value);
			}
		}
		
		/*opMap 主表部分*/
		String opString = jsonObject.optString(META_KEY_OP_PLAN, null);
		if(opString != null){
			OperationTypes op = getOperationType(opString);
			builder.operation(op);
			List<OperationTypes> mainTableOp = new ArrayList<OperationTypes>();
			mainTableOp.add(op);
			opMap.put(mainKey, mainTableOp);
		}
		builder.opMap(opMap);
		
		/* primaryMap 主表部分*/
		List<String> mainTableIDs = getIDs(jsonObject);
		primaryMap.put(mainKey, mainTableIDs);
		builder.primaryMap(primaryMap);
		/*insertCheck. 默认0，代表不检查，updateCheck为false*/
		int intInsertCheck = jsonObject.optInt(META_KEY_INSERT_CHECK_UNIQUE, 0);
		if(intInsertCheck != 0 && intInsertCheck != 1)
			not01exception(META_KEY_INSERT_CHECK_UNIQUE);
		boolean insertCheck = intInsertCheck == 0 ? false : true;
		builder.insertCheck(insertCheck);
		/*updateCheck. 默认0，代表不忽略，需要检查，updateCheck为true*/
		int intUpdateCheck = jsonObject.optInt(META_KEY_UPDATE_NOTHING_IGNORE, 0);
		if(intUpdateCheck != 0 && intUpdateCheck != 1)
			not01exception(META_KEY_UPDATE_NOTHING_IGNORE);
		boolean updateCheck = intUpdateCheck == 0 ? true : false;
		builder.updateCheck(updateCheck);
		/*startInstance. 默认1，代表启用流程。startworkflow设为true.*/
		int intStart = jsonObject.optInt(META_KEY_START, 1);
		if(intStart != 0 && intStart != 1)
			not01exception(META_KEY_START);
		boolean start = intStart == 1 ? true : false;
		builder.startInstance(start);
		
		/*deleteUnknown*/
		Set<String> deleteUnknownSet = new HashSet<String>();
		String deleteString = jsonObject.optString(META_KEY_DELETE_UNKNOWN_DETAIL, null);
		if(deleteString != null){
			if(deleteString.equalsIgnoreCase("*")){
//				dtsData.setDeleteUnknownAllTable(true);
				for(String deleteKey: tableKeySet)
					deleteUnknownSet.add(deleteKey);
			}
			else{
				String[] tableKeys = deleteString.replace(" ", "").split(",");
				for(String tableKey: tableKeys)
					/*直接加进去，不用考虑是否重复,或者是否存在*/
					deleteUnknownSet.add(tableKey);
			}
			builder.deleteUnknownSet(deleteUnknownSet);		
		}
		
		/*return fields*/
		List<String> returnFields = new ArrayList<String>();
		String returnFieldsString = jsonObject.optString(META_KEY_RETURN, null);
		if(returnFieldsString != null){
			String[] returnFieldArray= returnFieldsString.replace(" ", "").split(",");
			Collections.addAll(returnFields, returnFieldArray);
			builder.returnFields(returnFields);
		}
		
		/*processKey*/
		String processKey = jsonObject.optString(META_KEY_WORKFLOWKEY, null);
		if(processKey != null)
			builder.processKey(processKey);
		
		return builder.build();
	}  
	
	/**
	 * 解析operation
	 * @param operation 操作的String表示
	 * @return operation的int表示
	 */
	private static OperationTypes getOperationType(String operation){
		if(operation == null || operation.isEmpty())
			return OperationTypes.DEFAULT;
		if(operation.equalsIgnoreCase(STRING_INSERT))
			return OperationTypes.INSERT;
		else if(operation.equalsIgnoreCase(STRING_DELETE))
			return OperationTypes.DELETE;
		else if(operation.equalsIgnoreCase(STRING_I_OR_U))
			return OperationTypes.I_OR_U;
		else if(operation.equalsIgnoreCase((STRING_UPDATE)))
			return OperationTypes.UPDATE;
		else
			throw new IllegalArgumentException("未知的操作:"+operation);
	}


	public DefaultContext getContext(DefaultContext context) throws Throwable{
		return new DefaultContext(context);
	}
	
	/**
	 * 直接根据表的配置， 去行的json里面拿数据，冗余的数据会忽略
	 * @param row
	 * @param dataTable
	 * @param metaTable
	 * @return
	 * @throws Throwable
	 */
	private static OperationTypes append(Document document, JSONObject jsonObject, DataTable dataTable, MetaTable metaTable, Map<String, List<String>> primaryMap, Map<String, List<OperationTypes>> opMap, Set<String> tableKeySet, int parentBkmk) throws Throwable{
		if(metaTable.getTableMode() == TableMode.DETAIL) {
			dataTable.append();
			if(parentBkmk != -1) {
				dataTable.setParentBookmark(parentBkmk);
			}
		}
		for(Object obj: jsonObject.keySet()){
			String key = (String) obj;
			MetaColumn metaColumn = metaTable.get(key);
			Object value = jsonObject.get(key);
			if( value == null || value == JSONObject.NULL){
				/*没有指定key对应的值*/
				//throw new RuntimeException(key+"没有值");
			}
			/*value是JSONArray, 表示一张表*/
			else if( value instanceof JSONArray){
				JSONArray jsonArray = (JSONArray)value;
				/*表的结构要根据实际数据来构造*/
				if( jsonArray.length() == 0)
					throw new IllegalArgumentException("表: "+key+" 没有数据. json: "+value.toString());
				/*第一行数据*/
				Object firstRow = jsonArray.get(0);
				/*每一行数据都必须是JSONObject*/
				if( firstRow instanceof JSONObject == false)
					throw new IllegalArgumentException("表:"+key+"第一行格式错误."+firstRow.toString());
				JSONObject peek = (JSONObject)firstRow;
//				/*根据第一行数据得到业务关键字, 保存到dtsData*/
				List<String> ids = getIDs(peek);
				primaryMap.put(key, ids);
//				/*根据第一行数据得到表的结构*/
//				DataTable dataTable = newEmptyDataTable(peek);
				DataTable detail = document.get(key);
				MetaTable detailTable = document.getMetaDataObject().getMetaTable(key);
				/*保存每一行操作的数组*/
				int length = jsonArray.length();
				List<OperationTypes> opArray = new ArrayList<OperationTypes>();
				/*开始处理每一行*/
				detail.first();
				for(int i = 0; i < length; i++){
					/*每一行数据都必须是JSONObject, 否则会抛出异常*/
					JSONObject row = jsonArray.getJSONObject(i);
					OperationTypes op = append(document, row, detail, detailTable, primaryMap, opMap, tableKeySet, dataTable.getBookmark());
					opArray.add(op);
				}
				/*保存操作类型*/
				opMap.put(key, opArray);
				tableKeySet.add(key);
			} else {
				if(metaColumn == null) {
					continue;
				}
				/*不是属性, 头表的字段*/
				if(searchArray(key) == false) {
					value = TypeConvertor.toDataType(metaColumn.getDataType(), value);
					dataTable.setObject(key, value);
				}
			}

		}
		
		String op = jsonObject.optString(META_KEY_OP_PLAN, null);
		return getOperationType(op);	
	}
	
	private static final boolean searchArray(String key){
		for(String keyWord: keyWords){
			if( key.equalsIgnoreCase(keyWord))
				return true;
		}
		return false;
	}
	
	/**
	 * 解析获取表的业务关键字
	 * @param row 表示行数据的JSONObject
	 * @return 业务关键字集合，没有则为null
	 */
	private static List<String> getIDs(JSONObject row){
		String IDString = row.optString(META_KEY_ID_FIELDS,null);
		/*没有业务关键字， 如果指定了insert之外的操作，是不允许的*/
		if(IDString == null){
			return null;
		}
		else{
			String[] IDs = IDString.replace(" ","").split(",");
			List<String> result = new ArrayList<String>();
			Collections.addAll(result, IDs);
			return result;
		}
	}
	
	private static void not01exception(String key){
		throw new IllegalArgumentException(key+"属性只能为0或1");
	}
	
	public static final String STRING_INSERT = "insert";
	
	public static final String STRING_UPDATE = "update";
	
	public static final String STRING_DELETE = "delete";
	
	public static final String STRING_I_OR_U = "insert-or-update";
	
	
}
