package com.bokesoft.yes.dts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.TreeMap;

import com.bokesoft.yes.common.util.CompareUtil;
import com.bokesoft.yes.dts.data.DTSData;
import com.bokesoft.yes.dts.result.IResultProvider;
import com.bokesoft.yes.dts.result.ResultProvider;
import com.bokesoft.yes.dts.types.OperationTypes;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yes.struct.datatable.filter.FilterEval;
import com.bokesoft.yes.struct.datatable.filter.FilterRow;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;

public class Update {

	private MetaDataObject metaDataObject;
	private DTSData dtsData;
	/**
	 * 本地文档
	 */
	private Document localDocument;
	/**
	 * 接收文档
	 */
	private Document document;
	
	private DefaultContext context;
	
	public Update(MetaDataObject metaDataObject, DTSData dtsData, Document localDocument, Document document,
			DefaultContext context) {
		super();
		this.metaDataObject = metaDataObject;
		this.dtsData = dtsData;
		this.localDocument = localDocument;
		this.document = document;
		this.context = context;
	}

	/*记录哪些数据行是要返回的*/
	private Map<String, Integer[]> bookmarksMap = new HashMap<String, Integer[]>();
	
	public Object update() throws Throwable{

		
		// 维护父子表格的PBK关系
		for (MetaTable metaTable : metaDataObject.getTableCollection()) {
			if (metaTable.getLevelID() > 2) {
				DataTable table = localDocument.get(metaTable.getKey());
				DataTable pTable = localDocument.get(metaTable.getParentKey());
				if (pTable != null && table != null) {
					int pos = table.getPos();
					int pPos = pTable.getPos();
					TreeMap<Long, Integer> map = new TreeMap<>();
					pTable.beforeFirst();
					while (pTable.next()) {
						Long OID = pTable.getLong(SystemField.OID_SYS_KEY);
						Integer bookmark = pTable.getBookmark();
						map.put(OID, bookmark);
					}

					table.beforeFirst();
					while (table.next()) {
						Integer bookmark = map.get(table.getLong(SystemField.POID_SYS_KEY));
						if (bookmark != null) {
							table.setParentBookmark(bookmark);								
						}
					}
					table.setPos(pos);
					pTable.setPos(pPos);
				}
			}
		}
		
		/*每个本地表和接收表逐行对比*/
		for (MetaTable metaTable : metaDataObject.getTableCollection()){
			if(metaTable.getLevelID() > 2) {
				// 子明细 不做处理， 处理父表时一并处理
				continue;
			}
			String key = metaTable.getKey();
			/*业务关键字*/
			List<String> primaryKeys = dtsData.getPrimary(key);
			
			
			/*本地表*/
			DataTable table1 = localDocument.get(key);
			/*接收表*/
			DataTable table2 = document.get(key);
			/*记录合并后原来接收的数据在新的表中的位置，返回字段的时候需要*/
			List<Integer> array = null;
			/*有业务关键字， 涉及UPDATE, INSERT, DELETE*/
			if(primaryKeys != null){
				array = merge(primaryKeys, 
						table1,
						table2,
						dtsData.getTableOp(key),
						/*对于是否删除未匹配，可能设置了所有表，也可能特别设置了某些表*/
//						dtsData.deleteUnknown(key)||dtsData.isDeleteUnknownAllTable(),	
						dtsData.deleteUnknown(key),
						dtsData.isUpdateCheck(),
						dtsData.isInsertCheck(),
						metaTable,
						-1);
			}
			/*没有业务关键字，只涉及INSERT*/
			else
				/*对于是否删除未匹配，可能设置了所有表，也可能特别设置了某些表*/
				array = simpleMerge(dtsData.deleteUnknown(key), table1, table2, metaTable);
			if(array != null) {
				bookmarksMap.put(key, array.toArray(new Integer[0]));
			}
		}
		localDocument.setModified();
		SaveData saveData = new SaveData(metaDataObject, null, localDocument);
		localDocument = saveData.save(context);
		/*返回数据处理*/
		IResultProvider resultProvider = new ResultProvider();
		Object result = resultProvider.getResult(localDocument, 
				dtsData.getReturnFields(),
				bookmarksMap);
		return result;
	}
	
	private final List<Integer> merge(List<String> primaryKeys, DataTable table1, DataTable table2, List<OperationTypes> opArray, boolean delete, boolean updateCheck, boolean insertCheck, MetaTable metaTable, int parentBookmark) throws Throwable {	
		/*需要返回一个数组，记录table2在合并后的表中的bookmark*/
		int size = table2.size();
		/*传过来的表是空的，什么都不做*/
		if(size == 0)
			return null;
		List<Integer> bookmarkArray = new ArrayList<Integer>();
		/*建立table2的业务关键字到index的map*/
		Map<ArrayList<Object>, Integer> map = new HashMap<ArrayList<Object>, Integer>();		
		table2.beforeFirst();
		int index = 0;
		while(table2.next()){
			ArrayList<Object> array = new ArrayList<Object>();
			for(String key: primaryKeys){
				Object value = table2.getObject(key);
				if(value == null)
					throw new DTSException(DTSException.KEY_COLUMN_NODATA,"传送的数据在业务关键字:"+key+"上是NULL");
				array.add(value);
			}
			/*传过来的数据在关键字上重复*/
			if( map.put( array, new Integer(index) ) != null )
				throw new DTSException(DTSException.DUPLICATE_DETAIL,"传入的明细在业务关键字上有重复");
			index++;
		}
		
		MetaTable childTable = MetaUtil.getChildMetaTable(metaDataObject, metaTable.getKey());
		List<Integer> childList = new ArrayList<Integer>();
		
		/*遍历table1，查每一行数据是否在table2中*/
		table1.beforeFirst();
		while(table1.next()){
			ArrayList<Object> array = new ArrayList<Object>();
			for(String key: primaryKeys){
				Object value = table1.getObject(key);	
				array.add(value);
			}
			Integer value = map.get( array );
			/*有这条数据*/
			if(value != null){
				/*记录bookmark*/
				bookmarkArray.add(table1.getBookmark());	
				/*在table2中的索引*/
				int index2 = value.intValue();				
				/*可能是delete, insert, update, 由opArray决定. -1 默认UPDATE*/
				OperationTypes op = OperationTypes.DEFAULT;
				if( opArray!= null )
					op = opArray.get(index2);
				/*删除一行*/
				if( op == OperationTypes.DELETE)
					table1.setState(RowState.DELETED);
				/*插入重复的一行*/
				else if( op == OperationTypes.INSERT ){
					/*不允许插入重复的数据*/
					if(insertCheck == true)
						continue;
					/*插入新的一行*/
					else{
//						table1.append();
						DocumentUtil.newRow(metaTable, table1);
						copyRow(table1, table1.getPos(), table2, index2);
						table1.setParentBookmark(parentBookmark);
						table1.setState(RowState.NEW);
					}
				}
				/*修改一行, 默认操作*/
				else if( op == OperationTypes.UPDATE || op == OperationTypes.I_OR_U || op == OperationTypes.DEFAULT){
					copyRow(table1, table1.getPos(), table2, index2);
					table1.setState(RowState.MODIFIED);
				}
				
				map.remove(array);
				
				if(childTable != null) {
					DataTable subDetail1 = getSubDetail(childTable, localDocument, table1.getBookmark());
					DataTable subDetail2 = getSubDetail(childTable, document, getBookmark(table2, primaryKeys, array));
					try {
						String childKey = childTable.getKey();
						// 合并子明细
						List<Integer> bkmks = merge(dtsData.getPrimary(childKey), subDetail1, subDetail2, dtsData.getTableOp(childKey), dtsData.deleteUnknown(childKey), dtsData.isUpdateCheck(), dtsData.isInsertCheck(), childTable, table1.getBookmark());	
						childList.addAll(bkmks);
					}finally {
						if(subDetail1 != null) {
							subDetail1.setFilterEval(null);
							subDetail1.filter();
						}
						if(subDetail2 != null) {
							subDetail2.setFilterEval(null);
							subDetail2.filter();
						}
					}
				}
			}
			/*没有这条数据*/
			else{
				if(delete == true)
					table1.setState(RowState.DELETED);
			}
		}

		/*处理table2有，而table1没有的行*/
		Iterator<Entry< ArrayList<Object> , Integer> > iterEntry = map.entrySet().iterator();
		while(iterEntry.hasNext()){
			int index2 = iterEntry.next().getValue();
			OperationTypes op = OperationTypes.DEFAULT;
			if(opArray != null)
				op = opArray.get(index2);
			/*指定了update操作，但是根据业务关键字找不到对应的行. 根据updateCheck来决定是否抛出异常*/
			if( op == OperationTypes.UPDATE )
				if(updateCheck == true)
					throw new DTSException(DTSException.UPDATE_DETAIL_NOT_EXIST,"要更新的明细找不到:"+iterEntry.next().getKey());
				else
					continue;
			/*指定i_or_u, insert， 默认操作*/
			else if( op == OperationTypes.I_OR_U || op == OperationTypes.INSERT || op == OperationTypes.DEFAULT){
//				int index1 = table1.append();
				int index1 = DocumentUtil.newRow(metaTable, table1);
				copyRow(table1, index1, table2, index2);
				table1.setParentBookmark(parentBookmark);
				table1.setState(RowState.NEW);
				/*记录bookmark*/
				bookmarkArray.add(table1.getBookmark());
				
				if(childTable != null) {
					DataTable subDetail1 = getSubDetail(childTable, localDocument, table1.getBookmark());
					DataTable subDetail2 = getSubDetail(childTable, document, table2.getBookmark(index2));
					
					try {
						List<Integer> bkmks = simpleMerge(dtsData.deleteUnknown(childTable.getKey()), subDetail1, subDetail2, childTable);
						childList.addAll(bkmks);
					}finally {
						if(subDetail1 != null) {
							subDetail1.setFilterEval(null);
							subDetail1.filter();
						}
						if(subDetail2 != null) {
							subDetail2.setFilterEval(null);
							subDetail2.filter();
						}
					}
				}
				
			}
			/*指定delete，忽略*/
			else if( op == OperationTypes.DELETE){
				
			}
			else
				throw new DTSException(DTSException.UNKNOWN_OPERATION, "未知的操作："+op);
		}
		
		if(childTable != null) {
			bookmarksMap.put(childTable.getKey(), childList.toArray(new Integer[0]));
		}
		return bookmarkArray;
	}
	
	private int getBookmark(DataTable dt, List<String> primaryKeys, ArrayList<Object> values) {

		for(int i = 0; i < dt.size(); i++) {
			ArrayList<Object> array = new ArrayList<Object>();
			for(String key: primaryKeys){
				Object value = dt.getObject(i, key);	
				array.add(value);
			}
			if(values.containsAll(array)) {
				return dt.getBookmark(i);
			}
		}
		return -1;
	}
	
	private DataTable getSubDetail(MetaTable childTable, Document document, int parentBookmark) throws Throwable{
		DataTable subDetail = document.get(childTable.getKey());
		subDetail.setFilterEval(new FilterEval() {
			@Override
			public boolean needCheck() throws Throwable {
				return true;
			}

			@Override
			public void init(DataTable table) throws Throwable {
			}

			@Override
			public boolean filterCheck(FilterRow row) throws Throwable {
				return CompareUtil.compare(row.getParentBookmark(), parentBookmark) == 0;
			}
		});
		subDetail.filter();
		return subDetail;
	}
	
	/**
	 * 简单地合并两张表, 结果存在table1中。
	 * @param delete 是否删除table1原来的数据
	 * @param table1
	 * @param table2
	 * @return 新加入的数据行的bookmark数组
	 */
	private static List<Integer> simpleMerge(boolean delete, DataTable table1, DataTable table2, MetaTable metaTable) throws Throwable{
		
		table1.beforeFirst();
		if(delete == true){
			while(table1.next())
				table1.setState(RowState.DELETED);
		}
		
		/*处理table2的数据*/
		int size = table2.size();
		if(size == 0)
			return null;
		List<Integer> array = new ArrayList<Integer>();
		int index = 0;
		
		
		DataTableMetaData tgtMetaData = table1.getMetaData();
		ColumnInfo tgtCoInfo = null;
		Iterator<MetaColumn> it = null;
		String key = null;
		table2.beforeFirst();
		while ( table2.next() ) {
			if(metaTable.getTableMode() == TableMode.DETAIL) {
				DocumentUtil.newRow(metaTable, table1);
			}
			array.add(table1.getBookmark());
			it = metaTable.iterator();
			while( it.hasNext() ){
				key = it.next().getKey();
				if(systemFields.contains(key))
					continue;
				Object value = table2.getObject(key);
				if(value != null) {
					tgtCoInfo = tgtMetaData.getColumnInfo(key);
					if(tgtCoInfo != null){
						table1.setObject(key, TypeConvertor.toDataType(tgtCoInfo.getDataType(), table2.getObject(key)));
					}
				}
			}
			if( table2.getParentBookmark() != -1 ) {
				table1.setParentBookmark(table2.getParentBookmark());
			}
		}
		return array;
	}
	
	/**
	 * 把table2中index2行复制到table1的index1行, 原先行被清除，根据table1的格式
	 * @param table1
	 * @param index1
	 * @param table2
	 * @param index2
	 */
	private static final void copyRow(DataTable table1, int index1, DataTable table2, int index2){
		int colSize = table1.getMetaData().getColumnCount();
		table1.setPos(index1);
		for(int i = 0; i < colSize; i++ ){
			String key = table1.getMetaData().getColumnInfo(i).getColumnKey();
			//不拷贝系统字段
			if(systemFields.contains(key))
				continue;
			Object value = table2.getObject(index2, key);
			//有值才拷贝
			if(value != null )
				table1.setObject(i, value);
			
		}
	}
	
	private static final ArrayList<String> systemFields = new ArrayList<String>(Arrays.asList(
			SystemField.OID_SYS_KEY, SystemField.SOID_SYS_KEY, SystemField.POID_SYS_KEY, 
			SystemField.VERID_SYS_KEY, SystemField.DVERID_SYS_KEY,
			SystemField.NO_SYS_KEY, SystemField.MAPKEY_SYS_KEY, SystemField.SRCOID_SYS_KEY, SystemField.SRCSOID_SYS_KEY, 
			SystemField.MAPCOUNT_SYS_KEY, SystemField.SLOCK_SYS_KEY, SystemField.SEQUENCE_SYS_KEY, 
			SystemField.HVER_SYS_KEY, SystemField.HVERM_SYS_KEY, SystemField.SVERID_SYS_KEY, SystemField.SUBMITTER_FIELD_KEY));
	
}
