package com.bokesoft.yes.design;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoad;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.schema.ObjSchemaProvider;
import com.bokesoft.yes.mid.schema.SchemaMaintance;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.setting.MetaSimpleSetting;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class SaveGridTemplateCmd extends DefaultServiceCmd {
	private String key = "";
	private String xml = "";
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		this.key = (String)arguments.get("key");
		this.xml = (String)arguments.get("xml");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
//		if ( true ) {
//			return true;
//		}
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaSetting setting = metaFactory.getSetting();
		String projectKey = "";
		String path = "";
		if ( setting != null ) {
			MetaSimpleSetting simpleSetting = setting.getSimpleSetting("GridDesignTarget");
			if ( simpleSetting != null ) {
				projectKey = simpleSetting.get("Project");
				path = simpleSetting.get("Path");
			}
		}
		if ( !projectKey.isEmpty() && !path.isEmpty() ) {
			IMetaResolver resolver = metaFactory.getProjectResolver(projectKey);
			String resource = "Form/" + path + "/" + key + ".xml";
			resolver.write(resource, xml.getBytes("utf-8"));
			
			MetaFormList formList = metaFactory.getMetaFormList();
			if ( formList.containsKey(key) ) {
				metaFactory.reloadMetaForm(this.key);
			} else {
				// 新增的情况下，直接将表单配置加到配置工厂
				MetaFormLoad formLoad = new MetaFormLoad(AppRunType.App);
				formLoad.load(resolver, resource);
				MetaForm newMetaForm = (MetaForm)formLoad.getRootMetaObject();
				
				MetaFormProfile formProfile = new MetaFormProfile();
				formProfile.setKey(newMetaForm.getKey());
				formProfile.setCaption(newMetaForm.getCaption());
				formProfile.setResource(resource);
				formProfile.setFormType(newMetaForm.getFormType());
				
				MetaProject project = metaFactory.getMetaProject(projectKey);
				formProfile.setProject(project);
				formProfile.setForm(newMetaForm);
				newMetaForm.setProject(project);
				
				formList.add(formProfile);
			}
			MetaForm newMetaForm = metaFactory.getMetaForm(this.key);
			SchemaMaintance maintance = new SchemaMaintance(new ObjSchemaProvider<MetaForm>(newMetaForm) {

				@Override
				public List<MetaSchemaTable> getAllTable() throws Throwable {
					MetaDataObject dataObject = this.o.getDataSource().getDataObject();
					ArrayList<MetaSchemaTable> schemeTableList = dataObject.getSchemeTableList();
					return schemeTableList;
				}
				
			});
			// 数据库维护
			maintance.maintance(context.getDBManager());
		}
		return true;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new SaveGridTemplateCmd();
	}

	@Override
	public String getCmd() {
		return "SaveGridTemplate";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
