package com.bokesoft.yes.design;

import java.io.InputStream;

import org.w3c.dom.Document;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.setting.MetaSimpleSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class LoadGridTemplateCmd extends DefaultServiceCmd {
	private String key = "";
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		this.key = (String)arguments.get("key");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaSetting setting = metaFactory.getSetting();
		String projectKey = "";
		String path = "";
		if ( setting != null ) {
			MetaSimpleSetting simpleSetting = setting.getSimpleSetting("GridDesignTarget");
			if ( simpleSetting != null ) {
				projectKey = simpleSetting.get("Project");
				path = simpleSetting.get("Path");
			}
		}
		String xml = "";
		if ( !projectKey.isEmpty() && !path.isEmpty() ) {
			IMetaResolver resolver = metaFactory.getProjectResolver(projectKey);
			String resource = "Form/" + path + "/" + key + ".xml";
			InputStream in = resolver.read(resource, -1);
			try {
				if ( in != null ) {
					Document doc = DomHelper.createDocument(in);
					xml = DomHelper.toString(doc);
				}
			} finally {
				if ( in != null ) {
					in.close();
				}
			}
		}
		return xml;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new LoadGridTemplateCmd();
	}

	@Override
	public String getCmd() {
		return "LoadGridTemplate";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
