package com.bokesoft.yes.data.service;

import java.util.Iterator;

import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;

public interface IDocumentService extends Iterator<Document> {
	
	/**
	 * 初始化服务 
	 * 
	 * @param context  上下文环境
	 * @param formKey 表单标志
	 * @param paras 参数
	 * @param useCursor 设置DataTable 取数数方式，对应设置DataTable中的setCache方式，为true时 DataTable的setRowIndex,size等方法无效, 只能而通过next(true) 方式遍历表数据集, 可节约内存使用
	 */
	public void init(DefaultContext context, String formKey, Object paras, boolean useCursorDataTable);
	
	
	/**
	 * 初始化服务 
	 * 
	 * @param context  上下文环境
	 * @param formKey 表单标志
	 * @param paras 参数
	 * @param useCursor 设置DataTable 取数数方式，对应设置DataTable中的setCache方式，为true时 DataTable的setRowIndex,size等方法无效, 只能而通过next(true) 方式遍历表数据集, 可节约内存使用
	 * @param filterMap 过滤条件对象{@link com.bokesoft.yigo.struct.document.FilterMap}
	 * @param condParas 查询条件参数集合{@link com.bokesoft.yigo.struct.condition.ConditionParas}
	 */
     public default void init(DefaultContext context, String formKey, Object paras, boolean useCursorDataTable, FilterMap filterMap, ConditionParas condParas) {
    	 this.init(context, formKey, condParas, useCursorDataTable);
     }
	
	/**
	 * 获取文档名称
	 * 
	 * @param document
	 * @return
	 */
	public String getDocumentTitle(Document document);
	
	/**
	 * 检查当前服务是否适用, 在二次开发中实现该接口时需要注意实现类的使用场景，需要严格检查其所使用的 moduleName, formkey, extPara 是否符合使用条件，
	 * 若直接返回true, 将导致平台中所有 IDocumentService接口的实例发生改变, 所以在外部实现该接口时必须检查相关的条件
	 * 
	 * @param context 上下文环境
	 * @param moduleName 适用模块名称, 目前 "Excel"、"Print"
	 * @param methodName 调用来源方面名
	 * @param formKey 表单标志
	 * @param extPara 扩展参数
	 * @return
	 */
	public boolean check(DefaultContext context, String moduleName, String methodName, String formKey, Object extPara);
	
	/**
	 * 创建服务
	 * @return
	 */
	public IDocumentService newInstance();
	
}
