/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.excel.cmd.normal.ExcelDataUtil;
import com.bokesoft.yes.excel.cmd.normal.ExcelStyleFactory;
import com.bokesoft.yes.excel.cmd.normal.IExport;
import com.bokesoft.yes.excel.cmd.normal.LoadMultiPageDocument;
import com.bokesoft.yes.excel.document.ExcelDataTable;
import com.bokesoft.yes.excel.document.ExcelDetailDataRow;
import com.bokesoft.yes.excel.document.ExcelDocumentProcess;
import com.bokesoft.yes.excel.document.ExcelExpandDataRow;
import com.bokesoft.yes.excel.document.ExcelGroupDetailRow;
import com.bokesoft.yes.excel.document.GroupContext;
import com.bokesoft.yes.excel.document.IExcelDataRow;
import com.bokesoft.yes.excel.parser.ExcelContext;
import com.bokesoft.yes.excel.template.ColumnExpandItem;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelRow;
import com.bokesoft.yes.excel.template.ExcelSheet;
import com.bokesoft.yes.excel.template.ExcelWorkbook;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.transformer.ExcelTransformerFactory;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.ExcelUtils;
import com.bokesoft.yigo.util.StampExcelUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportExcelWithMultiPageTemplate
implements IExport {
    private DefaultContext context = null;
    private ExcelContext excelContext = null;
    private Document document = null;
    private Workbook workBook = null;
    private MetaExcelWorkbook metaWorkbook = null;
    private ExcelWorkbook virtualWorkbook = null;
    private ExcelTransformerFactory transformerFactory = null;
    private ExcelStyleFactory styleFactory = null;
    private FilterMap filterMap = null;
    private ConditionParas condParameters = null;
    private String postExportServiceName = null;
    private String exportFileName = null;

    public ExportExcelWithMultiPageTemplate(DefaultContext defaultContext, MetaExcelWorkbook metaExcelWorkbook, FilterMap filterMap, ConditionParas conditionParas, String string, String string2) throws Throwable {
        this.context = defaultContext;
        this.metaWorkbook = metaExcelWorkbook;
        this.filterMap = filterMap;
        this.condParameters = conditionParas;
        this.postExportServiceName = string;
        this.exportFileName = string2;
        this.excelContext = new ExcelContext(defaultContext);
    }

    @Override
    public FileData exportData() throws Throwable {
        Object object;
        ExcelSheet excelSheet;
        Object object2 = this.metaWorkbook.getFormKey();
        MetaForm metaForm = this.context.getVE().getMetaFactory().getMetaForm((String)object2);
        MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
        Object object3 = new LoadMultiPageDocument(this.context, this.filterMap, this.condParameters);
        this.document = ((LoadMultiPageDocument)object3).reloadDocument(metaForm);
        this.processDataTableToDocument();
        this.context.setDocument(this.document);
        this.context.setFormKey((String)object2);
        this.context.setDataObject(metaDataObject);
        this.excelContext.setDocument(this.document);
        for (Object object4 : metaDataObject.getTableCollection()) {
            if (object4.getTableMode() != 0) continue;
            this.document.get(object4.getKey()).first();
        }
        this.virtualWorkbook = new ExcelWorkbook(metaDataObject, this.metaWorkbook, this.context.getMidParser());
        this.virtualWorkbook.calcExpandColumn(this.context.getMidParser(), this.document, metaDataObject);
        object3 = new ExcelDocumentProcess(metaDataObject, this.virtualWorkbook, this.document, this.excelContext);
        ((ExcelDocumentProcess)object3).process();
        this.workBook = new SXSSFWorkbook(500);
        this.transformerFactory = new ExcelTransformerFactory();
        this.styleFactory = new ExcelStyleFactory(this.workBook);
        ByteArrayOutputStream byteArrayOutputStream = null;
        Iterator<ExcelSheet> iterator = this.virtualWorkbook.iterator();
        while (iterator.hasNext()) {
            Object object4;
            object4 = new HashMap();
            excelSheet = iterator.next();
            Sheet sheet = ExcelUtil.getSheet((Workbook)this.workBook, (String)excelSheet.getName());
            int n = 0;
            object = excelSheet.iterator();
            while (object.hasNext()) {
                ExcelRow excelRow = (ExcelRow)object.next();
                switch (excelRow.getType()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        ExportExcelWithMultiPageTemplate exportExcelWithMultiPageTemplate = this;
                        exportExcelWithMultiPageTemplate.exportFixRow(exportExcelWithMultiPageTemplate.document, metaDataObject, sheet, excelRow, n, (HashMap<Integer, Integer>)object4);
                        break;
                    }
                    case 3: {
                        n = this.exportDetailRow((ExcelDocumentProcess)object3, this.document, metaDataObject, sheet, excelRow, n, (HashMap<Integer, Integer>)object4);
                    }
                }
            }
            ExcelUtil.calcFinalColumnWith(excelSheet.getColumnWidths(), (HashMap)object4);
            ExcelUtil.setSheetColumnWidth((Sheet)sheet, (HashMap)object4);
        }
        object = ExcelUtils.getExportFilePath(this.context.getVE().getMetaFactory(), (String)object2);
        object2 = this.exportFileName != null && !this.exportFileName.isEmpty() ? this.exportFileName + "." + FileUtil.getSuffixName((String)object) : metaForm.getKey() + "." + FileUtil.getSuffixName((String)object);
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            this.workBook.write((OutputStream)byteArrayOutputStream);
            excelSheet = new FileData();
            excelSheet.setData(byteArrayOutputStream.toByteArray());
            excelSheet.setFileName((String)object2);
            object2 = excelSheet;
        }
        catch (Throwable throwable) {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            throw throwable;
        }
        byteArrayOutputStream.close();
        return object2;
    }

    private void processDataTableToDocument() {
        Iterator iterator = this.document.getMetaDataObject().getTableCollection().iterator();
        while (iterator.hasNext()) {
            String string = ((MetaTable)iterator.next()).getKey();
            DataTable dataTable = this.document.get(string);
            DataTableMetaData dataTableMetaData = dataTable.getMetaData();
            int n = dataTableMetaData.getColumnCount();
            dataTableMetaData = new DataTable(dataTableMetaData);
            dataTable.beforeFirst();
            while (dataTable.next(true)) {
                dataTableMetaData.append();
                for (int i = 0; i < n; ++i) {
                    dataTableMetaData.setObject(i, dataTable.getObject(i));
                }
            }
            dataTableMetaData.first();
            this.document.put(string, (DataTable)dataTableMetaData);
        }
    }

    private int exportDetailRow(ExcelDocumentProcess object, Document document, MetaDataObject metaDataObject, Sheet sheet, ExcelRow excelRow, int n, HashMap<Integer, Integer> hashMap) throws Throwable {
        this.excelContext.setExcelRow(excelRow);
        Object object2 = excelRow.getTableKey();
        object = ((ExcelDocumentProcess)object).getExcelDataTable((String)object2);
        if (object == null) {
            return n;
        }
        int n2 = excelRow.getRowIndex() - 1;
        document = document.get((String)object2);
        metaDataObject = metaDataObject.getMetaTable((String)object2);
        this.excelContext.setDataTable((DataTable)document);
        this.excelContext.setMetaTable((MetaTable)metaDataObject);
        object2 = ((ExcelDataTable)object).iterator();
        int n3 = 0;
        HashMap<Integer, GroupContext> hashMap2 = new HashMap<Integer, GroupContext>();
        int n4 = 0;
        while (object2.hasNext()) {
            int n5 = n2 + n;
            object = ExcelUtil.getRow((Sheet)sheet, (int)n5);
            object.setHeightInPoints((float)((short)excelRow.getHeight()));
            IExcelDataRow iExcelDataRow = (IExcelDataRow)object2.next();
            String string = iExcelDataRow.getType();
            if ("Expand".equalsIgnoreCase(string)) {
                this.fillExpandData((Row)object, (ExcelExpandDataRow)iExcelDataRow, (DataTable)document, excelRow, (MetaTable)metaDataObject, hashMap);
            } else if ("Detail".equalsIgnoreCase(string)) {
                this.fillDetailData(sheet, n5, (ExcelDetailDataRow)iExcelDataRow, (DataTable)document, excelRow, (MetaTable)metaDataObject, hashMap, hashMap2, n4);
            } else if ("GroupDetail".equalsIgnoreCase(string)) {
                this.fillGroupData(sheet, n5, (ExcelGroupDetailRow)iExcelDataRow, (DataTable)document, excelRow, (MetaTable)metaDataObject, hashMap, hashMap2, n4);
            }
            ++n;
            ++n3;
            ++n4;
        }
        hashMap2.clear();
        if (n3 > 0) {
            --n;
        }
        return n;
    }

    private void fillGroupData(Sheet sheet, int n, ExcelGroupDetailRow object, DataTable dataTable, ExcelRow object2, MetaTable metaTable, HashMap<Integer, Integer> hashMap, HashMap<Integer, GroupContext> object3, int n2) throws Throwable {
        GroupContext groupContext = new GroupContext();
        groupContext.addDefinition(((ExcelGroupDetailRow)object).getGroupLevel(), ((ExcelGroupDetailRow)object).getDefinition());
        ((HashMap)object3).put(n2, (GroupContext)groupContext);
        object3 = ((HashMap)object3).get(n2 - 1);
        this.excelContext.setDetailRows(((ExcelGroupDetailRow)object).getDetailRows());
        object = ((ExcelGroupDetailRow)object).getExcelRow().iterator();
        while (object.hasNext()) {
            object2 = (ExcelCell)object.next();
            if (((ExcelCell)object2).getCellIndex() == -1) continue;
            this.fillCellData(dataTable, metaTable, sheet, n, (ExcelCell)object2, hashMap, groupContext, (GroupContext)object3);
        }
    }

    private void fillExpandData(Row row, ExcelExpandDataRow excelExpandDataRow, DataTable dataTable, ExcelRow object, MetaTable metaTable, HashMap<Integer, Integer> hashMap) throws Throwable {
        object = ((ExcelRow)object).iterator();
        while (object.hasNext()) {
            ExcelCell excelCell = (ExcelCell)object.next();
            Object object2 = excelCell.getDefinition();
            Object object3 = excelCell.getSourceType();
            int n = excelCell.getCellIndex() - 1;
            Cell cell = ExcelUtil.getCell((Row)row, (int)n);
            Object object4 = null;
            if (((String)object3).equalsIgnoreCase("field")) {
                object3 = excelCell.getColumnExpandTarget() ? this.findRowInExpandRow(dataTable, excelExpandDataRow, excelCell) : excelExpandDataRow.getRow(0);
                if (object3 != null) {
                    object2 = (MetaColumn)metaTable.get((String)object2);
                    object4 = dataTable.getObject(object3.getRowIndex(), object2.getKey());
                    object2 = this.transformerFactory.getTransformer((VE)this.context.getVE(), excelCell);
                    if (object2 != null) {
                        object4 = object2.transform(excelCell, object4);
                    }
                }
            } else if (((String)object3).equalsIgnoreCase("const")) {
                object4 = object2;
            } else if (((String)object3).equalsIgnoreCase("formula")) {
                this.excelContext.setExcelExpandDataRow(excelExpandDataRow);
                object4 = this.excelContext.getMidParser().eval(0, (String)object2, (IEvalContext)this.excelContext, null);
            }
            if (object4 != null) {
                if (object4 instanceof BigDecimal) {
                    if (((BigDecimal)object4).compareTo(BigDecimal.ZERO) != 0) {
                        ExcelUtil.setCellValue((Cell)cell, (Object)object4);
                    }
                } else {
                    ExcelUtil.setCellValue((Cell)cell, (Object)object4);
                }
            }
            cell.setCellStyle(this.styleFactory.getCellStyle(excelCell));
            ExcelUtil.calcMaxColumnWidth((Cell)cell, hashMap, (int)n);
        }
    }

    private IExcelDataRow findRowInExpandRow(DataTable dataTable, ExcelExpandDataRow excelExpandDataRow, ExcelCell object) {
        Object object2 = null;
        ArrayList<ColumnExpandItem> arrayList = ((ExcelCell)object).getColumnExpandItems();
        int n = excelExpandDataRow.size();
        for (int i = 0; i < n; ++i) {
            object = (ExcelDetailDataRow)excelExpandDataRow.getRow(i);
            boolean bl = true;
            for (ColumnExpandItem columnExpandItem : arrayList) {
                Object object3 = dataTable.getObject(((ExcelDetailDataRow)object).getRowIndex(), columnExpandItem.getKey());
                if (ExcelDataUtil.equals(columnExpandItem.getValue(), object3)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            object2 = object;
            break;
        }
        return object2;
    }

    private void fillDetailData(Sheet sheet, int n, ExcelDetailDataRow object, DataTable dataTable, ExcelRow object2, MetaTable metaTable, HashMap<Integer, Integer> hashMap, HashMap<Integer, GroupContext> object3, int n2) throws Throwable {
        this.excelContext.setExcelDetailDataRow((ExcelDetailDataRow)object);
        GroupContext groupContext = new GroupContext();
        groupContext.setDefinitionMap(((ExcelDetailDataRow)object).getDefinitionMap());
        ((HashMap)object3).put(n2, (GroupContext)groupContext);
        object3 = ((HashMap)object3).get(n2 - 1);
        dataTable.setPos(((ExcelDetailDataRow)object).getRowIndex());
        object = ((ExcelRow)object2).iterator();
        while (object.hasNext()) {
            object2 = (ExcelCell)object.next();
            this.fillCellData(dataTable, metaTable, sheet, n, (ExcelCell)object2, hashMap, groupContext, (GroupContext)object3);
        }
    }

    private void exportFixRow(Document document, MetaDataObject metaDataObject, Sheet sheet, ExcelRow object, int n, HashMap<Integer, Integer> hashMap) throws Throwable {
        n = ((ExcelRow)object).getRowIndex() - 1 + n;
        ExcelUtil.getRow((Sheet)sheet, (int)n).setHeightInPoints((float)((short)((ExcelRow)object).getHeight()));
        this.excelContext.setExcelRow((ExcelRow)object);
        Iterator<ExcelCell> iterator = ((ExcelRow)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string = ((ExcelCell)object).getTableKey();
            MetaTable metaTable = metaDataObject.getMetaTable(string);
            string = document.get(string);
            this.fillCellData((DataTable)string, metaTable, sheet, n, (ExcelCell)object, hashMap, null, null);
        }
    }

    private void fillCellData(DataTable stringArray, MetaTable metaTable, Sheet sheet, int n, ExcelCell excelCell, HashMap<Integer, Integer> hashMap, GroupContext groupContext, GroupContext groupContext2) throws Throwable {
        int n2 = excelCell.getCellIndex() - 1;
        int n3 = excelCell.getMergedColumnSpan() - 1;
        int n4 = excelCell.getMergedRowSpan() - 1;
        Object object = excelCell.getDefinition();
        if (object == null || ((String)object).equals("")) {
            throw new MetaException(116, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"TemplateDataobjectNotDefined"), (Object[])new Object[0]));
        }
        Cell cell = ExcelUtil.getCell((Row)ExcelUtil.getRow((Sheet)sheet, (int)n), (int)n2);
        String string = excelCell.getSourceType();
        Object object2 = null;
        if (string.equalsIgnoreCase("field")) {
            object2 = excelCell.getColumnExpandTarget() ? (excelCell.getExpandCaption() == null ? excelCell.getExpandValue() : excelCell.getExpandCaption()) : stringArray.getObject((String)object);
        } else if (string.equalsIgnoreCase("const")) {
            object2 = object;
        } else if (string.equalsIgnoreCase("formula")) {
            object2 = this.excelContext.getMidParser().eval(0, (String)object, (IEvalContext)this.excelContext, null);
            stringArray = ((String)object).split("\\(");
            if ("SumExpandPortrait".equalsIgnoreCase((String)(object = stringArray[0]))) {
                int n5 = this.excelContext.getExpandCount();
                if (n5 < (stringArray = stringArray[1].substring(stringArray[1].indexOf("{") + 1, stringArray[1].lastIndexOf("}")).split(",")).length - 1) {
                    this.excelContext.setExpandCount(++n5);
                } else {
                    this.excelContext.setExpandCount(0);
                }
            }
        }
        int n6 = StampExcelUtil.getExcelCellStyle(excelCell, this.workBook);
        if (n6 != -1) {
            this.styleFactory.getCellStyle(excelCell).setDataFormat((short)n6);
        }
        if (!StampExcelUtil.isNumericCell(excelCell) && (object = this.transformerFactory.getTransformer((VE)this.context.getVE(), excelCell)) != null) {
            object2 = object.transform(excelCell, object2);
        }
        if (object2 != null) {
            if (object2 instanceof BigDecimal) {
                if (((BigDecimal)object2).compareTo(BigDecimal.ZERO) != 0) {
                    ExcelUtil.setCellValue((Cell)cell, (Object)object2);
                }
            } else {
                ExcelUtil.setCellValue((Cell)cell, (Object)object2);
            }
        }
        if (groupContext != null) {
            groupContext.putDisplayValue(excelCell.getCellIndex(), TypeConvertor.toString((Object)object2));
        }
        object = this.styleFactory.getCellStyle(excelCell);
        if (n3 > 0 || n4 > 0) {
            for (int i = 0; i <= n3; ++i) {
                for (n6 = 0; n6 <= n4; ++n6) {
                    cell = ExcelUtil.getCell((Sheet)sheet, (int)(n + n6), (int)(n2 + i));
                    cell.setCellStyle((CellStyle)object);
                }
            }
            int n7 = n;
            int n8 = n2;
            sheet.addMergedRegion(new CellRangeAddress(n7, n7 + n4, n8, n8 + n3));
        } else {
            cell.setCellStyle((CellStyle)object);
        }
        ExcelUtil.calcMaxColumnWidth((Cell)cell, hashMap, (int)n2);
    }
}

