/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.excel.cmd.normal.ExportComponentInfo;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ExportExcelParas {
    private HashMap<String, HashMap<String, ExportComponentInfo>> tableControl = new HashMap();
    private HashMap<String, ArrayList<String>> tableColumn = new HashMap();
    private String relationalKey = null;
    private String relationalCaption = null;

    public ExportExcelParas(DefaultContext object, MetaForm metaForm) {
        object = metaForm.getDataSource().getDataObject();
        for (MetaTable metaTable : object.getTableCollection()) {
            switch (metaTable.getTableMode()) {
                case 0: {
                    this.dealHeadTable(metaForm, metaTable);
                    break;
                }
                case 1: {
                    this.dealDetailTable(metaForm, metaTable);
                }
            }
        }
        metaForm = object.getMainTable();
        switch (object.getSecondaryType()) {
            case 2: {
                this.relationalKey = metaForm.containsKey("NO") ? "NO" : "OID";
                this.relationalCaption = ((MetaColumn)metaForm.get(this.relationalKey)).getCaption();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.relationalKey = "Code";
                this.relationalCaption = ((MetaColumn)metaForm.get(this.relationalKey)).getCaption();
            }
        }
        object = this.tableColumn.get(metaForm.getKey());
        if (!((ArrayList)object).contains(this.relationalKey)) {
            ((ArrayList)object).add(0, this.relationalKey);
        }
    }

    private void dealDetailTable(MetaForm metaForm, MetaTable metaTable) {
        String string = metaTable.getKey();
        if ((string = metaForm.findComponentByTable(string)) == null) {
            return;
        }
        switch (string.getControlType()) {
            case 217: {
                this.dealGridDetailTable(metaForm, metaTable, (MetaGrid)string);
                return;
            }
            case 216: {
                this.dealListViewDetailTable(metaForm, metaTable, (MetaListView)string);
                return;
            }
            case 305: {
                this.dealEditViewDetailTable(metaForm, metaTable, (MetaEditView)string);
            }
        }
    }

    private void dealListViewDetailTable(MetaForm object, MetaTable object2, MetaListView metaListView2) {
        object = object2.getKey();
        object2 = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MetaListView metaListView2 : metaListView2.getColumnCollection()) {
            String string = metaListView2.getDataColumnKey();
            if (string == null || string.isEmpty()) continue;
            ((HashMap)object2).put(string, new ExportComponentInfo(metaListView2.getCaption(), metaListView2.getColumnType(), metaListView2.getProperties()));
            arrayList.add(string);
        }
        this.tableControl.put((String)object, (HashMap<String, ExportComponentInfo>)object2);
        this.tableColumn.put((String)object, arrayList);
    }

    private void dealEditViewDetailTable(MetaForm object, MetaTable object2, MetaEditView metaEditView2) {
        object = object2.getKey();
        object2 = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MetaEditView metaEditView2 : metaEditView2.getColumnCollection()) {
            String string = metaEditView2.getDataColumnKey();
            if (string == null || string.isEmpty()) continue;
            ((HashMap)object2).put(string, new ExportComponentInfo(metaEditView2.getCaption(), metaEditView2.getColumnType(), metaEditView2.getProperties()));
            arrayList.add(string);
        }
        this.tableControl.put((String)object, (HashMap<String, ExportComponentInfo>)object2);
        this.tableColumn.put((String)object, arrayList);
    }

    private void dealGridDetailTable(MetaForm object, MetaTable object2, MetaGrid object3) {
        object = object2.getKey();
        object2 = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MetaGridRow metaGridRow2 : object3.getRowCollection()) {
            if (metaGridRow2.getRowType() != 2) continue;
            for (MetaGridRow metaGridRow2 : metaGridRow2) {
                String string = metaGridRow2.getColumnKey();
                if (string == null || string.isEmpty()) continue;
                ((HashMap)object2).put(string, new ExportComponentInfo(metaGridRow2.getCaption(), metaGridRow2.getCellType(), metaGridRow2.getProperties()));
                arrayList.add(string);
            }
        }
        this.tableControl.put((String)object, (HashMap<String, ExportComponentInfo>)object2);
        this.tableColumn.put((String)object, arrayList);
    }

    public void dealHeadTable(MetaForm metaForm, MetaTable object) {
        String string = object.getKey();
        HashMap<MetaTable, ExportComponentInfo> hashMap = new HashMap<MetaTable, ExportComponentInfo>();
        ArrayList<MetaTable> arrayList = new ArrayList<MetaTable>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = ((MetaColumn)iterator.next()).getKey();
            MetaComponent metaComponent = metaForm.getComponentByDataBinding(string, (String)object);
            if (metaComponent == null) continue;
            hashMap.put((MetaTable)object, new ExportComponentInfo(metaComponent.getCaption(), metaComponent.getControlType(), metaComponent.getProperties()));
            arrayList.add((MetaTable)object);
        }
        this.tableControl.put(string, hashMap);
        this.tableColumn.put(string, arrayList);
    }

    public String getRelationalKey() {
        return this.relationalKey;
    }

    public String getRelationalCaption() {
        return this.relationalCaption;
    }

    public HashMap<String, ExportComponentInfo> getComponentInfoByTableKey(String string) {
        return this.tableControl.get(string);
    }

    public ArrayList<String> getColumnListByTableKey(String string) {
        return this.tableColumn.get(string);
    }
}

