package com.bokesoft.yes.excel.transformer;

import java.util.HashMap;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelFormat;
import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;
import com.bokesoft.yigo.tools.ve.VE;

public class ExcelTransformerFactory {
	
	private static ExcelDefaultDataTransformer DEFAULT_TRANSFORMER = new ExcelDefaultDataTransformer();
	
	private HashMap<String, IExcelTransformer> transMap = new HashMap<String, IExcelTransformer>();

	// 获取对应的转换工具，如果没有定义数据类型的话，用控件类型
	public IExcelTransformer getTransformer(VE ve, ExcelCell cell) {
		String key = cell.getDefinition();
		if (key != null && !key.isEmpty()) {
			ExcelDisplay display = cell.getDisplay();
			if (display != null) {
				ExcelFormat format = display.getFormat();
				if (format != null) {
					return getTransformer(ve, key, format.getDataType());
				}
			}
		}
		return DEFAULT_TRANSFORMER;
	}
	
	public IExcelTransformer getTransformer(VE ve, String key, int dataType) {
		if (!StringUtil.isBlankOrNull(key)) {
			String typeAndKey = getKeyWithType(key, dataType);
			IExcelTransformer transformer = transMap.get(typeAndKey);
			if (transformer == null) {
				switch (dataType) {
				case ExcelFormatDataType.Dict:
					transformer = new ExcelDictDataTransformer(ve);
					break;
				case ExcelFormatDataType.List:
				case ExcelFormatDataType.MultiList:
					transformer = new ExcelListDataTransformer();
					break;
				default:
					transformer = new ExcelDefaultDataTransformer();
					break;
				}
				transMap.put(typeAndKey, transformer);
			}
			return transformer;
		}
		return DEFAULT_TRANSFORMER;
	}
	
	private String getKeyWithType(String key, int type) {
		return key + "|" + type;
	}
}
