package com.bokesoft.yes.excel.transformer;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import com.bokesoft.yigo.common.util.TypeConvertor;

public class DateFormatter implements IDataFormatter {

	private static DateFormatter instance = null;

	private DateFormatter() {
	}
	
	public String format(Object data, String sformat) {
		if (data == null || data.equals(0) || data.equals(0L)) {
			return "";
		}

		Date date = null;
		if (data instanceof Long) {
			// 处理UTCDatePicker
			int dataLong = TypeConvertor.toInteger(data);
			int year = dataLong / 10000;
			int month = (dataLong / 100) % 100;
			int day = dataLong % 100;
			Calendar calendar = Calendar.getInstance();
			calendar.set(year, month - 1, day);
			date = calendar.getTime();
		} else if (data instanceof Date) {
			date = TypeConvertor.toDate(data);
		} else {
			// 其它类型不支持格式化
			return data.toString();
		}

		SimpleDateFormat df = new SimpleDateFormat(sformat);
		return df.format(date);
	}

	public static DateFormatter getInstance() {
		if(instance == null) {
			instance = new DateFormatter();
		}
		return instance;
	}
}
