package com.bokesoft.yes.excel.document;

import java.util.HashMap;

/**
 * 用于合并单元格时进行分组标识的比较
 * 
 * @author guowj
 *
 */
public class GroupContext {

	private HashMap<String, Integer> definitionMap = new HashMap<String, Integer>();

	private HashMap<Integer, String> displayValueMap = new HashMap<Integer, String>();
	
	public GroupContext() {
		
	}
	
	public void addDefinition(Integer groupLevel, String definition) {
		if(definition != null) {
			definitionMap.put(definition, groupLevel);
		}
	}
	
	public void setDefinitionMap(HashMap<String, Integer> definitionMap) {
		this.definitionMap = definitionMap;
	}
	
	public Integer getGroupLevel(String definition) {
		return definitionMap.get(definition);
	}
	
	public HashMap<String, Integer> getDefinitionMap(){
		return definitionMap;
	}
	
	public void putDisplayValue(Integer cellIndex, String displayValue) {
		if(cellIndex != null && displayValue != null) {
			displayValueMap.put(cellIndex, displayValue);
		}
	}
	
	public String getDisplayValue(Integer cellIndex) {
		String displayValue = "";
		if(cellIndex != -1) {
			displayValue = displayValueMap.get(cellIndex);
		}
		
		return displayValue;
	}
}
