package com.bokesoft.yes.excel.cmd.stamp.input.process;

import java.util.LinkedHashMap;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutTable;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.IInputRowAction;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;

/**
 * 导入 表单
 * 
 * @author chenbb
 *
 */
public class InputDocumentProcess {

	private ExcelTemplate excelTemplate = null;
	
	private LinkedHashMap<String, InputTableProcess> mapTableProcess = null;
	
	public InputDocumentProcess(ExcelTemplate excelTemplate) {
		this.excelTemplate = excelTemplate;
		init();
	}
	
	private void init() {
		this.mapTableProcess = new LinkedHashMap<>();
		for (ExcelTemplateTable templateTable : excelTemplate.getTemplateTables4StampImport()) {
			InputTableProcess tableProcess = new InputTableProcess(templateTable);
			mapTableProcess.put(templateTable.getTableKey(), tableProcess);
		}
	}
	
	public void doProcess(IInDocument<IInTable> inDoc, OutDocument outDoc, IInputRowAction action, ExcelProcessContext context) throws Throwable {
		OutTable outTable = null;
		for (IInTable inTable : inDoc.getInTables()) {
			outTable = (outDoc == null ? null : outDoc.getTable(inTable.getKey()));
			InputTableProcess inputTableProcess = mapTableProcess.get(inTable.getKey());
			if (inputTableProcess != null) {
				inputTableProcess.doProcess(inTable, outTable, action, context);
			}
		}
	}
}
