package com.bokesoft.yes.excel.cmd.stamp.dependency.provider;

import java.util.Collection;

import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;

/**
 * 提取需要进行默认值计算的项目
 * 
 * @author chenbb
 *
 */
public class StampExpFieldItemProvider extends BaseExpFieldItemProvider {
	
	public StampExpFieldItemProvider(MetaDataObject metaDataObject, ExcelTemplate excelTemplate) {
		super(metaDataObject);
		filterByImportFields(excelTemplate);
	}
	
	/**
	 * 将需要导入的字段从默认值计算列表中移除
	 * 
	 * @param excelTemplate
	 */
	private void filterByImportFields(ExcelTemplate excelTemplate) {
		Collection<ExcelTemplateTable> tempalteTables = excelTemplate.getTemplateTables4StampImport();
		for (ExcelTemplateTable templateTable : tempalteTables) {
			for (ExcelTemplateField templateField : templateTable.getFields()) {
				remove(templateField.getDefine(), templateTable.getTableKey());
			}
		}
	}
}
