package com.bokesoft.yes.excel.cmd.normal;

import java.io.File;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.dts.util.FileUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.excel.IImportService;
import com.bokesoft.yigo.excel.IImportService2;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtImportService;
import com.bokesoft.yigo.meta.enhance.MetaImportService;
import com.bokesoft.yigo.mid.base.DefaultContext;

@SuppressWarnings("deprecation")
public class ImportExcelCmd extends DefaultServiceCmd {
	// 表单标识
	private String formKey = null;
	// 文件路径，可能多个文件同时导入
	private List<FileData> fileDatas = null;
	// 是否清楚旧数据
	private boolean clearOriginalData = true;
	// 自定义二开到导入服务名
	private String importServiceName = null;
	// 导入后事务，表单保存前执行
	private String postImportServiceName = null;
	//导入字典是否用document方式导入，而不是直接sql语句写入
	private boolean isDocTypeDict = false;
	
	@SuppressWarnings("unchecked")
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		fileDatas = (List<FileData>)arguments.get("fileDatas");
		clearOriginalData = TypeConvertor.toBoolean(arguments.get("clearOriginalData"));
		postImportServiceName = TypeConvertor.toString(arguments.get("postImportServiceName"));
		importServiceName = TypeConvertor.toString(arguments.get("importServiceName"));
		if (arguments.containsKey("isDocTypeDict")){
			isDocTypeDict = TypeConvertor.toBoolean(arguments.get("isDocTypeDict"));
		}
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		if(fileDatas == null || fileDatas.isEmpty()){
			return null;
		}
		context.setFormKey(formKey);
		
		Object importService = null;
		// 判断是否调用自定义导入
		if( importServiceName != null && !importServiceName.isEmpty() ) {
			MetaEnhance enhance = context.getVE().getMetaFactory().getEnhance(null);
			if( enhance != null ) {
				MetaImportService service = null;
				MetaExtImportService extService = enhance.getExtImportService();
				if ( extService != null ) {
					service = extService.get(importServiceName);
				}	
				
				if(service != null){
					String impl = service.getImpl();
					importService = ReflectHelper.newInstance(context.getVE(), impl);
				}
			}			
		}
		
		if(importService == null){
			importService = new DefaultImportExcelService();	
			if (isDocTypeDict){
				((DefaultImportExcelService)importService).setDocTypeDict(isDocTypeDict);
			}
		}	
		
		JSONObject res = new JSONObject();
		JSONArray items = new JSONArray();	
		for(FileData f : fileDatas){
			// 获取字典导入的itemKey,客户端清除字典缓存
			Object value = importData(context, importService, f, clearOriginalData, postImportServiceName);
			if (value instanceof String) {
				items.put(value);
			}	
		}
		
		res.put("items", items);
		return res;
	}
	
	private Object importData(DefaultContext context, Object importService, FileData fileData, boolean clearOriginalData, String postImportServiceName) throws Throwable{
		Object o = null;
		if(importService instanceof IImportService){
			// 生成临时文件
			File tmpFile = FileUtil.createTempFile(fileData, "Import");
			try{
				o = ((IImportService)importService).importData(context, tmpFile, clearOriginalData, postImportServiceName);
			}finally{
				// 删除临时文件
				try{
					if(tmpFile != null){
						tmpFile.delete();
					}
				}catch(Throwable e){
					e.printStackTrace();
				}
			}
			
		}else{
			((IImportService2)importService).setFormKey(formKey);
			((IImportService2)importService).setClearOriginalData(clearOriginalData);
			((IImportService2)importService).setPostServiceName(postImportServiceName);
			o = ((IImportService2)importService).importData(context, fileData.getData());
		}
		return o;
	}
	
	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ImportExcelCmd();
	}

	@Override
	public String getCmd() {
		return null;
	}
	
	public void setClearOriginalData(boolean clearOriginalData) {
		this.clearOriginalData = clearOriginalData;
	}

	public void setImportServiceName(String importServiceName) {
		this.importServiceName = importServiceName;
	}

	public void setFileDatas(List<FileData> fileDatas) {
		this.fileDatas = fileDatas;
	}
	
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
