package com.bokesoft.yes.excel.cmd.normal;


import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.csv.cmd.normal.IExportPostProcess;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.report.output.OutputCell;
import com.bokesoft.yes.report.output.OutputColumn;
import com.bokesoft.yes.report.output.OutputRow;
import com.bokesoft.yes.report.output.OutputSection;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.util.ExcelUtils;

public class ExportGridCmd extends DefaultServiceCmd {

	private String formKey = null;

	private String exportFileName = null;

	private String postExportServiceName = null;

	private boolean needDownload = false;

	private OutputSection gridSection = null;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		needDownload = TypeConvertor.toBoolean(arguments.get("needDownload"));
		exportFileName = TypeConvertor.toString(arguments.get("exportFileName"));
		postExportServiceName = TypeConvertor.toString(arguments.get("postExportServiceName"));

		gridSection = new OutputSection();
		String str = TypeConvertor.toString(arguments.get("section"));
		JSONObject json = new JSONObject(str);
		gridSection.fromJSON(json);
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {

		XSSFWorkbook workbook = new XSSFWorkbook();
		Sheet curSheet = ExcelUtil.getSheet(workbook, "Sheet1");
		
		OutputRow outRow = null;
		OutputCell outCell = null;
		int rowCount = gridSection.getRowCount();
		int columnCount = gridSection.getColumnCount();
		for (int rowIndex = 0; rowIndex < rowCount; rowIndex++) {
			outRow = gridSection.getRow(rowIndex);
			for (int colIndex = 0; colIndex < columnCount; colIndex++) {
				outCell = outRow.get(colIndex);
				ExcelUtil.setCellValue(curSheet, rowIndex, colIndex, outCell.getText());
			}
		}
		
		OutputColumn outColumn = null;
		for (int i = 0; i < columnCount; i++) {
			outColumn = gridSection.getColumn(i);
			if (outColumn != null) {
				int width = (int) (outColumn.getWidth()*256/7) + 500;
				curSheet.setColumnWidth(i, width);
			}
		}
		
		
		FileData fileData = new FileData();
		String filePath = ExcelUtils.getExportFilePath(context.getVE().getMetaFactory(), formKey);
		if (!needDownload) {
			fileData = ExcelFileUtil.writeExcel(workbook, filePath);
		} else {
			fileData = ExcelFileUtil.convertWorkbookToFileData(formKey, exportFileName, workbook);
		}

		IExportPostProcess process = ExcelUtils.getPostExtProcess(context, postExportServiceName);
		if (process != null) {
			process.process(context, fileData);
		}
		
		if (needDownload) {
			return fileData;
		} else {
			return new FileData();
		}
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ExportGridCmd();
	}

	@Override
	public String getCmd() {
		return "ExportGrid";
	}

	@Override
	public boolean getNeedServiceRight() {
		return true;
	}
}