package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class ExportDictCmd extends DefaultServiceCmd {
	// 待导出的FormKey
	private String exportFormKey = null;
	// 单据的批量导出模板，没有表示导出全部字段
	private String templateKey = null;
	// 导出后事件
	private String postExportServiceName = null;
	//自定义导出的文件名
    private String exportFileName=null;
    
	private boolean needDownload = false;
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		exportFormKey = arguments.get("exportFormKey").toString();
		templateKey = arguments.get("templateKey").toString();
		postExportServiceName = arguments.get("postExportServiceName").toString();
		exportFileName=arguments.get("exportFileName").toString();
		needDownload = TypeConvertor.toBoolean(arguments.get("needDownload"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IExport export = null;
		if (templateKey.isEmpty()) {
			export = new ExportDict(context, exportFormKey, postExportServiceName, exportFileName,needDownload);
		} else {
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			MetaForm metaForm = metaFactory.getMetaForm(exportFormKey);
			String projectKey = metaForm.getProject().getKey();
			
			MetaExcelWorkbook metaWorkbook = metaFactory.getExcelTemplate(projectKey, templateKey);
			export = new ExportDictWithTemplate(context, metaWorkbook,exportFormKey, postExportServiceName, exportFileName,needDownload);
		}
		
		return export.exportData();
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ExportDictCmd();
	}

	@Override
	public String getCmd() {
		return "ExportDict";
	}

}
