package com.bokesoft.yes.excel.cmd.normal;

import java.math.BigDecimal;
import java.util.Date;

import com.bokesoft.yigo.common.util.TypeConvertor;

public class ExcelDataUtil {
	/**
	 * 比较两个数据大小
	 * @param o1 源值
	 * @param o2 目标值
	 * @return 0:相等，-1:源值较小，1:目标值较大
	 */
	public static final int compare(Object o1, Object o2) {
		int result = 0;
		// null相等
		if (o1 == null && o2 == null) {
			result = 0;
		} else if (o1 == null) {
			// null比任何值都小
			result = -1;
		} else if (o2 == null) {
			// null比任何值都小
			result = 1;
		} else {
			if (o1 instanceof BigDecimal) {
				result = ((BigDecimal) o1).compareTo((BigDecimal) o2);
			} else if (o1 instanceof Integer) {
				result = ((Integer) o1).compareTo((Integer) o2);
			} else if (o1 instanceof Long) {
				result = ((Long) o1).compareTo((Long) o2);
			} else if (o1 instanceof String) {
				result = ((String) o1).compareToIgnoreCase((String) o2);
			} else if (o1 instanceof Boolean) {
				result = ((Boolean) o1).compareTo((Boolean) o2);
			} else if (o1 instanceof Date) {
				result = ((Date) o1).compareTo((Date) o2);
			}
		}
		return result;
	}

	/**
	 * 比较两个数据是否相等
	 * @param o1 源值
	 * @param o2 目标值
	 * @return 是否相等
	 */
	public static final boolean equals(Object o1, Object o2) {
		boolean result = false;
		// null值相等
		if (o1 == null && o2 == null) {
			result = true;
		} else if (o1 == null) {
			// null跟其它值不相等
			result = false;
		} else if (o2 == null) {
			// null跟其它值不相等
			result = false;
		} else {
			if (o1 instanceof BigDecimal) {
				result = (TypeConvertor.toBigDecimal(o1)).equals(TypeConvertor.toBigDecimal(o2));
			} else if (o1 instanceof Integer) {
				result = (TypeConvertor.toInteger(o1)).equals(TypeConvertor.toInteger(o2));
			} else if (o1 instanceof Long) {
				result = (TypeConvertor.toLong(o1)).equals(TypeConvertor.toLong(o2));
			} else if (o1 instanceof String) {
				result = (o1.toString()).equalsIgnoreCase(o2.toString());
			} else if (o1 instanceof Boolean) {
				result = (TypeConvertor.toBoolean(o1)).equals(TypeConvertor.toBoolean(o2));
			} else if (o1 instanceof Date) {
				result = ((Date) o1).equals(TypeConvertor.toDate(o2));
			}
		}
		return result;
	}
}
