package com.bokesoft.yes.excel.cmd.normal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import com.bokesoft.yes.excel.datatransfer.DataTransferUtil;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.DictColumnUtil;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.excel.IExportService;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.util.DocumentUtil;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.ExcelUtils;

public class DefaultExportExcelService implements IExportService {

	@Override
	public FileData exportData(DefaultContext context, Document document, FilterMap filterMap, ConditionParas condParameters,
							   String exportTables, String postServiceName, boolean onlyCurrentPage, String exportFileName,boolean needDownload) throws Throwable {

		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(context.getFormKey());
		Document originalDoc = document;

		// 获取MetaDataObject
		MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
		boolean exportAll = exportTables == null || exportTables.isEmpty();
		boolean needLoadData = false;

		ArrayList<MetaTable> tableList = new ArrayList<MetaTable>();
		if (exportAll) {
			Iterator<MetaTable> itTables = metaDataObject.getTableCollection().iterator();
			while (itTables.hasNext()) {
				tableList.add(itTables.next());
			}
		} else {
			String[] tableKeys = exportTables.split(",");
			for (String tableKey : tableKeys) {
				MetaTable metaTable = metaDataObject.getTable(tableKey);
				if (metaTable != null) {
					tableList.add(metaTable);
				}
			}
		}

		if (tableList.size() == 0) {
			return null;
		}

		MetaTable metaTable = null;
		DataTable dataTable = null;
		DataTable originalDataTable = null;

		// 如果是分页表格，数据需要重新载入
		needLoadData = DocumentUtil.isPaginationForm(metaForm, tableList.iterator());

		Document exportDocument = document;
		try {
			boolean isReload = false;
			if (needLoadData && !onlyCurrentPage) {
				LoadMultiPageDocument loadMultiPageDocument = new LoadMultiPageDocument(context, filterMap, condParameters);
				exportDocument = loadMultiPageDocument.reloadDocument(metaForm);
				isReload = true;
			}

			// 创建Excel对象 内存中只存1000条记录
			Workbook workbook = new SXSSFWorkbook(1000);

			// 开始导出
			Iterator<MetaTable> itTables = tableList.iterator();
			while (itTables.hasNext()) {
				metaTable = itTables.next();
				
				dataTable = exportDocument.get(metaTable.getKey());
				originalDataTable = originalDoc.get(metaTable.getKey());

				exportTable(context, workbook, metaForm, metaTable, dataTable, isReload, originalDataTable);
			}
			String filePath = ExcelUtils.getExportFilePath(metaFactory, metaForm.getKey());
			context.setDocument(exportDocument);
			if (!needDownload){
				FileData fileData = ExcelFileUtil.writeExcel(workbook, filePath);
				return fileData;
			}else{
				FileData fileData = ExcelFileUtil.convertWorkbookToFileData(metaForm.getKey(), exportFileName, workbook);
				fileData.setPath(filePath);
				return fileData;
			}

		} finally {
			if (needLoadData) {
				exportDocument.close();
			}
		}
	}

	private void exportTable(DefaultContext context, Workbook workbook, MetaForm metaForm, MetaTable metaTable, DataTable dataTable, boolean isReload, DataTable originalDataTable)
			throws Throwable {
		int tableModel = metaTable.getTableMode();
		switch (tableModel) {
			case TableMode.HEAD:
				exportHeadTable(context, workbook, metaForm, metaTable, dataTable);
				break;
			case TableMode.DETAIL:
				exportDetailTable(context, workbook, metaForm, metaTable, dataTable, isReload, originalDataTable);
				break;
		}
	}

	private void exportDetailTable(DefaultContext context, Workbook workbook, MetaForm metaForm, MetaTable metaTable, DataTable dataTable, boolean isReload, DataTable originalDataTable)
			throws Throwable {
		Sheet sheet = getSheet(workbook, metaTable);
		String tableKey = metaTable.getKey();
		DataTable exportTable = dataTable;

		MetaComponent metaComponent = metaForm.findComponentByTable(tableKey);
		if( metaComponent == null )
			return;
		switch (metaComponent.getControlType()) {
			case ControlType.GRID:
				exportGridTable(context, workbook, metaForm, (MetaGrid) metaComponent, metaTable, exportTable, isReload, originalDataTable);
				break;
			case ControlType.LISTVIEW:
				exportListViewTable(context, sheet, metaForm, (MetaListView) metaComponent, metaTable, exportTable, isReload, originalDataTable);
				break;
			case ControlType.EDITVIEW:
				exportEditViewTable(context, sheet, metaForm, (MetaEditView) metaComponent, metaTable, exportTable, originalDataTable);
				break;
			default:
				break;
		}
	}

	@SuppressWarnings("deprecation")
	private void exportListViewTable(DefaultContext context,Sheet sheet, MetaForm metaForm, MetaListView metaListView, MetaTable metaTable,
									 DataTable dataTable, boolean isReload, DataTable originalDataTable) throws Throwable {
		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, MetaListViewColumn> map = new HashMap<String, MetaListViewColumn>();
		// 先找到数据行
		MetaListViewColumn listViewColumn = null;
		Iterator<MetaListViewColumn> itListViewColumn = metaListView.getColumnCollection().iterator();
		while (itListViewColumn.hasNext()) {
			listViewColumn = itListViewColumn.next();
			if (!listViewColumn.getVisible().equals("false")){
				map.put(listViewColumn.getDataColumnKey(), listViewColumn);
			}
		}

		Cell cell = null;
		String columnKey = null;
		MetaListViewColumn metaListViewColumn = null;
		// 先确定表格标题
		int colIndex = 0;
		MetaColumn metaColumn = null;
		Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
		Row titileRow = ExcelUtil.getRow(sheet, 0);
		while (itMetaColumn.hasNext()) {
			metaColumn = itMetaColumn.next();
			columnKey = metaColumn.getKey();
			metaListViewColumn = map.get(columnKey);
			if (metaListViewColumn != null) {
				cell = ExcelUtil.getCell(titileRow, colIndex);
				ExcelUtil.setCellValue(cell, metaListViewColumn.getCaption());

				colIndex++;
			}
		}

		// 循环所有数据行、数据列，有字段的才做导出
		int rowIndex = 1;
		Object value = null;
		Row dataRow = null;
		dataTable.beforeFirst();
		while (dataTable.next(true)) {
			colIndex = 0;
			dataRow = ExcelUtil.getRow(sheet, rowIndex);
			itMetaColumn = metaTable.iterator();
			while (itMetaColumn.hasNext()) {
				metaColumn = itMetaColumn.next();
				columnKey = metaColumn.getKey();
				metaListViewColumn = map.get(columnKey);
				if (metaListViewColumn != null) {
					value = DataTransferUtil.convertFieldValue(context, metaForm, metaListViewColumn.getColumnType(),
							metaListViewColumn.getProperties(), dataTable, columnKey);
					cell = ExcelUtil.getCell(dataRow, colIndex);
					ExcelUtil.setCellValue(cell, value);

					colIndex++;
				}
			}

			rowIndex++;
		}
	}

	@SuppressWarnings("deprecation")
	private void exportEditViewTable(DefaultContext context,Sheet sheet, MetaForm metaForm, MetaEditView metaEditView, MetaTable metaTable,
									 DataTable dataTable, DataTable originalDataTable) throws Throwable {
		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, MetaEditViewColumn> map = new HashMap<String, MetaEditViewColumn>();
		// 先找到数据行
		MetaEditViewColumn EditViewColumn = null;
		Iterator<MetaEditViewColumn> itEditViewColumn = metaEditView.getColumnCollection().iterator();
		while (itEditViewColumn.hasNext()) {
			EditViewColumn = itEditViewColumn.next();
			if (!EditViewColumn.getVisible().equals("false")){
				map.put(EditViewColumn.getDataColumnKey(), EditViewColumn);
			}
		}

		Cell cell = null;
		String columnKey = null;
		MetaEditViewColumn metaEditViewColumn = null;
		// 先确定表格标题
		int colIndex = 0;
		MetaColumn metaColumn = null;
		Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
		Row titileRow = ExcelUtil.getRow(sheet, 0);
		while (itMetaColumn.hasNext()) {
			metaColumn = itMetaColumn.next();
			columnKey = metaColumn.getKey();
			metaEditViewColumn = map.get(columnKey);
			if (metaEditViewColumn != null) {
				cell = ExcelUtil.getCell(titileRow, colIndex);
				ExcelUtil.setCellValue(cell, metaEditViewColumn.getCaption());

				colIndex++;
			}
		}

		// 循环所有数据行、数据列，有字段的才做导出
		int rowIndex = 1;
		Object value = null;
		Row dataRow = null;
		dataTable.beforeFirst();
		while (dataTable.next(true)) {
			colIndex = 0;
			dataRow = ExcelUtil.getRow(sheet, rowIndex);
			itMetaColumn = metaTable.iterator();
			while (itMetaColumn.hasNext()) {
				metaColumn = itMetaColumn.next();
				columnKey = metaColumn.getKey();
				metaEditViewColumn = map.get(columnKey);
				if (metaEditViewColumn != null) {
					value = DataTransferUtil.convertFieldValue(context, metaForm, metaEditViewColumn.getColumnType(),
							metaEditViewColumn.getProperties(), dataTable, columnKey);
					cell = ExcelUtil.getCell(dataRow, colIndex);
					ExcelUtil.setCellValue(cell, value);

					colIndex++;
				}
			}

			rowIndex++;
		}
	}

	@SuppressWarnings("deprecation")
	private void exportGridTable(DefaultContext context, Workbook workbook, MetaForm metaForm, MetaGrid metaGrid, MetaTable metaTable,
								 DataTable dataTable, boolean isReload, DataTable originalDataTable) throws Throwable {
		dataTable.beforeFirst();
		boolean nextSheet = false;
		int index = 0;
		
		String sheetName = metaTable.getCaption().isEmpty() ? metaTable.getKey() : metaTable.getCaption();
		do {
			sheetName = index > 0 ? (sheetName + "_" + index) : sheetName; 
			Sheet sheet = ExcelUtil.getSheet(workbook, sheetName);
			this.exportGridTableHead(context, sheet, metaForm, metaGrid, metaTable, dataTable, originalDataTable);
			nextSheet = this.exportGridTableBody(context, sheet, metaForm, metaGrid, metaTable, dataTable, originalDataTable);
			index ++;
		} while (!nextSheet);
	}
	
	private void exportGridTableHead(DefaultContext context,Sheet sheet, MetaForm metaForm, MetaGrid metaGrid, MetaTable metaTable,
			DataTable dataTable, DataTable originalDataTable) throws Throwable{
		Row titileRow = ExcelUtil.getRow(sheet, 0);
		
		// 先确定表格标题
		Iterator<MetaGridRow> itRow = metaGrid.getRowCollection().iterator();
		MetaGridRow metaRow = null;
		MetaGridCell metaCell = null;

		int colIndex = 0;
		Cell cell = null;
		while (itRow.hasNext()) {
			metaRow = itRow.next();
			if (metaRow.getRowType() != RowType.Detail) {
				continue;
			}
			
			int realColIndex = 0;
			Iterator<MetaGridCell> itCell = metaRow.iterator();
			while (itCell.hasNext()) {
				metaCell = itCell.next();
				realColIndex++;
				
				//如果是选择字段，不设置值
				if ( metaCell.isSelect() ) {
					continue;
				}
				if( !isVisibleColumn(metaGrid, realColIndex -1) ) {
					continue;
				}
				
				if( !metaTable.getKey().equals(metaCell.getTableKey()) ) {
					continue;
				}
					
				
				
				//如果控件时字典时标题特殊处理
				int expandCount = 0;
				if(DictColumnUtil.needExpandDictColumn(metaCell) && originalDataTable.size() != 0){
					List<MetaColumn> displayCols = DictColumnUtil.getDictDisplayColumns(context.getVE(), metaCell.getProperties());
					expandCount = displayCols == null ? 0 : displayCols.size();
					
					if (expandCount > 1) {
						MetaColumn column = null;
						for (int i = 0; i < expandCount; i++) {
							column = displayCols.get(i);
							cell = ExcelUtil.getCell(titileRow, colIndex);
							ExcelUtil.setCellValue(cell, metaCell.getCaption()+ column.getCaption());	
							colIndex++;
							
						}
						continue;
					} 
				}
				cell = ExcelUtil.getCell(titileRow, colIndex);
				ExcelUtil.setCellValue(cell, metaCell.getCaption());	
				colIndex++;
				
				
			}
		}
	}
	
	@SuppressWarnings("deprecation")
	private boolean exportGridTableBody(DefaultContext context,Sheet sheet, MetaForm metaForm, MetaGrid metaGrid, MetaTable metaTable,
			DataTable dataTable, DataTable originalDataTable) throws Throwable{

		// 循环界面上的所有行、列
		Object value = null;
		int rowIndex = 1;
		Row dataRow = null;
		
		Iterator<MetaGridRow> cellRow = metaGrid.getRowCollection().iterator();
		dataTable.beforeFirst();
		
		MetaGridRow metaRow = null;
		MetaGridCell metaCell = null;
		Cell cell = null;
		while (cellRow.hasNext()) {
			metaRow = cellRow.next();
			if (metaRow.getRowType() != RowType.Detail) {
				continue;
			}

			while (dataTable.next(true)) {
				int colIndex = 0;
				int realColIndex = 0;
				dataRow = ExcelUtil.getRow(sheet, rowIndex);
				Iterator<MetaGridCell> itCell = metaRow.iterator();
				rowIndex++;
				
				//104_8576的限制是Excel单个Sheet的最大行数限制
				if(rowIndex >= 104_8000){
					return false;
				}
				
				
				while (itCell.hasNext()) {
					realColIndex++;
					metaCell = itCell.next();
					
					//如果是选择字段，不设置值
					if ( metaCell.isSelect() ) {
						continue;
					}
					//如果是不可见的列，不设置
					if ( !isVisibleColumn(metaGrid, realColIndex - 1) ) {
						continue;
					}
					//单元格绑定表标识与表标识不一致，不设置
					if ( !metaTable.getKey().equals(metaCell.getTableKey()) ) {
						continue;
					}
					
					if(DictColumnUtil.needExpandDictColumn(metaCell) && originalDataTable.size() != 0){
						VE ve = context.getVE();
						MetaDictProperties dictProperties = (MetaDictProperties)metaCell.getProperties();
						
						List<MetaColumn> displayCols = DictColumnUtil.getDictDisplayColumns(ve, dictProperties);
							
						int expandColunt = displayCols == null ? 0 : displayCols.size();
						if(expandColunt > 1){
							Object dictID = dataTable.getObject(metaCell.getColumnKey());
							for (int i = 0; i < expandColunt; i++) {
								cell = ExcelUtil.getCell(dataRow, colIndex);
								String columnKey = displayCols.get(i).getKey();
								Object cellValue = DictColumnUtil.getDictItemValue(
												context, dictProperties.getItemKey(), columnKey, dictID );
								ExcelUtil.setCellValue(cell, cellValue);
								
								colIndex++;
							}
							continue;
						}
					}
					value = DataTransferUtil.convertFieldValue(context, metaForm, metaCell.getCellType(),
				    		metaCell.getProperties(), dataTable, metaCell.getColumnKey());

			      cell = ExcelUtil.getCell(dataRow, colIndex);
				  ExcelUtil.setCellValue(cell, value);
				  colIndex++;
					
				}
			}
		
		}
		return true;
	}
	
	private boolean isVisibleColumn(MetaGrid metaGrid, int realColIndex){
		MetaGridColumnCollection gridColumnCollection = metaGrid.getColumnCollection();
		for(int i= 0;i<gridColumnCollection.size();i++){
			MetaGridColumn gridColumn = gridColumnCollection.get(i);
			String visible = gridColumn.getVisible();
			if (visible.endsWith("false") &&  i == realColIndex){
				return false;
			}
		}
		return true;
	}

	private void exportHeadTable(DefaultContext context, Workbook workbook, MetaForm metaForm, MetaTable metaTable, DataTable dataTable)
			throws Throwable {
		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, MetaComponent> map = new HashMap<String, MetaComponent>();
		// 先找到属于这张表的字段
		MetaComponent metaComponent = null;
		Iterator<MetaComponent> itComponent = metaForm.getAllComponents().iterator();
		while (itComponent.hasNext()) {
			metaComponent = itComponent.next();
			if (metaTable.getKey().equals(metaComponent.getTableKey()) && !metaComponent.getVisible().equals("false")) {
				map.put(metaComponent.getColumnKey(), metaComponent);
			}
		}

		Object value = "";
		MetaColumn metaColumn = null;

		Sheet sheet = this.getSheet(workbook, metaTable);
		// 循环所有列，有字段的才做导出
		if (dataTable.first()) {
			Row titleRow = ExcelUtil.getRow(sheet, 0);
			Row dateRow = ExcelUtil.getRow(sheet, 1);

			Cell cell = null;
			int colIndex = 0;
			Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
			while (itMetaColumn.hasNext()) {
				metaColumn = itMetaColumn.next();
				String columnKey = metaColumn.getKey();
				metaComponent = map.get(columnKey);
				
				if(metaComponent == null){
					continue;
				}

				//字典特殊处理，如显示多项则拆列
				if (metaComponent.getControlType() == ControlType.DICT) {
					MetaDictProperties dp = (MetaDictProperties)metaComponent.getProperties();
					if (!dp.isAllowMultiSelection()){
						VE ve = context.getVE();
						List<MetaColumn> displayCols = DictColumnUtil.getDictDisplayColumns(ve, dp);
						int displayColumnCount = displayCols == null ? 0 : displayCols.size();
						
						Object dictID = dataTable.getObject(metaComponent.getColumnKey());
						if(displayColumnCount > 1){
							for (int i = 0; i < displayColumnCount; i++) {
								MetaColumn metaDisplaycolumn = displayCols.get(i);
							    
								cell = ExcelUtil.getCell(titleRow, colIndex);
								ExcelUtil.setCellValue(cell, metaColumn.getCaption()+ metaDisplaycolumn.getCaption());
							
								cell = ExcelUtil.getCell(dateRow, colIndex);
								ExcelUtil.setCellValue(cell,  DictColumnUtil.getDictItemValue(
										context, dp.getItemKey(), metaDisplaycolumn.getKey(), dictID ));
								colIndex++;
							}
							continue;
						}
					}
				}
				cell = ExcelUtil.getCell(titleRow, colIndex);
				ExcelUtil.setCellValue(cell, metaColumn.getCaption());

				value = DataTransferUtil.convertFieldValue(context, metaForm, metaComponent.getControlType(),
						metaComponent.getProperties(), dataTable, columnKey);
				cell = ExcelUtil.getCell(dateRow, colIndex);
				ExcelUtil.setCellValue(cell, value);

				colIndex++;
			
			}
		}
	}


	private Sheet getSheet(Workbook workbook, MetaTable metaTable){
		String sheetName = metaTable.getCaption().isEmpty() ? metaTable.getKey(): metaTable.getCaption();
		return ExcelUtil.getSheet(workbook, sheetName);
	}
}