package com.bokesoft.yes.excel.cmd.normal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import com.bokesoft.yes.excel.datatransfer.DataTransferUtil;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;

public class BatchExportTools {

	private Workbook workbook = null;
	// 待导出的界面对象
	private MetaForm exportMetaForm;
	// 待导出的数据对象
	private MetaDataObject exportMetaDataObject;
	// 待导出的单据的参数集合
	private ExportExcelParas paras;
	// 记录导出的sheet以及对应的行号
	private HashMap<String, Integer> sheetRowIndex = new HashMap<String, Integer>();
	
	private ExcelStyleFactory styleFactory = null;

	public BatchExportTools(MetaForm exportMetaForm, ExportExcelParas paras) {
		this.paras = paras;
		this.exportMetaForm = exportMetaForm;
		this.exportMetaDataObject = exportMetaForm.getDataSource().getDataObject();
		
		workbook = new SXSSFWorkbook(1000);
		styleFactory = new ExcelStyleFactory(workbook);
	}

	public void exportSingleData(DefaultContext context, long OID) throws Throwable {
		MetaTable mainTable = exportMetaDataObject.getMainTable();
		
		FilterMap filterMap = new FilterMap();
		filterMap.setOID(OID);
		LoadMultiPageDocument loadMultiPageDocument = new LoadMultiPageDocument(context, filterMap, null);
		Document exportDocument = loadMultiPageDocument.reloadDocument(exportMetaForm);
		try{
			String relationalValue = exportDocument.get(mainTable.getKey()).getObject(paras.getRelationalKey()).toString();
			Sheet sheet = null;
			MetaTable metaTable = null;
			Iterator<MetaTable> itTables = exportMetaDataObject.getTableCollection().iterator();
			while (itTables.hasNext()) {
				metaTable = itTables.next();
				String tableCaption = metaTable.getCaption();
				sheet = ExcelUtil.getSheet(workbook, tableCaption);
				boolean isMainTable = mainTable == metaTable;
				fillData(context, sheet, metaTable, isMainTable, exportDocument, relationalValue);
			}
		}finally{
			if(exportDocument != null){
				exportDocument.close();
			}
		}

	}

	@SuppressWarnings("deprecation")
	private void fillData(DefaultContext context, Sheet sheet, MetaTable metaTable, boolean isMainTable, Document exportDocument, String relationalValue) throws Throwable {
		String tableKey = metaTable.getKey();
		ArrayList<String> columnList = paras.getColumnListByTableKey(tableKey);
		HashMap<String, ExportComponentInfo> componentInfoMap = paras.getComponentInfoByTableKey(tableKey);
		
		int rowIndex = sheetRowIndex.get(sheet.getSheetName());
		int colIndex = 0;

		Object value = null;
		ExportComponentInfo componentInfo = null;
		DataTable dataTable = exportDocument.get(tableKey);
		dataTable.beforeFirst();
		while(dataTable.next(true)) {
			colIndex = 0;
			if (!isMainTable) {
				ExcelUtil.setCellValue(sheet, rowIndex, colIndex, relationalValue);
				colIndex++;
			}
			
			Iterator<String> it = columnList.iterator();
			while(it.hasNext()) {
				String columnKey = it.next();
				MetaComponent component = exportMetaForm.componentByKey(columnKey);
				componentInfo = componentInfoMap.get(columnKey);
				
				if (componentInfo != null) {
					value = DataTransferUtil.convertFieldValue(context, exportMetaForm, componentInfo.getControlType(), componentInfo.getProperties(), dataTable, columnKey);
					ExcelUtil.setCellValue(sheet, rowIndex, colIndex, value);
					if(component != null){
						ExcelUtil.getCell(sheet, rowIndex, colIndex).setCellStyle(styleFactory.getCellStyle(component));
					}
					colIndex++;
				}
			}
			
			rowIndex++;
		}
		
		sheetRowIndex.put(sheet.getSheetName(), rowIndex);
	}
	
	public void exportTitleData() {
		MetaTable mainTable = exportMetaDataObject.getMainTable();

		Sheet sheet = null;
		MetaTable metaTable = null;
		Iterator<MetaTable> it = exportMetaDataObject.getTableCollection().iterator();
		while (it.hasNext()) {
			metaTable = it.next();
			String tableCaption = metaTable.getCaption();
			sheet = ExcelUtil.getSheet(workbook, tableCaption);
			boolean isMainTable = mainTable == metaTable;
			fillTitleData(sheet, metaTable, isMainTable);
		}
	}

	private void fillTitleData(Sheet sheet, MetaTable metaTable, boolean isMainTable) {
		String tableKey = metaTable.getKey();

		ArrayList<String> columnList = paras.getColumnListByTableKey(tableKey);
		HashMap<String, ExportComponentInfo> componentInfoMap = paras.getComponentInfoByTableKey(tableKey);

		int rowIndex = 0;
		int colIndex = 0;

		if (columnList == null) {
			sheetRowIndex.put(sheet.getSheetName(), rowIndex);
			return;
		}
		
		if (!isMainTable) {
			ExcelUtil.setCellValue(sheet, rowIndex, colIndex, paras.getRelationalCaption());
			colIndex++;
		}

		ExportComponentInfo componentInfo = null;
		Iterator<String> it = columnList.iterator();
		while (it.hasNext()) {
			String columnKey = it.next();
			//导出标题为导出数据的伙伴组件
			MetaComponent buddyComponent = null;
			MetaComponent component = exportMetaForm.componentByKey(columnKey);
			if (component != null){
				buddyComponent = exportMetaForm.componentByKey(component.getBuddyKey());
			}

			componentInfo = componentInfoMap.get(columnKey);
			if (componentInfo == null) {
				MetaColumn metaColumn = metaTable.get(columnKey);
				ExcelUtil.setCellValue(sheet, rowIndex, colIndex, metaColumn.getCaption());
			} else {
				ExcelUtil.setCellValue(sheet, rowIndex, colIndex, componentInfo.getCaption());
			}
			if(buddyComponent != null){
				ExcelUtil.getCell(sheet, rowIndex, colIndex).setCellStyle(styleFactory.getCellStyle(buddyComponent));
			}
			
			colIndex++;
		}
		rowIndex++;
		sheetRowIndex.put(sheet.getSheetName(), rowIndex);
	}
	
	public Workbook getWorkbook() {
		return workbook;
	}
}
