package com.bokesoft.yes.excel.cmd.normal;

import java.util.Iterator;

import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;

public class BatchExportExcelCmd extends DefaultServiceCmd {
	// 当前表单的FormKey
	private String formKey = null;
	// 待导出的FormKey
	private String exportFormKey = null;
	// 批量导出界面中的对应table
	private String tableKey = null;
	// 待导出的单据的OID所在的字段
	private String OIDFieldKey = null;
	// 批量导出界面的过滤条件
	private FilterMap filterMap = null;
	// 批量导出界面的过滤条件
	private ConditionParas condParameters = null;
	// 单据的批量导出模板，没有表示导出全部字段
	private String templateKey = null;
	// 导出后事件
	private String postExportServiceName = null;
	// 当前界面的Document
	private Document document = null;
	//自定义导出的文件名
	private String exportFileName=null;
	
	private boolean needDownload = false;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = arguments.get("formKey").toString();
		exportFormKey = arguments.get("exportFormKey").toString();
		tableKey = arguments.get("tableKey").toString();
		OIDFieldKey = arguments.get("OIDFieldKey").toString();
		templateKey = arguments.get("templateKey").toString();
		postExportServiceName = arguments.get("postExportServiceName").toString();
		exportFileName=arguments.get("exportFileName").toString();
		needDownload = TypeConvertor.toBoolean(arguments.get("needDownload"));
		JSONObject documentObj = new JSONObject(arguments.get("document").toString());
		document = new Document(null, -1);
		document.fromJSON(documentObj);
		
		filterMap = new FilterMap();
		String filterMapJSONStr = arguments.get("filterMap").toString();
		filterMap.fromJSON(new JSONObject(filterMapJSONStr));
		
		// 处理查询条件
		String conditions = arguments.get("condition").toString();
		if ( conditions != null && !conditions.isEmpty() ) {
			condParameters = new ConditionParas();
			condParameters.fromJSON(new JSONObject(conditions));
		}
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		
		MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
		// 循环查看是否有分页需要重新载入
		if (isNeedLoadData(metaForm, metaDataObject)) {
			LoadMultiPageDocument loadMultiPageDocument = new LoadMultiPageDocument(new DefaultContext(context), filterMap, condParameters);
			document = loadMultiPageDocument.reloadDocument(metaForm);
		} else {
			// 没有重新加载的数据集，把游标都归位
			MetaTable metaTable = null;
			Iterator<MetaTable> it = metaDataObject.getTableCollection().iterator();
			while(it.hasNext()) {
				metaTable = it.next();
				document.get(metaTable.getKey()).beforeFirst();
			}
		}
		
		DataTable dataTable = document.get(tableKey);
		
		IExport export = null;
		if(templateKey.isEmpty()) {
			export = new BatchExportExcel(context, dataTable, OIDFieldKey, exportFormKey, postExportServiceName,exportFileName,needDownload);
		} else {
			String projectKey = metaForm.getProject().getKey();
			MetaExcelWorkbook metaWorkbook = metaFactory.getExcelTemplate(projectKey, templateKey);
			export = new BatchExportExcelWithTemplate(context, metaWorkbook, dataTable, OIDFieldKey, exportFormKey, postExportServiceName,exportFileName,needDownload);
		}
		return export.exportData();
	}
	
	public boolean isNeedLoadData(MetaForm metaForm, MetaDataObject metaDataObject) {
		MetaTable metaTable = null;

		Iterator<MetaTable> itTables = metaDataObject.getTableCollection().iterator();
		while (itTables.hasNext()) {
			metaTable = itTables.next();
			int tableModel = metaTable.getTableMode();
			switch (tableModel) {
			case TableMode.DETAIL:
				MetaComponent metaComponent = metaForm.findComponentByTable(metaTable.getKey());
				if( metaComponent == null )
					break;
				switch (metaComponent.getControlType()) {
				case ControlType.GRID:
					MetaGrid metaGrid = (MetaGrid)metaComponent;
					if( metaGrid.getPageLoadType() == PageLoadType.DB ) {
						return true;
					}
					break;
				case ControlType.LISTVIEW:
					MetaListView metaListView = (MetaListView)metaComponent;
					if( metaListView.getPageLoadType() == PageLoadType.DB ) {
						return true;
					}
					break;
				case ControlType.EDITVIEW:
					MetaEditView metaEditView = (MetaEditView)metaComponent;
					if( metaEditView.getPageLoadType() == PageLoadType.DB ) {
						return true;
					}
					break;
				}
			}
		}
		return false;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new BatchExportExcelCmd();
	}

	@Override
	public String getCmd() {
		return "BatchExportExcel";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
