package com.bokesoft.yes.dts;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.dts.data.DTSData;
import com.bokesoft.yes.dts.data.IDTSDataProvider;
import com.bokesoft.yes.dts.types.OperationTypes;
import com.bokesoft.yes.dts.types.TransactionType;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.exception.CoreException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.document.LoadData;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;


/**
 * 
 * @author lingc
 *
 */
public class  DataTransferService {
	/**
	 * 多张表单的处理
	 * @param context
	 * @param dtsDataArray
	 * @param transactionType
	 * @return
	 * @throws Throwable
	 */
	public static final Object multiDataTransfer(DefaultContext context, 
			IDTSDataProvider dtsDataBuilder,
			String jsonString, 
			int transactionType) throws Throwable{
		LogSvr.getInstance().info("json string: " + jsonString);
		JSONArray jsonArray = new JSONArray(jsonString);
	
		List<DTSData> dtsDataList = new ArrayList<DTSData>();
		List<DefaultContext> dtsContextList = new ArrayList<DefaultContext>();
		int length = jsonArray.length();
		for(int i = 0; i < length; i++){
			JSONObject jsonObject = jsonArray.getJSONObject(i);
			DTSData dtsData = dtsDataBuilder.getDTSData(jsonObject.toString(), context);
			dtsDataList.add(dtsData);
			DefaultContext dtsContext = dtsDataBuilder.getContext(context);
			dtsContextList.add(dtsContext);
		}
		
		
		
		JSONArray result = new JSONArray();
		for(int i = 0; i < length; i++){
			DTSData dtsData = dtsDataList.get(i);
			DefaultContext dtsContext = dtsContextList.get(i);
			try{
				LogSvr.getInstance().info("服务处理开始\n" + dtsData);
				Object obj = dataTransfer(dtsContext, dtsData);
				LogSvr.getInstance().info("服务处理结束\n " + obj);
				if(transactionType == TransactionType.WHOLE){
					if(obj == null)
						result.put(true);
					else
						result.put(obj);
				}
				else{
					JSONObject wrapperResult = new JSONObject();
					wrapperResult.put("yigo_success", true);
					if(obj == null)
						wrapperResult.put("data", true);
					else
						wrapperResult.put("data", obj);
					result.put(wrapperResult);
				}
			}
			catch(Throwable t){
				/*整体事务，直接抛出异常*/
				if(transactionType == TransactionType.WHOLE){
					throw t;
				}
				/*独立事务，包装异常，继续执行后续的表单*/
				else if(transactionType == TransactionType.INDEPENDENT){	
					t.printStackTrace();
					JSONObject wrapperResult = new JSONObject();
					wrapperResult.put("yigo_success", false);
					JSONObject error = new JSONObject();
					wrapperResult.put("error", error);
					if ( t instanceof CoreException ) {
						CoreException ye = (CoreException)t;
				
						error.put("error_code", ye.getCode());
						error.put("error_info", ye.getMessage());
					} else {
						error.put("error_code", -1);
						error.put("error_info", t.getMessage());
					}
					result.put(wrapperResult);
				}
			}
			
		}
		return result;
	}
	
	/**
	 * 单张表单的处理
	 * @param context
	 * @param dtsData
	 * @return
	 * @throws Throwable
	 */
	public static final Object dataTransfer(DefaultContext context, DTSData dtsData) throws Throwable {
		
		context.setFormKey(dtsData.getFormKey());
		
		String dataObjectKey = dtsData.getDataObjectKey();
		/* 根据dataObjectKey去查找MetaDataObject */
		MetaDataObject metaDataObject = context.getVE().getMetaFactory().getDataObject(dataObjectKey);
		if(metaDataObject == null)
			throw new DTSException(DTSException.NO_DATAOBJECT, "找不到对应的元数据对象: "+dataObjectKey);	
		MetaTable metaMainTable = metaDataObject.getMainTable();
		String mainTableKey = metaMainTable.getKey();
		Document doc = dtsData.getDocument();
		DataTable mainTable = doc.get(mainTableKey);
		
		/*如果定义了关键字集合，需要检查所有列的有效性*/
		List<String> primaryColumns = dtsData.getPrimary(mainTableKey);		
		if(primaryColumns != null){
			if(validateColumns(metaMainTable, primaryColumns) == false){
				throw new DTSException(DTSException.INVALID_KEY_COLUMN, "无效的业务关键字 "+primaryColumns);	 
			}
		}
		
		/*	根据业务关键字去查数据对象是否存在，不存在或无业务关键字的情况OID为-1	*/
		Long OID  = queryOID(context.getDBManager(), metaMainTable, mainTable, 0, primaryColumns);
		
		OperationTypes operation = dtsData.getOperation();
		/*删除*/
		if(operation == OperationTypes.DELETE){
			LogSvr.getInstance().info("删除");
			Delete delete = new Delete(context, OID, dataObjectKey);
			return delete.delete();
		}
		/*不是删除的时候才有必要进一步处理文档*/
//		Document document = newDocumentFromDTSDocument(metaDataObject, doc);
		Document document = doc;
		if(operation == OperationTypes.INSERT){
			/*要更新的数据对象已经存在(根据业务关键字定义的唯一性)*/
			if(OID != -1){
				if(dtsData.isInsertCheck() == true){
					return null;
				}
			}
			LogSvr.getInstance().info("插入");
			Insert insert = new Insert(null, document, dtsData, metaDataObject, context);
			return insert.insert();
		}
		if( operation == OperationTypes.UPDATE ){
			/*要更新的数据对象不存在*/
			if(OID == -1){
				if(dtsData.isUpdateCheck() == false)
					return null;
				/*更新找不到需要抛出异常*/
				else
					throw new DTSException(DTSException.UPDATE_DATAOBJECT_NOT_EXIST, "要更新的数据对象不存在");
			}
			else{
				LogSvr.getInstance().info("更新");
				/*载入数据*/
				LoadData loadData = new LoadData(dataObjectKey, OID);
				Document localDocument = loadData.load(context, null);
				Update update = new Update(metaDataObject, dtsData, localDocument, document, context);
				return update.update();
			}
		}
		if( operation == OperationTypes.I_OR_U || operation == OperationTypes.DEFAULT){
			if(OID == -1){
				Document localDocument = DocumentUtil.newDocument(metaDataObject);
				Insert insert = new Insert(localDocument, document, dtsData, metaDataObject, context);
				return insert.insert();
			}
			else{
				LoadData loadData = new LoadData(dataObjectKey, OID);
				Document localDocument = loadData.load(context, null);
				Update update = new Update(metaDataObject, dtsData, localDocument, document, context);
				return update.update();
			}
		}
		throw new DTSException(DTSException.UNKNOWN_OPERATION, "未知的数据对象上的操作:"+operation); 			
	}
	
	
	

	/**
	 * 根据业务关键字查询表中的某行的OID。
	 * @param dbManager 
	 * @param metaTable 要查询表的meta数据
	 * @param dataTable 要查询的表
	 * @param pos 表中的行
	 * @param primaryColumns 业务关键字集合
	 * @return 存在返回OID，不存在返回-1。如果没有业务关键字返回-1
	 */
	private static final Long queryOID(IDBManager dbManager, 
			MetaTable metaTable, 
			DataTable dataTable, 
			int pos, 
			List<String> primaryColumns) throws Throwable{	
		/*表中没有数据， 不用查询*/
		if(dataTable.size() == 0)
			return new Long(-1);
		/*没有业务关键字，就返回-1*/
		if(primaryColumns == null)
			return new Long(-1);
		/*只需要查OID*/
		ArrayList<String> resultFieldKeyList = new ArrayList<String>();
		resultFieldKeyList.add(SystemField.OID_SYS_KEY);
		/*业务关键字作为查询条件*/
		ArrayList<String> conditionFieldKeyList = new ArrayList<String>();
		dataTable.setPos(pos);
		PSArgs args = new PSArgs();
		for(String key: primaryColumns){
			ColumnInfo info = dataTable.getMetaData().getColumnInfo(key);
			args.addArg(info.getDataType(), dataTable.getObject(key));
			MetaColumn meta = metaTable.get(key);
			String dbColumnName = meta.getBindingDBColumnName();
			conditionFieldKeyList.add(dbColumnName);
		}
				
		String querySql = DBUtil.getQuerySQL(dbManager, 
				resultFieldKeyList, 
				metaTable.getBindingDBTableName(),
				conditionFieldKeyList);
		ResultSet rs = null;
		PreparedStatement ps = null;
		try {
			ps = dbManager.preparedQueryStatement(querySql);
			rs = dbManager.executeQuery(ps, querySql, args);
			
			if(rs.next()){
				Long OID = rs.getLong("OID");
				/*有多个对应的数据对象*/
				if(rs.next())
					throw new DTSException(DTSException.DUPLICATE_DATAOBJECT, "关键字上数据对象重复:"+querySql);
				return OID;
			}
			else
				return new Long(-1);
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (ps != null) {
				ps.close();
			}
		}
	}	
	
	/**
	 * 检查列集合是否都有效
	 * @param metaTable
	 * @param columns
	 * @return
	 */
	private static final boolean validateColumns(MetaTable metaTable, List<String> columns){
		for(String column: columns){
			if( metaTable.containsKey(column) == false)
				return false;
		}
		return true;
	}

	
}
