package com.bokesoft.yes.design.util;

import java.io.InputStream;

import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.setting.MetaSimpleSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.util.DataTableCreator;

public class GridTemplateUtil {
	/**
	 * 查询网格模板列表
	 * @param context 上下文
	 * @return 模板列表，以DataTable形式返回
	 * @throws Throwable
	 */
	public static DataTable queryGridTemplates(DefaultContext context) throws Throwable {
		DataTable table = DataTableCreator.create(new Object[][] {
				{ "Key", DataType.STRING },
				{ "Caption", DataType.STRING },
				{ "Description", DataType.STRING }
		});
		 
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaSetting setting = metaFactory.getSetting();
		String projectKey = null;
		if ( setting != null ) {
			MetaSimpleSetting simpleSetting = setting.getSimpleSetting("GridDesignTarget");
			if ( simpleSetting != null ) {
				projectKey = simpleSetting.get("Project");
			}
		}
		if ( projectKey != null && !projectKey.isEmpty() ) {
			InputStream is = metaFactory.loadInputStream(projectKey, "GridTemplate.xml");
			if ( is != null ) {
				try {
					
				} finally {
					is.close();
				}
			}
		}
		
		return table;
	}
}
