package com.bokesoft.yes.design.function;

import com.bokesoft.yes.design.util.GridTemplateUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.parser.BaseMidFunctionImpl;
import com.bokesoft.yigo.parser.BaseFunImplCluster;
import com.bokesoft.yigo.parser.IExecutor;
import com.bokesoft.yigo.struct.datatable.DataTable;

public class DesignMidFunction extends BaseFunImplCluster {
	/**
	 * QueryGridTemplates中间层查询自定义网格模板列表
	 * @author wangyh
	 *
	 */
	class QueryGridTemplatesImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context,
				Object[] args, IExecutor executor) throws Throwable {
			DataTable table = GridTemplateUtil.queryGridTemplates(context);
			return table;
		}
		
	}
	
	@Override
	public Object[][] getImplTable() {
		return new Object[][] {
				{ "QueryGridTemplates", new QueryGridTemplatesImpl() }	
		};
	}

}
