/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.util.resource.icon;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSource;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSourceCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.util.resource.icon.css.CssSourceGeneratorFactory;
import com.bokesoft.yigo.mid.util.resource.icon.css.generator.ICSSSourceGenerator;
import com.bokesoft.yigo.mid.util.resource.icon.provider.IIconSourceProvider;
import com.bokesoft.yigo.mid.util.resource.icon.provider.IconSourceProviderRegistry;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class IconSourceUtil {
    private static final String CSS_FILE_PATH = "Resource" + File.separator + "icon-source-temp.css";
    private static final String CSS_CLASS_INFO_PATH = "Resource" + File.separator + "icon-source-info-temp";

    public static String generateCssSource(IMetaFactory object) throws Throwable {
        LogSvr.getInstance().info("\u5f00\u59cb\u751f\u6210IconSource css\u6587\u4ef6");
        Date date = new Date();
        IconSourceUtil.clearFile(object);
        MetaIconSourceCollection metaIconSourceCollection = new MetaIconSourceCollection();
        MetaIconSourceCollection metaIconSourceCollection2 = object.getIconSourceCollection();
        metaIconSourceCollection.merge(metaIconSourceCollection2);
        metaIconSourceCollection2 = IconSourceUtil.getIconSourceCollectionByProvider(object);
        metaIconSourceCollection.merge(metaIconSourceCollection2);
        object = IconSourceUtil.generateCss(metaIconSourceCollection, object);
        long l2 = new Date().getTime() - date.getTime();
        LogSvr.getInstance().info("\u7ed3\u675f\u751f\u6210IconSource css\u6587\u4ef6\u3002\u751f\u6210\u6570\uff1a" + metaIconSourceCollection.size() + ",\u8017\u65f6\uff1a" + l2 + ",\u8def\u5f84\uff1a" + (String)object);
        return object;
    }

    private static String generateCss(MetaIconSourceCollection metaIconSourceCollection, IMetaFactory iMetaFactory) throws Throwable {
        MetaIconSource metaIconSource;
        StringBuilder stringBuilder = new StringBuilder();
        if (metaIconSourceCollection == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < metaIconSourceCollection.size(); ++i2) {
            metaIconSource = (MetaIconSource)metaIconSourceCollection.get(i2);
            String string = metaIconSource.getKey();
            String string2 = metaIconSource.getScene();
            String string3 = "";
            JSONObject jSONObject = new JSONObject();
            try {
                ICSSSourceGenerator iCSSSourceGenerator = CssSourceGeneratorFactory.getGenerator(string2);
                if (iCSSSourceGenerator != null) {
                    string3 = iCSSSourceGenerator.generateIcon(iMetaFactory, metaIconSource);
                    jSONObject.put("key ", (Object)metaIconSource.getKey());
                    jSONObject.put("scene", (Object)metaIconSource.getScene());
                    jSONObject.put("className", (Object)iCSSSourceGenerator.getIconClassName(iMetaFactory, metaIconSource));
                    if (metaIconSource.getDisplayMode() != null) {
                        jSONObject.put("displayMode", (Object)metaIconSource.getDisplayMode());
                    }
                }
            }
            catch (Exception exception) {
                string3 = null;
                LogSvr.getInstance().error("generate failed, IconSource:" + string + " scene:" + string2, (Throwable)exception);
            }
            if (string3 == null || string3.isEmpty()) continue;
            stringBuilder.append("\r\n");
            stringBuilder.append(string3);
            jSONArray.put((Object)jSONObject);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("[class*=isc-]");
            stringBuilder.append("{");
            stringBuilder.append("background-repeat: no-repeat;");
            stringBuilder.append("background-size: cover;");
            stringBuilder.append("background-position: center center;");
            stringBuilder.append("}");
            stringBuilder.append("[class*=isc-]::before");
            stringBuilder.append("{");
            stringBuilder.append("align-items: center;");
            stringBuilder.append("justify-content: center;");
            stringBuilder.append("display: flex;");
            stringBuilder.append("height: 100%;");
            stringBuilder.append("width: 100%;");
            stringBuilder.append("}");
            metaIconSource = iMetaFactory.getMetaResolverFactory().newMetaResolver("");
            metaIconSource.write(CSS_FILE_PATH, stringBuilder.toString().getBytes());
            metaIconSource.write(CSS_CLASS_INFO_PATH, jSONArray.toString().getBytes());
            return CSS_FILE_PATH;
        }
        return null;
    }

    private static void clearFile(IMetaFactory object) throws Throwable {
        Comparable<URI> comparable = (object = object.getMetaResolverFactory().newMetaResolver("")).getURI(CSS_FILE_PATH, 0);
        if (comparable != null && ((File)(comparable = new File((URI)comparable))).exists()) {
            ((File)comparable).delete();
        }
        if ((comparable = object.getURI(CSS_CLASS_INFO_PATH, 0)) != null && ((File)(object = new File((URI)comparable))).exists()) {
            ((File)object).delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getIconSourceCss(IMetaFactory object) throws Throwable {
        object = object.getMetaResolverFactory().newMetaResolver("");
        Object object2 = null;
        object = object.read(CSS_FILE_PATH, 0);
        Throwable throwable = null;
        try {
            if (object != null) {
                object2 = IOUtils.toString((InputStream)object, (Charset)StandardCharsets.UTF_8);
            }
            if (object == null) return object2;
        }
        catch (Throwable throwable2) {
            try {
                object2 = throwable2;
                throwable = throwable2;
                throw object2;
            }
            catch (Throwable throwable3) {
                if (object == null) throw throwable3;
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable3;
                } else {
                    ((InputStream)object).close();
                }
                throw throwable3;
            }
        }
        ((InputStream)object).close();
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getIconSourceClassMap(IMetaFactory object) throws Throwable {
        object = object.getMetaResolverFactory().newMetaResolver("");
        Object object2 = null;
        object = object.read(CSS_CLASS_INFO_PATH, 0);
        Throwable throwable = null;
        try {
            if (object != null) {
                object2 = IOUtils.toString((InputStream)object, (Charset)StandardCharsets.UTF_8);
            }
            if (object == null) return object2;
        }
        catch (Throwable throwable2) {
            try {
                object2 = throwable2;
                throwable = throwable2;
                throw object2;
            }
            catch (Throwable throwable3) {
                if (object == null) throw throwable3;
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable3;
                } else {
                    ((InputStream)object).close();
                }
                throw throwable3;
            }
        }
        ((InputStream)object).close();
        return object2;
    }

    private static MetaIconSourceCollection getIconSourceCollectionByProvider(IMetaFactory iMetaFactory) throws Throwable {
        Map<String, IIconSourceProvider> map = IconSourceProviderRegistry.getProviders();
        MetaIconSourceCollection metaIconSourceCollection = new MetaIconSourceCollection();
        for (String string : map.keySet()) {
            if ((string = map.get(string).getIconSourceCollection(iMetaFactory)) == null) continue;
            metaIconSourceCollection.merge((MetaIconSourceCollection)string);
        }
        return metaIconSourceCollection;
    }
}

