/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.log;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.log.LogArchiveIOFactory;
import com.bokesoft.yigo.mid.log.LogData;
import com.bokesoft.yigo.mid.variant.VariantData;
import com.bokesoft.yigo.mid.variant.VariantKey;
import com.bokesoft.yigo.mid.variant.log.ILogArchiveIO;
import com.bokesoft.yigo.mid.variant.log.LogKey;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class ArchiveProxy {
    private static final int BATCH_SIZE = 1000;
    private List<LogKey> toDeleteKeys = new ArrayList<LogKey>();
    private String type;

    public ArchiveProxy(String string) {
        this.type = string;
    }

    public void archive(DefaultContext defaultContext, Date date) throws Throwable {
        block6: {
            DefaultContext defaultContext2 = null;
            try {
                defaultContext2 = new DefaultContext(defaultContext.getVE());
                this.loadAndArchive(defaultContext2, date);
                this.deleteLog(defaultContext2);
                defaultContext2.commit();
                LogSvr.getInstance().info("bpm log archive completed...");
            }
            catch (Throwable throwable) {
                try {
                    if (defaultContext2 != null) {
                        defaultContext2.rollback();
                    }
                    LogSvr.getInstance().error("bpm log archive error", throwable);
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (defaultContext2 == null) break block6;
                    defaultContext2.close();
                }
            }
            defaultContext2.close();
            return;
        }
    }

    private void loadAndArchive(DefaultContext defaultContext, Date object) throws Throwable {
        ResultSet resultSet;
        block9: {
            Object object2 = new StringBuilder("select * from BPM_Log where FinishTime < ");
            IDBManager iDBManager = defaultContext.getDBManager();
            int n2 = iDBManager.getDBType();
            object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)object);
            if (n2 == 2) {
                ((StringBuilder)object2).append(" to_date(?,'yyyy-mm-dd hh24:mi:ss') ");
            } else {
                ((StringBuilder)object2).append(" ? ");
            }
            object2 = ((StringBuilder)object2).toString();
            PreparedStatement preparedStatement = null;
            resultSet = null;
            ArrayList<LogData> arrayList = new ArrayList<LogData>();
            try {
                preparedStatement = iDBManager.preparedQueryStatement((String)object2);
                PSArgs pSArgs = new PSArgs();
                pSArgs.addStringArg((String)object);
                resultSet = iDBManager.executeQuery(preparedStatement, (String)object2, (QueryArguments)pSArgs);
                int n3 = 0;
                while (resultSet.next()) {
                    object2 = new LogData();
                    ((LogData)object2).populate(resultSet);
                    arrayList.add((LogData)object2);
                    if (++n3 % 1000 != 0) continue;
                    this.archiveLog(defaultContext, arrayList);
                    arrayList.clear();
                }
                if (arrayList.size() > 0) {
                    this.archiveLog(defaultContext, arrayList);
                    arrayList.clear();
                }
                if (preparedStatement == null) break block9;
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
            return;
        }
    }

    private void loadAndArchive(DefaultContext defaultContext, Date object, Date object2) throws Throwable {
        Object object3;
        block9: {
            CharSequence charSequence = new StringBuilder("select InstanceID, LogID from BPM_Log where FinishTime > ");
            IDBManager iDBManager = defaultContext.getDBManager();
            int n2 = iDBManager.getDBType();
            object3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            object = ((DateFormat)object3).format((Date)object);
            object2 = ((DateFormat)object3).format((Date)object2);
            if (n2 == 2) {
                charSequence.append(" to_date(?,'yyyy-mm-dd hh24:mi:ss') and FinishTime < to_date(?,'yyyy-mm-dd hh24:mi:ss') ");
            } else {
                charSequence.append(" ? and FinishTime < ? ");
            }
            charSequence = charSequence.toString();
            PreparedStatement preparedStatement = null;
            object3 = null;
            ArrayList<LogData> arrayList = new ArrayList<LogData>();
            try {
                preparedStatement = iDBManager.preparedQueryStatement((String)charSequence);
                PSArgs pSArgs = new PSArgs();
                pSArgs.addStringArg((String)object);
                pSArgs.addStringArg((String)object2);
                object3 = iDBManager.executeQuery(preparedStatement, (String)charSequence, (QueryArguments)pSArgs);
                int n3 = 0;
                while (object3.next()) {
                    object2 = new LogData();
                    ((LogData)object2).populate((ResultSet)object3);
                    arrayList.add((LogData)object2);
                    if (++n3 % 1000 != 0) continue;
                    this.archiveLog(defaultContext, arrayList);
                    arrayList.clear();
                }
                if (arrayList.size() > 0) {
                    this.archiveLog(defaultContext, arrayList);
                    arrayList.clear();
                }
                if (preparedStatement == null) break block9;
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (object3 != null) {
                    object3.close();
                }
                throw throwable;
            }
            preparedStatement.close();
        }
        if (object3 != null) {
            object3.close();
            return;
        }
    }

    public void archive(DefaultContext defaultContext, Date date, Date date2) throws Throwable {
        block6: {
            DefaultContext defaultContext2 = null;
            try {
                defaultContext2 = new DefaultContext(defaultContext.getVE());
                this.loadAndArchive(defaultContext2, date, date2);
                this.deleteLog(defaultContext2);
                defaultContext2.commit();
                LogSvr.getInstance().info("bpm log archive completed...");
            }
            catch (Throwable throwable) {
                try {
                    if (defaultContext2 != null) {
                        defaultContext2.rollback();
                    }
                    LogSvr.getInstance().error("bpm log archive error", throwable);
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (defaultContext2 == null) break block6;
                    defaultContext2.close();
                }
            }
            defaultContext2.close();
            return;
        }
    }

    private void archiveLog(DefaultContext defaultContext, List<LogData> object) throws Throwable {
        String string = "bpm-log-archive";
        ILogArchiveIO iLogArchiveIO = LogArchiveIOFactory.getArchiveIO(defaultContext, this.type);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            LogData logData = object2.next();
            long l2 = logData.getInstanceID();
            object = logData.getLogID();
            object = new LogKey(l2, ((Integer)object).intValue());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("index", string);
            object = new VariantKey(object.toString(), hashMap);
            object = new VariantData((VariantKey)object);
            object.setData(logData.toJSON().toString());
            arrayList.add(object);
        }
        if (iLogArchiveIO != null) {
            object2 = iLogArchiveIO.archiveLog(defaultContext, arrayList);
            this.toDeleteKeys.addAll((Collection<LogKey>)object2);
        }
    }

    private void deleteLog(DefaultContext defaultContext) throws Throwable {
        String string = "delete from BPM_Log where InstanceID=? and LogID=?";
        defaultContext = defaultContext.getDBManager();
        string = new BatchPsPara(string);
        for (LogKey logKey : this.toDeleteKeys) {
            long l2 = logKey.getInstanceID();
            int n2 = logKey.getLogId();
            PSArgs pSArgs = new PSArgs();
            pSArgs.addLongArg(Long.valueOf(l2));
            pSArgs.addIntArg(Integer.valueOf(n2));
            string.putArgs(pSArgs);
        }
        defaultContext.executeUpdate((BatchPsPara)string);
    }

    public List<LogData> getLogs(DefaultContext object, long l2) throws Throwable {
        ArrayList<LogData> arrayList = new ArrayList<LogData>();
        String string = "bpm-log-archive";
        ILogArchiveIO iLogArchiveIO = LogArchiveIOFactory.getArchiveIO((DefaultContext)object, this.type);
        if (iLogArchiveIO != null && (object = iLogArchiveIO.loadLogs((DefaultContext)object, l2, string)) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object = ((VariantData)iterator.next()).getData();
                if (!(object = new JSONObject((String)object)).has("data")) continue;
                object = object.getString("data");
                JSONObject jSONObject = new JSONObject((String)object);
                object = new LogData();
                ((LogData)object).fromJSON(jSONObject);
                arrayList.add((LogData)object);
            }
        }
        return arrayList;
    }
}

