/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.schemamgr;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.connection.dbmanager.MySqlClusterDBManager;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCreate;
import java.util.List;

public class SchemaCreate
implements ISchemaCreate {
    public void createTable(IDBManager iDBManager, MetaSchemaTable object) throws Throwable {
        object = this.createTableSql(iDBManager, (MetaSchemaTable)object);
        iDBManager.execPrepareUpdate((String)object, new Object[0]);
    }

    public String createTableSql(IDBManager iDBManager, MetaSchemaTable metaSchemaTable) throws Throwable {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder("create table ");
        stringBuilder.append(iDBManager.keyWordEscape(metaSchemaTable.getKey()));
        stringBuilder.append(" (");
        for (Object object : metaSchemaTable.getColumnCollection()) {
            stringBuilder.append(iDBManager.getColumnDef(object));
            if (metaSchemaTable.getKey().startsWith("QRTZ_") || metaSchemaTable.getKey().startsWith("YBS_")) {
                stringBuilder.append(",");
                continue;
            }
            int n2 = object.getDataType();
            object = object.getDefaultValue();
            if (n2 == 1002 || n2 == 1012) {
                if (StringUtil.isBlankOrNull((String)object)) {
                    stringBuilder.append(" DEFAULT '");
                    stringBuilder.append("  ");
                    stringBuilder.append("' NOT NULL");
                } else {
                    stringBuilder.append(" DEFAULT '");
                    stringBuilder.append(TypeConvertor.toDataType((int)n2, (Object)object) + "'");
                    stringBuilder.append(" NOT NULL");
                }
            } else if (n2 == 1001 || n2 == 1005 || n2 == 1006 || n2 == 1007 || n2 == 1010) {
                if (StringUtil.isBlankOrNull((String)object)) {
                    stringBuilder.append(" DEFAULT 0 NOT NULL");
                } else {
                    stringBuilder.append(" DEFAULT ");
                    stringBuilder.append(TypeConvertor.toDataType((int)n2, (Object)object));
                    stringBuilder.append(" NOT NULL");
                }
            }
            stringBuilder.append(",");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
        for (Object object : metaSchemaTable.getColumnCollection()) {
            if (!object.isPK()) continue;
            if (!bl) {
                bl = true;
                if (iDBManager.getDBType() != 4 && iDBManager.getDBType() != 6) {
                    stringBuilder.append(",CONSTRAINT ");
                    stringBuilder.append(iDBManager.keyWordEscape("PK_" + metaSchemaTable.getPrimaryKey()));
                    stringBuilder.append(" PRIMARY KEY(");
                } else {
                    stringBuilder.append(", PRIMARY KEY(");
                }
            }
            stringBuilder.append(iDBManager.keyWordEscape(object.getKey())).append(",");
        }
        if (bl) {
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.setCharAt(stringBuilder3.length() - 1, ')');
        }
        stringBuilder.append(" )");
        if (iDBManager.getDBType() == 4) {
            stringBuilder.append("ENGINE=INNODB");
            stringBuilder.append(" ROW_FORMAT=Dynamic ");
        } else if (iDBManager.getDBType() == 6) {
            stringBuilder.append("ENGINE=NDB");
        }
        return stringBuilder.toString();
    }

    public void createIndex(IDBManager iDBManager, MetaSchemaTable metaSchemaTable, MetaIndex metaIndex) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder("create ");
        stringBuilder.append(metaIndex.isUnique() != false ? "unique index " : "index ");
        stringBuilder.append(metaIndex.getKey());
        stringBuilder.append(" on ");
        stringBuilder.append(iDBManager.keyWordEscape(metaSchemaTable.getKey()));
        stringBuilder.append("(");
        for (String string3 : metaIndex.getColumns().split(",")) {
            stringBuilder.append(iDBManager.keyWordEscape(string3));
            stringBuilder.append(",");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        try {
            iDBManager.execPrepareUpdate(string, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            String string2 = iDBManager.searchIndex(metaIndex.getKey());
            if (string2 != null) {
                String string3;
                string3 = metaSchemaTable.getKey();
                throw new MidCoreException(19, MidCoreException.formatMessage(null, (int)19, (Object[])new Object[]{string3, metaIndex.getKey(), string2}));
            }
            throw throwable;
        }
    }

    public void createPartition(IDBManager iDBManager, MetaSchemaTable object) throws Throwable {
        if (iDBManager.getDBType() == 6) {
            object = MySqlClusterDBManager.getAlterPartitionSql(iDBManager, object);
            iDBManager.execPrepareUpdate((String)object, new Object[0]);
        }
        throw new UnsupportedOperationException();
    }

    public void alterTable(IDBManager iDBManager, MetaSchemaTable object, List<MetaSchemaColumn> list) throws Throwable {
        object = iDBManager.getAlterTableStr(object, list);
        iDBManager.execPrepareUpdate((String)object, new Object[0]);
    }

    public void alterPartition(IDBManager iDBManager, MetaSchemaTable metaSchemaTable) throws Throwable {
        this.createPartition(iDBManager, metaSchemaTable);
    }
}

