/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.scheduler.job;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.session.LogOvertime;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.schedule.DefaultScheduleJob;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.struct.env.Env;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class EvictExpiredSessionJob
extends DefaultScheduleJob {
    public static final String job = "SessionJob";
    public static final String group = "SessionGroup";
    public static final String triggerName = "SessionTriggerName";
    public static final String triggerGroup = "SessionTriggerGroup";
    public static final String description = "check overtime session";
    public static final long delay = 1200000L;
    public static final int repeatCount = -1;
    public static final long interval = 900000L;

    public void doJob(DefaultContext defaultContext, Map<String, Object> map) throws Throwable {
        LogSvr.getInstance().info(">>>check overtime session<<<");
        this.evictExpiredSessions(defaultContext, 1);
        this.evictExpiredSessions(defaultContext, 2);
        this.evictExpiredSessions(defaultContext, 0);
        this.evictExpiredOvertimeSessions(defaultContext, SessionInfoProviderHolder.getOvertimeProvider());
    }

    private void evictExpiredOvertimeSessions(DefaultContext defaultContext, ISessionInfoProvider object) throws Throwable {
        try {
            defaultContext = object.getSessionInfoMap();
            object = defaultContext.getKeys();
            int n2 = defaultContext.getTimeout();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                object = defaultContext.get(string);
                if (object == null) continue;
                object = object.getType() == 1 ? object.getLastActiveTime() : object.getCreateTime();
                if (new Date().getTime() - ((Date)object).getTime() < (long)(n2 * 1000)) continue;
                LogSvr.getInstance().debug("\u6e05\u7a7a\u8d85\u65f6clientID:".concat(String.valueOf(string)));
                defaultContext.remove(string);
            }
            return;
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    private void evictExpiredSessions(DefaultContext defaultContext, int n2) throws Throwable {
        ISessionInfoMap iSessionInfoMap = SessionInfoProviderHolder.getProvider((int)n2).getSessionInfoMap();
        Object object = iSessionInfoMap.getKeys();
        int n3 = iSessionInfoMap.getTimeout();
        Env env = defaultContext.getVE().getEnv();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ISessionInfo iSessionInfo = iSessionInfoMap.get(string);
            if (iSessionInfo == null) continue;
            object = iSessionInfo.getType() == 1 ? iSessionInfo.getLastActiveTime() : iSessionInfo.getCreateTime();
            if (new Date().getTime() - ((Date)object).getTime() < (long)(n3 * 1000)) continue;
            try {
                if (n2 == 0) continue;
                env.setClientID(string);
                env.setUserID(Long.valueOf(iSessionInfo.getOperatorID()));
                env.setMode(iSessionInfo.getMode());
                env.setClusterid(iSessionInfo.getClusterID());
                new LogOvertime().doLogOvertime(defaultContext);
            }
            catch (Exception exception) {
                LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
                iSessionInfoMap.remove(string);
            }
        }
    }
}

