/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.io.doc;

import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.i18n.StringTable;
import com.bokesoft.yes.mid.io.doc.TableRightsInfo;
import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.mid.util.MetaColumnRightsUtil;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.rights.DictRights;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableRightsFilter {
    private MetaDataObject dataObject;
    private DataTable table;
    private boolean needCheck = false;
    private HashMap<String, List<Long>> columnReadRightsMap = new HashMap();
    private HashMap<String, HashMap<String, List<Long>>> dynamicColumnReadRightsMap = new HashMap();

    public TableRightsFilter(MetaDataObject metaDataObject, DataTable dataTable) {
        this.dataObject = metaDataObject;
        this.table = dataTable;
    }

    public void filter(DefaultContext defaultContext, MetaTable metaTable, boolean bl, boolean bl2) throws Throwable {
        this.load(defaultContext, metaTable);
        if (!this.needCheck) {
            return;
        }
        this.table.first();
        DataTable dataTable = this.table.deepClone();
        while (this.table.isValid()) {
            if (!this.rowCheck(defaultContext, metaTable)) {
                this.table.delete();
                if (this.dataObject.getLoadRightsType() == 1 && this.dataObject.getPrimaryType() == 0) {
                    if (SvrInfo.getNoRightInfoType().equalsIgnoreCase(SvrInfo.NoRightInfoType_Complex)) {
                        TableRightsInfo tableRightsInfo = new TableRightsInfo(defaultContext);
                        dataTable.first();
                        tableRightsInfo.checkRights(defaultContext.getEnv().getUserID(), this.dataObject, defaultContext.getFormKey(), metaTable, dataTable);
                    }
                    throw new MidCoreException(18, StringTable.getString((ILocale)defaultContext.getVE().getEnv(), (String)"", (String)"NoDataObjectAccessPermission"));
                }
                if (this.dataObject.getPrimaryType() != 0 || metaTable.getTableMode() != 0 || this.dataObject.getMainTable() != metaTable && bl) continue;
                if (SvrInfo.getNoRightInfoType().equalsIgnoreCase(SvrInfo.NoRightInfoType_Complex)) {
                    TableRightsInfo tableRightsInfo = new TableRightsInfo(defaultContext);
                    dataTable.first();
                    tableRightsInfo.checkRights(defaultContext.getEnv().getUserID(), this.dataObject, defaultContext.getFormKey(), metaTable, dataTable);
                }
                throw new MidCoreException(18, StringTable.getString((ILocale)defaultContext.getVE().getEnv(), (String)"", (String)"NoDataObjectAccessPermission"));
            }
            this.table.next();
        }
        if (bl2) {
            this.table.batchUpdate();
        }
    }

    private boolean rowCheck(DefaultContext defaultContext, MetaTable metaTable) throws Throwable {
        Object object = MetaFactory.getGlobalInstance().getRightsDefinition();
        if (object == null) {
            return true;
        }
        if ((object = object.getDictRightsCollection()) == null || object.isEmpty()) {
            return true;
        }
        for (Object object2 : metaTable) {
            List<Long> list;
            Object object3;
            if (!MetaColumnRightsUtil.isNeedRight((MetaColumn)object2, (String)defaultContext.getFormKey(), (String)metaTable.getKey(), (DataTable)this.table) || (object3 = object2.getBindingDBColumnName()) == null || ((String)object3).isEmpty()) continue;
            if (!MetaColumnRightsUtil.isDynamicComponent((String)defaultContext.getFormKey(), (String)metaTable.getKey(), (String)object2.getKey())) {
                object3 = TypeConvertor.toLong((Object)this.table.getObject(object2.getKey()));
                list = this.columnReadRightsMap.get(object2.getKey());
                if (list == null || list.contains(object3)) continue;
                return false;
            }
            object3 = TypeConvertor.toLong((Object)this.table.getObject(object2.getKey()));
            list = MetaColumnRightsUtil.getDynamicComponentRefKey((String)defaultContext.getFormKey(), (String)metaTable.getKey(), (String)object2.getKey());
            list = MetaColumnRightsUtil.getColumnKeyOfDynamicComponent((String)defaultContext.getFormKey(), (String)((Object)list));
            list = TypeConvertor.toString((Object)this.table.getObject((String)((Object)list)));
            if ((object2 = this.dynamicColumnReadRightsMap.get(object2.getKey()).get(list)) == null || object2.contains(object3)) continue;
            return false;
        }
        return true;
    }

    private void load(DefaultContext defaultContext, MetaTable metaTable) throws Throwable {
        Long l2 = defaultContext.getVE().getEnv().getUserID();
        if (this.checkIsAdmin(defaultContext.getDBManager(), l2).booleanValue()) {
            return;
        }
        l2 = MetaFactory.getGlobalInstance().getRightsDefinition();
        if (l2 == null) {
            return;
        }
        if ((l2 = l2.getDictRightsCollection()) == null || l2.isEmpty()) {
            return;
        }
        l2 = null;
        for (MetaColumn metaColumn : metaTable) {
            DictRights dictRights;
            Object object;
            if (!MetaColumnRightsUtil.isNeedRight((MetaColumn)metaColumn, (String)defaultContext.getFormKey(), (String)metaTable.getKey(), (DataTable)this.table) || (object = metaColumn.getBindingDBColumnName()) == null || ((String)object).isEmpty()) continue;
            if (l2 == null) {
                l2 = RightsProviderFactory.getInstance().newRightsProvider(defaultContext);
            }
            object = MetaColumnRightsUtil.getItemKey((MetaColumn)metaColumn, (String)defaultContext.getFormKey(), (String)metaTable.getKey(), (DataTable)this.table);
            if (!MetaColumnRightsUtil.isDynamicComponent((String)defaultContext.getFormKey(), (String)metaTable.getKey(), (String)metaColumn.getKey())) {
                dictRights = l2.getDictRights((String)object.get(0));
                object = new ArrayList();
                if (dictRights.hasAllRights()) continue;
                object.addAll(dictRights.getReadRightIds());
                if (dictRights.hasEmptRights()) {
                    object.add(0L);
                }
                this.needCheck = true;
                this.columnReadRightsMap.put(metaColumn.getKey(), (List<Long>)object);
                continue;
            }
            dictRights = new HashMap();
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                DictRights dictRights2 = l2.getDictRights(string);
                ArrayList<Long> arrayList = new ArrayList<Long>();
                if (!dictRights2.hasAllRights()) {
                    arrayList.addAll(dictRights2.getReadRightIds());
                    if (dictRights2.hasEmptRights()) {
                        arrayList.add(0L);
                    }
                    this.needCheck = true;
                    dictRights.put(string, arrayList);
                }
                this.dynamicColumnReadRightsMap.put(metaColumn.getKey(), (HashMap<String, List<Long>>)dictRights);
            }
        }
    }

    public Boolean checkIsAdmin(IDBManager iDBManager, Long l2) throws Throwable {
        String string = "select b.oid, b.isAdmin from SYS_OperatorRole a left join sys_role b on b.oid=a.Role where a.soid = ?";
        if ((iDBManager = iDBManager.execPrepareQuery(string, new Object[]{l2})) != null && !iDBManager.isEmpty()) {
            for (int i2 = 0; i2 < iDBManager.size(); ++i2) {
                if (iDBManager.getInt(i2, "IsAdmin") != 1) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

