/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.io.doc;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.connection.dbmanager.ListQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.preparesql.QuerySQLParameters;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class HisLoad {
    private MetaDataObject dataObject = null;
    private Document document = null;
    private Integer version = null;

    public HisLoad(MetaDataObject metaDataObject, Document document, Integer n2) {
        this.dataObject = metaDataObject;
        this.document = document;
        this.version = n2;
    }

    public void load(DefaultContext defaultContext) throws Throwable {
        defaultContext = defaultContext.getDBManager();
        MetaTable metaTable = this.dataObject.getMainTable();
        if (metaTable != null) {
            if (!this.populateMain((IDBManager)defaultContext, metaTable)) {
                return;
            }
            for (MetaTable metaTable2 : this.dataObject.getTableCollection()) {
                if (metaTable2 == metaTable || metaTable2.isHidden().booleanValue()) continue;
                this.populateHisData((IDBManager)defaultContext, metaTable2);
            }
            this.document.batchUpdate();
        }
    }

    public boolean populateMain(IDBManager iDBManager, MetaTable metaTable) throws Throwable {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string;
            QuerySQLParameters querySQLParameters = new QuerySQLParameters();
            querySQLParameters.setTableName(metaTable.getHistoryTableName());
            this.prepareQuery(metaTable, querySQLParameters, true);
            Object object2 = querySQLParameters.createSQL(iDBManager, metaTable);
            statement = iDBManager.preparedQueryStatement((String)object2);
            resultSet = iDBManager.executeQuery((PreparedStatement)statement, (String)object2, (QueryArguments)new ListQueryArguments(null, (List)querySQLParameters.getConditionFieldValueList()));
            if (!resultSet.next()) {
                return false;
            }
            object2 = resultSet.getMetaData();
            int n2 = object2.getColumnCount();
            HashMapIgnoreCase hashMapIgnoreCase = new HashMapIgnoreCase();
            for (int i2 = 0; i2 < n2; ++i2) {
                string = object2.getColumnLabel(i2 + 1);
                if (string == null || string.isEmpty()) {
                    throw new MidCoreException(25, MidCoreException.formatMessage(null, (int)25, (Object[])new Object[0]));
                }
                hashMapIgnoreCase.put(string, (Object)object2.getColumnType(i2 + 1));
            }
            DataTable dataTable = this.document.get(metaTable.getKey());
            string = dataTable.getMetaData();
            dataTable.first();
            int n3 = 0;
            for (Object object2 : querySQLParameters.getResultFieldKeyList()) {
                if (object2 == null || ((String)object2).length() <= 0) continue;
                if (hashMapIgnoreCase.containsKey((String)object2)) {
                    object2 = iDBManager.convert(resultSet.getObject((String)object2), string.getColumnInfo(n3).getDataType(), ((Integer)hashMapIgnoreCase.get((String)object2)).intValue());
                    dataTable.setObject(n3, object2);
                }
                ++n3;
            }
            this.document.reSetIDValue();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return true;
    }

    public void populateHisData(IDBManager iDBManager, MetaTable metaTable) throws Throwable {
        Statement statement;
        block13: {
            statement = null;
            ResultSet resultSet = null;
            try {
                Object object;
                QuerySQLParameters querySQLParameters = new QuerySQLParameters();
                querySQLParameters.setTableName(metaTable.getHistoryTableName());
                this.prepareQuery(metaTable, querySQLParameters, false);
                TreeMap<Long, Integer> treeMap = querySQLParameters.createSQL(iDBManager, metaTable) + " order by " + querySQLParameters.getSortStr(iDBManager);
                statement = iDBManager.preparedQueryStatement((String)((Object)treeMap));
                resultSet = iDBManager.executeQuery((PreparedStatement)statement, (String)((Object)treeMap), (QueryArguments)new ListQueryArguments(null, (List)querySQLParameters.getConditionFieldValueList()));
                treeMap = resultSet.getMetaData();
                int n2 = treeMap.getColumnCount();
                HashMapIgnoreCase hashMapIgnoreCase = new HashMapIgnoreCase();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = treeMap.getColumnLabel(i2 + 1);
                    if (object == null || ((String)object).isEmpty()) {
                        throw new MidCoreException(25, MidCoreException.formatMessage(null, (int)25, (Object[])new Object[0]));
                    }
                    hashMapIgnoreCase.put((String)object, (Object)treeMap.getColumnType(i2 + 1));
                }
                DataTable dataTable = this.document.get(metaTable.getKey());
                object = -1L;
                treeMap = new TreeMap<Long, Integer>();
                dataTable.beforeFirst();
                while (dataTable.next()) {
                    treeMap.put(dataTable.getLong("OID"), dataTable.getBookmark());
                }
                while (resultSet.next()) {
                    Long l2 = resultSet.getLong(metaTable.getOIDColumn().getBindingDBColumnName());
                    if (!((Long)object).equals(l2)) {
                        object = (Integer)treeMap.get(l2);
                        if (object == null) {
                            dataTable.append();
                        } else {
                            dataTable.setBookmark(((Integer)object).intValue());
                        }
                        this.populateRowData(iDBManager, (HashMapIgnoreCase<Integer>)hashMapIgnoreCase, resultSet, dataTable, querySQLParameters.getResultFieldKeyList());
                    }
                    object = l2;
                }
                dataTable.beforeFirst();
                while (dataTable.next()) {
                    if (dataTable.getInt("SVERID").compareTo(this.version) < 0) continue;
                    dataTable.delete();
                    dataTable.previous();
                }
                if (resultSet == null) break block13;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
            return;
        }
    }

    private void populateRowData(IDBManager iDBManager, HashMapIgnoreCase<Integer> hashMapIgnoreCase, ResultSet resultSet, DataTable dataTable, ArrayList<String> object) throws SQLException, Throwable {
        DataTableMetaData dataTableMetaData = dataTable.getMetaData();
        int n2 = 0;
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            if (object2 == null || ((String)object2).length() <= 0) continue;
            if (hashMapIgnoreCase.containsKey((String)object2)) {
                object2 = iDBManager.convert(resultSet.getObject((String)object2), dataTableMetaData.getColumnInfo(n2).getDataType(), ((Integer)hashMapIgnoreCase.get((String)object2)).intValue());
                dataTable.setObject(n2, object2);
            }
            ++n2;
        }
    }

    private void prepareQuery(MetaTable metaTable, QuerySQLParameters querySQLParameters, boolean bl) {
        Object object = (MetaColumn)metaTable.get("HVERM");
        object = object == null ? "HVERM" : object.getBindingDBColumnName();
        for (MetaColumn metaColumn : metaTable) {
            if (metaColumn.isHidden().booleanValue() || metaColumn.isIgnoreQuery().booleanValue()) continue;
            if (metaColumn == metaTable.getVERIDColumn()) {
                querySQLParameters.addResultFieldKey((String)object);
                continue;
            }
            String string = metaColumn.getBindingDBColumnName();
            querySQLParameters.addResultFieldKey(string);
            if (metaTable.getSequenceColumn() == metaColumn) continue;
        }
        querySQLParameters.putCondition(0, metaTable.getSOIDColumn().getBindingDBColumnName(), (Object)this.document.getOID());
        if (!bl) {
            querySQLParameters.putSortColumn(metaTable.getOIDColumn().getBindingDBColumnName(), Boolean.TRUE);
            querySQLParameters.putSortColumn((String)object, Boolean.TRUE);
            querySQLParameters.putCondition(1, (String)object, (Object)this.version, ">=");
            return;
        }
        querySQLParameters.putCondition(1, (String)object, (Object)this.version, "=");
    }
}

