/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.document.io;

import com.bokesoft.pub.mid.dict.DictMaintainProxy;
import com.bokesoft.yes.mid.auth.cache.Counter;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.mid.cmd.dict.GetParentPathCmd;
import com.bokesoft.yes.mid.datamap.FeedbackHandler;
import com.bokesoft.yes.mid.document.DocumentProcess;
import com.bokesoft.yes.mid.document.io.ab;
import com.bokesoft.yes.mid.document.io.v;
import com.bokesoft.yes.mid.migration.MigrationProxy;
import com.bokesoft.yes.mid.oid.OIDAllocatorFactory;
import com.bokesoft.yes.mid.saveable.SaveableDocument;
import com.bokesoft.yes.mid.service.MidProcessFlowHandler;
import com.bokesoft.yes.tools.dic.exception.DictException;
import com.bokesoft.yes.tools.dict.i18n.StringTable;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRule;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRuleCollection;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaPostSaveProcess;
import com.bokesoft.yigo.meta.dataobject.MetaPreSaveProcess;
import com.bokesoft.yigo.meta.dataobject.MetaProcess;
import com.bokesoft.yigo.meta.dataobject.MetaStatusTriggerCollection;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.BaseContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.oid.IOIDAllocator;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.parser.IEval;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.SaveFilterMap;
import java.util.List;

public class DocumentDBIOSaveImpl {
    private MetaDataSource metaDataSource = null;
    private MetaDataObject metaDataObject = null;
    private SaveFilterMap saveFilterMap = null;

    public DocumentDBIOSaveImpl(MetaDataSource metaDataSource, MetaDataObject metaDataObject) {
        this.metaDataSource = metaDataSource;
        this.metaDataObject = metaDataObject;
    }

    public DocumentDBIOSaveImpl(MetaDataSource metaDataSource, MetaDataObject metaDataObject, SaveFilterMap saveFilterMap) {
        this(metaDataSource, metaDataObject);
        this.saveFilterMap = saveFilterMap;
    }

    private void doPreProcess(IEval<BaseContext> iEval, Document document, MetaPreSaveProcess object) throws Throwable {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                MetaProcess metaProcess = (MetaProcess)object.next();
                if (document != null) {
                    document.moveFirst();
                }
                iEval.eval(metaProcess.getType().intValue(), metaProcess.getContent(), null, null);
            }
        }
    }

    private void doPostProcess(IEval<BaseContext> iEval, Document document, MetaPostSaveProcess object) throws Throwable {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                MetaProcess metaProcess = (MetaProcess)object.next();
                if (document != null) {
                    document.moveFirst();
                }
                iEval.eval(metaProcess.getType().intValue(), metaProcess.getContent(), null, null);
            }
        }
    }

    public Document save(DefaultContext defaultContext, Document document) throws Throwable {
        v v2;
        v v3 = v2 = new v(this);
        v2.a = new ab(v3.a);
        v3 = defaultContext;
        if (((MidVE)v3.getVE()).isAuthenticate() || Counter.count == 0L || !Counter.passed) {
            v2.a((IServiceContext)v3);
        } else if (Counter.count % 10000L == 0L) {
            v2.a((IServiceContext)v3);
        }
        ++Counter.count;
        if (this.metaDataObject == null) {
            return null;
        }
        v2 = new DocumentProcess(this.metaDataObject, document);
        v3 = OIDAllocatorFactory.getInstance().create(defaultContext);
        v2.process(defaultContext, (IOIDAllocator)v3);
        ContextBuilder.internalCheck((DefaultContext)defaultContext, (Document)document);
        v2 = defaultContext.getMidParser();
        if (this.metaDataSource != null) {
            this.doPreProcess((IEval<BaseContext>)v2, document, this.metaDataSource.getPreSaveProcess());
        }
        this.doPreProcess((IEval<BaseContext>)v2, document, this.metaDataObject.getPreSaveProcess());
        new MidProcessFlowHandler("SaveData", "Pre").doProcess(defaultContext);
        this.doRuleCheck(defaultContext, this.metaDataObject, document);
        document.getDocumentTrack().addTrack(document.isNew() ? 1 : 2, "");
        new SaveableDocument((IServiceContext)defaultContext, this.metaDataObject, this.saveFilterMap, document).save();
        new MigrationProxy(defaultContext, false).doMigration(defaultContext);
        if (this.metaDataObject.getSecondaryType() == 3 || this.metaDataObject.getSecondaryType() == 5) {
            new DictMaintainProxy().checkNeedRebuild(defaultContext, document);
        }
        new FeedbackHandler(this.metaDataObject, document).doProcess(defaultContext);
        boolean bl = this.needDoStatusTrigger(defaultContext, this.metaDataObject, document);
        document.batchUpdate(true);
        this.doPostProcess((IEval<BaseContext>)v2, document, this.metaDataObject.getPostSaveProcess());
        if (this.metaDataSource != null) {
            this.doPostProcess((IEval<BaseContext>)v2, document, this.metaDataSource.getPostSaveProcess());
        }
        new MidProcessFlowHandler("SaveData", "Post").doProcess(defaultContext);
        document.setNormal();
        if (bl) {
            this.doStatusTrigger(defaultContext, this.metaDataObject, document);
        }
        document.clearOriginalData();
        return document;
    }

    private boolean needDoStatusTrigger(DefaultContext defaultContext, MetaDataObject metaDataObject, Document document) throws Throwable {
        defaultContext = document.get(metaDataObject.getMainTableKey());
        if (defaultContext == null) {
            return false;
        }
        if (metaDataObject.getStatusTriggerCollection() == null) {
            return false;
        }
        defaultContext.first();
        int n2 = (Integer)defaultContext.getObject("Status");
        int n3 = (Integer)defaultContext.getOriginalObject("Status");
        return document.isNew() || n3 != n2;
    }

    private void doStatusTrigger(DefaultContext defaultContext, MetaDataObject object, Document object2) throws Throwable {
        object2 = object2.get(object.getMainTableKey());
        MetaStatusTriggerCollection metaStatusTriggerCollection2 = object.getStatusTriggerCollection();
        object = MetaUtil.getStatusCollection((IMetaFactory)defaultContext.getVE().getMetaFactory(), (MetaDataObject)object).getKeyByIntValue(((Integer)object2.getObject("Status")).intValue());
        if (object == null) {
            return;
        }
        for (MetaStatusTriggerCollection metaStatusTriggerCollection2 : metaStatusTriggerCollection2) {
            if (!metaStatusTriggerCollection2.getStatusKey().equals(object)) continue;
            defaultContext.getMidParser().eval(metaStatusTriggerCollection2.getRunType().intValue(), metaStatusTriggerCollection2.getContent());
        }
    }

    private void doRuleCheck(DefaultContext defaultContext, MetaDataObject metaDataObject, Document document) throws Throwable {
        String string;
        if (metaDataObject.getSecondaryType() == 3 || metaDataObject.getSecondaryType() == 5) {
            Object object;
            MetaTable metaTable = metaDataObject.getMainTable();
            string = metaTable.getKey();
            String string2 = (string = document.get(string)).getString(0, "Code");
            if (string2 == null || string2.isEmpty()) {
                throw new DictException(1, SimpleStringFormat.format((String)StringTable.getString((ILocale)defaultContext.getEnv(), (String)"", (String)"CodeIsEmpty"), (Object[])new Object[0]));
            }
            long l2 = document.getOID();
            String string3 = metaTable.getOIDColumn().getBindingDBColumnName();
            String string4 = ((MetaColumn)metaTable.get("Code")).getBindingDBColumnName();
            String string5 = ((MetaColumn)metaTable.get("NodeType")).getBindingDBColumnName();
            String string6 = ((MetaColumn)metaTable.get("ParentID")).getBindingDBColumnName();
            boolean bl = false;
            long l3 = -1L;
            String string7 = null;
            if (metaTable.getCLUSTERIDColumn() != null && (object = TypeConvertor.toLong((Object)string.getObject(0, "ClusterID"))) != null && (Long)object > 0L) {
                bl = true;
                l3 = (Long)object;
                string7 = ((MetaColumn)metaTable.get("ClusterID")).getBindingDBColumnName();
            }
            if (CoreSetting.getInstance().isDictMatchUpper()) {
                if (bl) {
                    string4 = "SELECT COUNT(" + string3 + ") AS COUNT1 FROM " + metaTable.getBindingDBTableName().toUpperCase() + " WHERE " + string4 + " = ? AND " + string3 + " <> ? AND " + string7 + " = ?";
                    object = defaultContext.getDBManager().execPrepareQuery(string4, new Object[]{string2.toUpperCase(), l2, l3});
                } else {
                    string4 = "SELECT COUNT(" + string3 + ") AS COUNT1 FROM " + metaTable.getBindingDBTableName().toUpperCase() + " WHERE " + string4 + " = ? AND " + string3 + " <> ? ";
                    object = defaultContext.getDBManager().execPrepareQuery(string4, new Object[]{string2.toUpperCase(), l2});
                }
            } else if (bl) {
                string4 = "SELECT COUNT(" + string3 + ") AS COUNT1 FROM " + metaTable.getBindingDBTableName().toUpperCase() + " WHERE " + string4 + " = ? AND " + string3 + " <> ? AND " + string7 + " = ?";
                object = defaultContext.getDBManager().execPrepareQuery(string4, new Object[]{string2, l2, l3});
            } else {
                string4 = "SELECT COUNT(" + string3 + ") AS COUNT1 FROM " + metaTable.getBindingDBTableName().toUpperCase() + " WHERE " + string4 + " = ? AND " + string3 + " <> ? ";
                object = defaultContext.getDBManager().execPrepareQuery(string4, new Object[]{string2, l2});
            }
            if (object.first() && TypeConvertor.toInteger((Object)object.getObject("COUNT1")) > 0) {
                throw new DictException(1, SimpleStringFormat.format((String)StringTable.getString((ILocale)defaultContext.getEnv(), (String)"", (String)"CodeDuplication"), (Object[])new Object[]{string2}));
            }
            if (metaDataObject.getSecondaryType() == 3) {
                boolean bl2 = document.isNew();
                long l4 = TypeConvertor.toLong((Object)string.getObject(0, "ParentID"));
                if (l4 > 0L) {
                    if (bl) {
                        string2 = "SELECT " + string3 + " FROM " + metaTable.getBindingDBTableName().toUpperCase() + " WHERE " + string3 + " = ? AND " + string5 + " = ? AND " + string7 + " = ?";
                        object = defaultContext.getDBManager().execPrepareQuery(string2, new Object[]{l4, 1, l3});
                    } else {
                        string2 = "SELECT " + string3 + " FROM " + metaTable.getBindingDBTableName().toUpperCase() + " WHERE " + string3 + " = ? AND " + string5 + " = ?";
                        object = defaultContext.getDBManager().execPrepareQuery(string2, new Object[]{l4, 1});
                    }
                    int n2 = object.size();
                    if (n2 == 0) {
                        throw new DictException(2, SimpleStringFormat.format((String)StringTable.getString((ILocale)defaultContext.getEnv(), (String)"", (String)"ParentIDNotExist"), (Object[])new Object[0]));
                    }
                    if (n2 > 1) {
                        throw new DictException(2, SimpleStringFormat.format((String)StringTable.getString((ILocale)defaultContext.getEnv(), (String)"", (String)"OnlyOneParentID"), (Object[])new Object[0]));
                    }
                    if (!bl2) {
                        if (l2 == l4) {
                            throw new DictException(2, SimpleStringFormat.format((String)StringTable.getString((ILocale)defaultContext.getEnv(), (String)"", (String)"ParentIDEqualsOID"), (Object[])new Object[0]));
                        }
                        Object object2 = new GetParentPathCmd();
                        object = metaDataObject.getKey();
                        ItemData itemData = new ItemData((String)object, l4);
                        ((GetParentPathCmd)((Object)object2)).setItemKey((String)object);
                        ((GetParentPathCmd)((Object)object2)).setItemData(itemData);
                        object2 = ((List)((GetParentPathCmd)((Object)object2)).doCmd(defaultContext)).iterator();
                        while (object2.hasNext()) {
                            object = ((List)object2.next()).iterator();
                            while (object.hasNext()) {
                                if (((ItemData)object.next()).getOID() != l2) continue;
                                throw new DictException(2, SimpleStringFormat.format((String)StringTable.getString((ILocale)defaultContext.getEnv(), (String)"", (String)"ParentIDInChildren"), (Object[])new Object[0]));
                            }
                        }
                    }
                }
                int n3 = (Integer)string.getObject(0, "NodeType");
                if (bl && !bl2) {
                    long l5;
                    object = "SELECT " + string7 + " FROM " + metaTable.getBindingDBTableName() + " WHERE " + string3 + " = ? AND " + string5 + " = ?";
                    object = defaultContext.getDBManager().execPrepareQuery((String)object, new Object[]{l2, 1});
                    if (object.first() && (l5 = TypeConvertor.toLong((Object)object.getObject(string7)).longValue()) != l3) {
                        object = "SELECT " + string3 + " FROM " + metaTable.getBindingDBTableName() + " WHERE " + string6 + " = ? AND " + string3 + " > ? AND " + string7 + " = ?";
                        if (defaultContext.getDBManager().execPrepareQuery((String)object, new Object[]{l2, 0, l5}).size() > 0) {
                            throw new DictException(5, SimpleStringFormat.format((String)StringTable.getString((ILocale)defaultContext.getEnv(), (String)"", (String)"RemoveAllChildren"), (Object[])new Object[0]));
                        }
                    }
                }
                if (n3 == 0 && !bl2) {
                    if (bl) {
                        object = "SELECT " + string3 + " FROM " + metaTable.getBindingDBTableName() + " WHERE " + string6 + " = ? AND " + string3 + " > ? AND " + string7 + " = ?";
                        object = defaultContext.getDBManager().execPrepareQuery((String)object, new Object[]{l2, 0, l3});
                    } else {
                        object = "SELECT " + string3 + " FROM " + metaTable.getBindingDBTableName() + " WHERE " + string6 + " = ? AND " + string3 + " > ?";
                        object = defaultContext.getDBManager().execPrepareQuery((String)object, new Object[]{l2, 0});
                    }
                    if (object.size() > 0) {
                        throw new DictException(4, SimpleStringFormat.format((String)StringTable.getString((ILocale)defaultContext.getEnv(), (String)"", (String)"RemoveAllChildren"), (Object[])new Object[0]));
                    }
                }
            }
        }
        if ((string = MetaUtil.getMetaCheckRuleCollection((IMetaFactory)defaultContext.getVE().getMetaFactory(), (MetaDataObject)this.metaDataObject)) != null) {
            this.doRuleCheck(defaultContext, (MetaCheckRuleCollection)string, document);
        }
        if ((string = metaDataObject.getCheckRuleCollection()) != null) {
            this.doRuleCheck(defaultContext, (MetaCheckRuleCollection)string, document);
        }
    }

    private void doRuleCheck(DefaultContext defaultContext, MetaCheckRuleCollection object, Document document) throws Throwable {
        IEval iEval = defaultContext.getMidParser();
        object = object.iterator();
        while (object.hasNext()) {
            MetaCheckRule metaCheckRule = (MetaCheckRule)object.next();
            if (document != null) {
                document.moveFirst();
            }
            if (metaCheckRule.getScope() != 0 || TypeConvertor.toBoolean((Object)iEval.eval(metaCheckRule.getType().intValue(), metaCheckRule.getContent(), (IEvalContext)defaultContext, null)).booleanValue()) continue;
            throw new MidCoreException(3, metaCheckRule.getErrorInfo());
        }
    }
}

