/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dict.proxy;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.dict.proxy.a;
import com.bokesoft.yes.mid.dict.proxy.b;
import com.bokesoft.yes.mid.dict.proxy.c;
import com.bokesoft.yes.mid.dict.proxy.d;
import com.bokesoft.yes.mid.dict.proxy.e;
import com.bokesoft.yes.mid.dict.proxy.f;
import com.bokesoft.yes.tools.dic.DictTools;
import com.bokesoft.yes.tools.dic.item.ICache;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yes.tools.dic.proxy.ItemCacheManager;
import com.bokesoft.yes.tools.dic.proxy.ItemSortComparator;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.dict.IItemFilter;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MidDictCacheProxy
implements IDictCacheProxy {
    private ItemCacheManager itemCaches = null;
    private DefaultContext context = null;
    private HashMap<String, Item> localCache = null;

    public MidDictCacheProxy(DefaultContext defaultContext) {
        this.context = defaultContext;
        this.itemCaches = new ItemCacheManager((VE)this.context.getVE());
        this.localCache = new HashMap();
    }

    public Item getItem(String string, long l2) throws Throwable {
        return this.getItem(string, l2, 7);
    }

    public Item getItem(String string, long l2, int n2) throws Throwable {
        if (!this.hasRights(string, l2)) {
            return null;
        }
        ICache iCache = this.itemCaches.getItemCache(string);
        Item item = this.getCachedItem(iCache, string, l2);
        if (item == null) {
            item = this.loadItems(iCache, string, l2);
        }
        if (item != null) {
            if (DictTools.checkStateMask((int)n2, (int)item.getEnable())) {
                return DictTools.toI18nData((VE)this.context.getVE(), (Item)item);
            }
        } else {
            LogSvr.getInstance().warn("ItemKey:" + string + "    oid:" + l2 + " not find.");
        }
        return null;
    }

    private String getKey(String string, long l2) {
        return string + "_" + l2;
    }

    private boolean existCachedItem(ICache iCache, String string, long l2) throws Throwable {
        string = this.getKey(string, l2);
        try {
            if (this.localCache.containsKey(string)) {
                return true;
            }
        }
        catch (Throwable throwable) {}
        return iCache.existItem(l2);
    }

    private Item getCachedItem(ICache iCache, String string, long l2) throws Throwable {
        string = this.getKey(string, l2);
        try {
            if (this.localCache.containsKey(string)) {
                return this.localCache.get(string);
            }
        }
        catch (Throwable throwable) {}
        iCache = iCache.getItemByID(l2);
        iCache = DictTools.toI18nData((VE)this.context.getVE(), (Item)iCache);
        try {
            this.localCache.put(string, (Item)iCache);
        }
        catch (Throwable throwable) {}
        return iCache;
    }

    private List<Item> getCachedItems(ICache iCache, String string, List<Long> object) throws Throwable {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        object = object.iterator();
        while (object.hasNext()) {
            long l2 = (Long)object.next();
            Item item = this.getCachedItem(iCache, string, l2);
            if (item == null) continue;
            arrayList.add(item);
        }
        return arrayList;
    }

    private void addCachedItems(List<Item> object) throws Throwable {
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Item item = (Item)object.next();
                String string = item.toString();
                this.localCache.put(string, item);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private void removeCachedItem(String string, long l2) {
        try {
            string = this.getKey(string, l2);
            this.localCache.remove(string);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private void clearLocalCache() {
        try {
            this.localCache.clear();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public List<Item> getItems(String string, List<Long> object) throws Throwable {
        ICache iCache = this.itemCaches.getItemCache(string);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        new ArrayList();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        object = object.iterator();
        while (object.hasNext()) {
            long l2 = (Long)object.next();
            if (!this.hasRights(string, l2)) continue;
            if (!this.existCachedItem(iCache, string, l2)) {
                arrayList.add(l2);
            }
            arrayList2.add(l2);
        }
        if (arrayList.size() > 0) {
            this.loadItems(iCache, string, arrayList);
        }
        return this.getCachedItems(iCache, string, arrayList2);
    }

    public String getShowCaption(String string, long l2) throws Throwable {
        if (l2 == 0L) {
            return "";
        }
        string = this.getItem(string, l2, 7);
        String string2 = "";
        if (string != null) {
            string2 = string.getCaption();
        }
        return string2;
    }

    public boolean existItem(String string, long l2) throws Throwable {
        if (l2 == 0L) {
            return true;
        }
        if (!this.hasRights(string, l2)) {
            return false;
        }
        return this.getItem(string, l2, 7) != null;
    }

    public void refreshItem(String string, long l2) throws Throwable {
        ICache iCache = this.itemCaches.getItemCache(string);
        iCache.reomveItem(l2);
        this.loadItems(iCache, string, l2);
    }

    public void refreshItems(String string, List<Long> list) throws Throwable {
        if (list != null && list.size() > 0) {
            ICache iCache = this.itemCaches.getItemCache(string);
            for (long l2 : list) {
                iCache.reomveItem(l2);
            }
            this.loadItems(iCache, string, list);
        }
    }

    public void removeItem(String string, long l2) throws Throwable {
        this.itemCaches.getItemCache(string).reomveItem(l2);
        this.removeCachedItem(string, l2);
    }

    public List<ItemData> lookup(String string, String string2, String string3, IItemFilter iItemFilter, ItemData itemData, int n2, int n3, int n4) throws Throwable {
        return this.lookup(string, string2, string3, iItemFilter, itemData, n2, n3, 0, 0, n4, null, null);
    }

    public List<ItemData> lookup(String string, String string2, String string3, IItemFilter iItemFilter, ItemData itemData, int n2, int n3, int n4, int n5, int n6, String string4, String string5) throws Throwable {
        try {
            return (List)new a(this, string4, string5, string, string2, string3, iItemFilter, itemData, n2, n3, n4, n5, n6).call(this.context);
        }
        catch (Throwable throwable) {
            this.removeDictCache(string);
            throw throwable;
        }
    }

    public int getLookupCount(String string, String string2, String string3, IItemFilter iItemFilter, ItemData itemData, int n2, int n3, String string4, String string5, int n4) throws Throwable {
        try {
            return TypeConvertor.toInteger((Object)((Long)new b(this, string4, string5, string, string2, string3, iItemFilter, itemData, n2, n3, n4).call(this.context)));
        }
        catch (Throwable throwable) {
            this.removeDictCache(string);
            throw throwable;
        }
    }

    public Item locate(String string, String string2, Object object, IItemFilter iItemFilter, ItemData itemData, int n2, int n3) throws Throwable {
        return this.locate(string, string2, object, iItemFilter, itemData, n2, null, null, n3);
    }

    public Item locate(String string, String string2, Object object, IItemFilter iItemFilter, ItemData itemData, int n2, String string3, String string4, int n3) throws Throwable {
        try {
            string2 = (ItemData)new c(this, string3, string4, string, string2, object, iItemFilter, itemData, n2, n3).call(this.context);
        }
        catch (Throwable throwable) {
            this.removeDictCache(string);
            throw throwable;
        }
        if (string2 == null) {
            return null;
        }
        return this.getItem(string2.getItemKey(), string2.getOID());
    }

    public Item locate2(String string, String string2, String string3, IItemFilter iItemFilter, ItemData itemData, int n2, String string4, String string5, int n3) throws Throwable {
        try {
            string2 = (ItemData)new d(this, string4, string5, string, string2, string3, iItemFilter, itemData, n2, n3).call(this.context);
        }
        catch (Throwable throwable) {
            this.removeDictCache(string);
            throw throwable;
        }
        if (string2 == null) {
            return null;
        }
        return this.getItem(string2.getItemKey(), string2.getOID());
    }

    private boolean hasRights(String string, long l2) throws Throwable {
        return true;
    }

    public List<Item> preLoadDictCache(MetaForm object, Document document) throws Throwable {
        Object object2;
        object = this.getDictFields((MetaForm)object);
        int n2 = 0;
        MetaDictProperties metaDictProperties = null;
        String string2 = null;
        List<Item> list = null;
        HashMap<String, List<Long>> hashMap = new HashMap<String, List<Long>>();
        Object object3 = object.iterator();
        while (object3.hasNext()) {
            object2 = (AbstractMetaObject)object3.next();
            if (object2 instanceof MetaListViewColumn) {
                n2 = ((MetaListViewColumn)object2).getColumnType();
                metaDictProperties = (MetaDictProperties)((MetaListViewColumn)object2).getProperties();
                list = ((MetaListViewColumn)object2).getDataColumnKey();
                string2 = ((MetaListViewColumn)object2).getTableKey();
            } else if (object2 instanceof MetaEditViewColumn) {
                n2 = ((MetaEditViewColumn)object2).getColumnType();
                metaDictProperties = (MetaDictProperties)((MetaEditViewColumn)object2).getProperties();
                list = ((MetaEditViewColumn)object2).getDataColumnKey();
                string2 = ((MetaEditViewColumn)object2).getTableKey();
            } else if (object2 instanceof MetaComponent) {
                object = ((MetaComponent)object2).getDataBinding();
                n2 = ((MetaComponent)object2).getControlType();
                metaDictProperties = (MetaDictProperties)((MetaComponent)object2).getProperties();
                list = object.getColumnKey();
                string2 = object.getTableKey();
            } else if (object2 instanceof MetaGridCell) {
                object = ((MetaGridCell)object2).getDataBinding();
                n2 = ((MetaGridCell)object2).getCellType();
                metaDictProperties = (MetaDictProperties)((MetaGridCell)object2).getProperties();
                list = object.getColumnKey();
                string2 = ((MetaGridCell)object2).getTableKey();
            }
            this.getDictData(document, hashMap, n2, metaDictProperties, string2, (String)((Object)list));
        }
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (String string2 : hashMap.keySet()) {
            object2 = new ArrayList();
            object3 = (List)hashMap.get(string2);
            object = this.itemCaches.getItemCache(string2);
            list = object3.iterator();
            while (list.hasNext()) {
                long l2 = (Long)list.next();
                document = this.getCachedItem((ICache)object, string2, l2);
                if (document == null) {
                    object2.add(l2);
                    continue;
                }
                arrayList.add((Item)document);
            }
            if (object2.size() <= 0) continue;
            list = this.loadItems((ICache)object, string2, (List<Long>)object2);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<AbstractMetaObject> getDictFields(MetaForm metaForm) {
        ArrayList<AbstractMetaObject> arrayList = new ArrayList<AbstractMetaObject>();
        for (MetaComponent metaComponent2 : metaForm.getAllComponents()) {
            int n2 = metaComponent2.getControlType();
            if (n2 == 206 || n2 == 242 || n2 == 241) {
                MetaDataBinding metaDataBinding = metaComponent2.getDataBinding();
                if (metaDataBinding == null || metaDataBinding.getColumnKey() == null || metaDataBinding.getColumnKey().isEmpty()) continue;
                arrayList.add((AbstractMetaObject)metaComponent2);
                continue;
            }
            if (n2 == 216) {
                for (MetaComponent metaComponent2 : ((MetaListView)metaComponent2).getColumnCollection()) {
                    if (metaComponent2.getColumnType() != 206 || metaComponent2.getDataColumnKey() == null || metaComponent2.getDataColumnKey().isEmpty()) continue;
                    arrayList.add((AbstractMetaObject)metaComponent2);
                }
                continue;
            }
            if (n2 != 305) continue;
            for (MetaComponent metaComponent2 : ((MetaEditView)metaComponent2).getColumnCollection()) {
                if (metaComponent2.getColumnType() != 206 || metaComponent2.getDataColumnKey() == null || metaComponent2.getDataColumnKey().isEmpty()) continue;
                arrayList.add((AbstractMetaObject)metaComponent2);
            }
        }
        for (MetaGridCell metaGridCell : metaForm.getAllGridCells()) {
            MetaDataBinding metaDataBinding;
            int n3 = metaGridCell.getCellType();
            if (n3 != 206 && n3 != 242 && n3 != 241 || (metaDataBinding = metaGridCell.getDataBinding()) == null || metaDataBinding.getColumnKey() == null || metaDataBinding.getColumnKey().isEmpty()) continue;
            arrayList.add((AbstractMetaObject)metaGridCell);
        }
        return arrayList;
    }

    private void getDictData(Document document, Map<String, List<Long>> map, int n2, MetaDictProperties metaDictProperties, String string, String string2) {
        if ((document = document.get(string)) == null) {
            return;
        }
        int n3 = document.getMetaData().findColumnIndexByKey(string2);
        if (n3 == -1) {
            return;
        }
        String string3 = null;
        if (document.first()) {
            while (!document.isAfterLast()) {
                Long[] longArray = document.getObject(n3);
                if (longArray == null) {
                    document.next();
                    continue;
                }
                switch (n2) {
                    case 206: {
                        string3 = metaDictProperties.getItemKey();
                        break;
                    }
                    case 241: 
                    case 242: {
                        int n4 = document.getMetaData().findColumnIndexByKey(string2 + "ItemKey");
                        string3 = n4 != -1 ? document.getString(n4) : "";
                    }
                }
                if (string3 != null && !string3.isEmpty()) {
                    if (metaDictProperties.isAllowMultiSelection().booleanValue()) {
                        Long[] longArray2;
                        Object object = TypeConvertor.toString((Object)longArray);
                        if (((String)object).length() > 0 && (longArray2 = TypeConvertor.toLongArray((Object)((String)object).split(","))).length > 0) {
                            longArray = longArray2;
                            int n5 = longArray2.length;
                            for (int i2 = 0; i2 < n5; ++i2) {
                                object = longArray[i2];
                                this.addDictItems(map, string3, (Long)object);
                            }
                        }
                    } else {
                        long l2 = TypeConvertor.toLong((Object)longArray);
                        this.addDictItems(map, string3, l2);
                    }
                }
                document.next();
            }
        }
    }

    private void addDictItems(Map<String, List<Long>> object, String string, Long l2) {
        if (string != null && !string.isEmpty() && l2 > 0L) {
            if (!object.containsKey(string)) {
                object.put((String)string, new ArrayList());
            }
            if (!(object = object.get(string)).contains(l2)) {
                object.add(l2);
            }
        }
    }

    public void removeDictCache(String string) {
        try {
            this.itemCaches.getItemCache(string).clear();
            this.clearLocalCache();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public List<Item> getAllItems(String string, IItemFilter iItemFilter, int n2, int n3) throws Throwable {
        try {
            return (List)new e(this, string, iItemFilter, n2, n3).call(this.context);
        }
        catch (Throwable throwable) {
            this.removeDictCache(string);
            throw throwable;
        }
    }

    private Item loadItems(ICache object, String string, long l2) throws Throwable {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(l2);
        object = this.loadItems((ICache)object, string, arrayList);
        if (object != null && object.size() > 0) {
            return (Item)object.get(0);
        }
        return null;
    }

    private List<Item> loadItems(ICache object, String string, List<Long> list) throws Throwable {
        try {
            list = (List)new f(this, string, list).call(this.context);
            if (list != null && !list.isEmpty()) {
                object.addItems(list);
            }
            object = DictTools.toI18nDatas((VE)this.context.getVE(), (List)list);
            this.addCachedItems((List<Item>)object);
            return object;
        }
        catch (Throwable throwable) {
            this.removeDictCache(string);
            throw throwable;
        }
    }

    public void sortDictItem(String string, List<Item> list) {
        try {
            if (list != null && list.size() > 0) {
                string = this.itemCaches.getItemCache(string);
                Collections.sort(list, new ItemSortComparator((ICache)string));
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public long updateCache(String string, long l2) throws Throwable {
        ICache iCache = this.itemCaches.getItemCache(string);
        this.removeCachedItem(string, l2);
        return iCache.update(Long.valueOf(l2));
    }

    public void clear() {
        this.itemCaches.clear();
        this.clearLocalCache();
    }
}

