/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HighGoDBManager
extends GeneralDBManager {
    private static final String[] keyWord = new String[]{"ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AT", "BEGIN", "BETWEEN", "BY", "CASE", "CHECK", "CLUSTERS", "CLUSTER", "COLAUTH", "COLUMNS", "COMPRESS", "CONNECT", "CRASH", "CREATE", "CURSOR", "DATE", "DECLARE", "DEFAULT", "DESC", "DISTINCT", "DROP", "ELSE", "END", "EXCEPTION", "EXCLUSIVE", "FETCH", "FOR", "FOREIGN", "FROM", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IF", "IN", "INDEX", "INDEXES", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "LIKE", "LOCK", "LEVEL", "MINUS", "MODE", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "OF", "ON", "OPTION", "OR", "ORDER", "OVERLAPS", "PROCEDURE", "PUBLIC", "RESOURCE", "REVOKE", "SELECT", "SHARE", "SIZE", "SQL", "START", "SUBTYPE", "TABAUTH", "TABLE", "THEN", "TO", "TYPE", "UNION", "UNIQUE", "UPDATE", "VALUES", "VIEW", "VIEWS", "WHEN", "WHERE", "WITH", "LONG", "NUMBER", "INTEGER"};
    private Set<String> keySet = null;

    public HighGoDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
    }

    @Override
    public String getAlterTableStr(MetaSchemaTable object, List<MetaSchemaColumn> object2) throws Throwable {
        MetaSchemaColumn metaSchemaColumn;
        object2 = object2.iterator();
        object = "alter table " + this.keyWordEscape(object.getKey()) + " add (";
        if (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        while (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + "," + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        return (String)object + ")";
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        String string;
        switch (metaSchemaColumn.getDataType()) {
            case 1001: {
                string = " int ";
                break;
            }
            case 1002: {
                string = " varchar(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1003: {
                string = " date ";
                break;
            }
            case 1004: {
                string = " timestamp ";
                break;
            }
            case 1005: {
                string = " numeric(" + metaSchemaColumn.getPrecision() + "," + metaSchemaColumn.getScale() + ") ";
                break;
            }
            case 1006: {
                string = " float8 ";
                break;
            }
            case 1007: {
                string = " float4 ";
                break;
            }
            case 1008: {
                string = " bytea ";
                break;
            }
            case 1009: {
                string = " int ";
                break;
            }
            case 1010: {
                string = " bigint ";
                break;
            }
            case 1011: {
                string = " text ";
                break;
            }
            case 1012: {
                string = " char(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1101: {
                string = " timestamp ";
                break;
            }
            default: {
                throw new MidCoreException(6, "\u6570\u636e\u7c7b\u578b" + DataType.toString((Integer)metaSchemaColumn.getDataType()) + "\u5728HighGoDBManager\u672a\u5b9a\u4e49\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5217\u7c7b\u578b\uff01");
            }
        }
        return this.keyWordEscape(metaSchemaColumn.getKey()) + string;
    }

    public String keyWordEscape(String string) {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>();
            for (int i2 = 0; i2 < keyWord.length; ++i2) {
                this.keySet.add(keyWord[i2].toLowerCase());
            }
        }
        if (this.keySet.contains(string.toLowerCase())) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String string) {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>();
            for (int i2 = 0; i2 < keyWord.length; ++i2) {
                this.keySet.add(keyWord[i2].toUpperCase());
            }
        }
        if (this.keySet.contains(string.toUpperCase())) {
            return stringBuilder.append("\"").append(string).append("\"");
        }
        return stringBuilder.append(string);
    }

    public int getDBType() {
        return 11;
    }

    public String getConditionValue(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string = string.replaceAll("\\D+", "");
            stringBuilder.append(string);
            if (stringBuilder.length() == 8) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.insert(stringBuilder2.length(), "'").insert(6, "-").insert(4, "-").insert(0, "'");
            } else {
                StringBuilder stringBuilder3 = stringBuilder;
                stringBuilder3.insert(stringBuilder3.length(), "'").insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-").insert(0, "'");
            }
            return stringBuilder.toString();
        }
        stringBuilder.append(string);
        StringBuilder stringBuilder4 = stringBuilder;
        stringBuilder4.insert(stringBuilder4.length(), "'").insert(0, "'");
        return stringBuilder.toString();
    }

    public String getLikeConditionValue(String string, int n2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string2 = string2.replaceAll("\\D+", "");
            stringBuilder.append(string2);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = "to_char(" + string + ", 'yyyy-mm-dd') like '%" + string2 + "%'";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = "to_char(" + string + ", 'yyyy-mm-dd hh24:mi:ss') like '%" + string2 + "%'";
            }
            return string2;
        }
        return string + " like " + string2;
    }

    public PrepareSQL getLimitString(String string, String string2, boolean bl, int n2, int n3) {
        boolean bl2 = string2 != null && string2.length() != 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(" order by ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(bl ? " limit ? offset ?" : " limit ?");
        string = new PrepareSQL();
        string.setSQL(stringBuilder.toString());
        if (bl) {
            string.addValue((Object)(n3 - n2));
            string.addValue((Object)n2);
        } else {
            string.addValue((Object)n3);
        }
        return string;
    }

    @Override
    public Object convert(Object object, int n2, int n3) throws Throwable {
        if (n3 == -5 && n2 == 1005) {
            return new BigDecimal((Long)object);
        }
        return super.convert(object, n2, n3);
    }

    @Override
    public String getTableExistCheckSql() {
        return "select count(TABLE_NAME) count from information_schema.TABLES WHERE UPPER(TABLE_NAME) = ?  and TABLE_SCHEMA = 'public'";
    }

    @Override
    public String getIndexSearchSql() {
        return "select relname as table_name from pg_stat_user_indexes where UPPER(indexrelname) =?";
    }

    @Override
    public String getIndexCheckSql() {
        return "select indexrelname as index_name from pg_stat_user_indexes where UPPER(relname) =?";
    }

    @Override
    public String getColumnCheckSql() {
        return "select COLUMN_NAME from information_schema.COLUMNS where UPPER(TABLE_NAME)=? and TABLE_SCHEMA = 'public'";
    }

    @Override
    public String getTableStructSql() {
        return "select TABLE_NAME from information_schema.TABLES WHERE TABLE_SCHEMA = 'public'";
    }

    @Override
    public String getColumnStructSql() {
        return "select COLUMN_NAME,TABLE_NAME from information_schema.COLUMNS where TABLE_SCHEMA = 'public'";
    }

    @Override
    public String getIndexStructSql() {
        return "select indexrelname as index_name, relname as table_name, '' as COLUMN_NAME, -1 as NON_UNIQUE, 0 as SEQ_IN_INDEX from pg_stat_user_indexes";
    }

    @Override
    public String getViewExistCheckSql() {
        return null;
    }

    @Override
    public String getViewStructSql() {
        return null;
    }
}

