/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.connection.DBManagerFactory;
import com.bokesoft.yes.mid.connection.IQueryColumnMetaData;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.ListQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.NormalQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.util.DocumentDBUtil;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.TypesStr;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.ve.VE;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;

public abstract class GeneralDBManager
implements IDBManager {
    protected VE ve = null;
    protected String key = null;
    protected Connection connection = null;
    protected IConnectionProfile profile = null;
    public static final String STR_SYS_Lock_TableName = "SYS_Lock";
    public static final String STR_SYS_Lock_GlobalKey = "SYS_Lock_GlobalKey";

    public GeneralDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        this.profile = iConnectionProfile;
        this.connection = connection;
    }

    public VE getVE() {
        return this.ve;
    }

    public void setVE(VE vE) {
        this.ve = vE;
    }

    public boolean checkViewExist(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getViewExistCheckSql();
            preparedStatement = this.prepareStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.next();
            boolean bl = resultSet.getInt(1) == 1;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public boolean checkTableExist(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getTableExistCheckSql();
            preparedStatement = this.prepareStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.next();
            boolean bl = resultSet.getInt(1) == 1;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public abstract String getViewExistCheckSql();

    public abstract String getTableExistCheckSql();

    public String searchIndex(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getIndexSearchSql();
            preparedStatement = this.prepareStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            if (resultSet.next()) {
                string = resultSet.getString(1);
                return string;
            }
            return null;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public abstract String getIndexSearchSql();

    public HashSet<String> getTableColumnSet(String string) throws Throwable {
        String string2 = this.getColumnCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.prepareStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1).toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    public abstract String getIndexCheckSql();

    public HashSet<String> getIndexSet(String string) throws Throwable {
        String string2 = this.getIndexCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.prepareStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                string = resultSet.getString(1);
                if (string == null || string.length() <= 0) continue;
                hashSet.add(string.toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    public abstract String getColumnCheckSql();

    public String getAlterTableStr(MetaSchemaTable object, List<MetaSchemaColumn> object2) throws Throwable {
        object2 = object2.iterator();
        object = "alter table " + this.keyWordEscape(object.getKey()) + " add ";
        if (object2.hasNext()) {
            object = (String)object + this.getColumnDef((MetaSchemaColumn)object2.next());
        }
        while (object2.hasNext()) {
            object = (String)object + "," + this.getColumnDef((MetaSchemaColumn)object2.next());
        }
        return object;
    }

    public Object convert(Object object, int n2, int n3) throws Throwable {
        if (object != null) {
            switch (n2) {
                case 1008: {
                    switch (n3) {
                        case -4: 
                        case -3: 
                        case -2: {
                            return (byte[])object;
                        }
                        case 2004: 
                        case 2011: {
                            object = (Blob)object;
                            return object.getBytes(1L, (int)object.length());
                        }
                        case 2005: {
                            object = (Clob)object;
                            return object.getSubString(1L, (int)object.length()).getBytes();
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + object + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)n3) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)n2));
                }
                case 1009: {
                    switch (n3) {
                        case 4: {
                            return (Integer)object == 1;
                        }
                        case 2: {
                            return ((BigDecimal)object).intValue() == 1;
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + object + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)n3) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)n2));
                }
                case 1003: 
                case 1004: 
                case 1101: {
                    switch (n3) {
                        case 91: 
                        case 92: 
                        case 93: 
                        case 2013: 
                        case 2014: {
                            return TypeConvertor.toDate((Object)object);
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + object + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)n3) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)n2));
                }
                case 1005: 
                case 1006: 
                case 1007: {
                    switch (n3) {
                        case 2: 
                        case 3: {
                            return (BigDecimal)object;
                        }
                        case 8: {
                            return new BigDecimal((Double)object);
                        }
                        case 6: {
                            return new BigDecimal(((Float)object).floatValue());
                        }
                        case 4: {
                            return new BigDecimal((Integer)object);
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + object + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)n3) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)n2));
                }
                case 1001: {
                    switch (n3) {
                        case 4: {
                            return (Integer)object;
                        }
                        case -5: {
                            return ((Long)object).intValue();
                        }
                        case 2: {
                            return ((BigDecimal)object).intValue();
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + object + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)n3) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)n2));
                }
                case 1010: {
                    switch (n3) {
                        case 4: {
                            return ((Integer)object).longValue();
                        }
                        case -5: {
                            return (Long)object;
                        }
                        case 2: 
                        case 3: {
                            return ((BigDecimal)object).longValue();
                        }
                        case -9: 
                        case 12: {
                            return Long.parseLong((String)object);
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + object + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)n3) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)n2));
                }
                case 1002: 
                case 1012: {
                    if ("  ".equals(object)) {
                        return "";
                    }
                    return object.toString();
                }
                case 1011: {
                    switch (n3) {
                        case 2005: {
                            object = (Clob)object;
                            return this.ClobtoString((Clob)object);
                        }
                        case 2004: 
                        case 2011: {
                            object = (Blob)object;
                            return new String(object.getBytes(1L, (int)object.length()));
                        }
                        case -16: 
                        case -9: 
                        case -1: 
                        case 12: {
                            if ("  ".equals(object)) {
                                return "";
                            }
                            return (String)object;
                        }
                        case -4: {
                            return new String((byte[])object, "UTF-8");
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + object + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)n3) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)n2));
                }
            }
            throw new MidCoreException(7, " \u4e0d\u652f\u6301\u7684JDBC\u6570\u636e\u7c7b\u578b");
        }
        return null;
    }

    private String ClobtoString(Clob object) throws Throwable {
        if (object == null) {
            return null;
        }
        try {
            Reader reader = object.getCharacterStream();
            object = new char[(int)object.length()];
            reader.read((char[])object);
            reader.close();
            return new String((char[])object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public int convertDataType(int n2) {
        switch (n2) {
            case -5: {
                return 1010;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 1008;
            }
            case 0: 
            case 2005: 
            case 2011: {
                return 1011;
            }
            case -15: 
            case 1: {
                return 1012;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return 1002;
            }
            case 91: {
                return 1003;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return 1004;
            }
            case 2: 
            case 3: {
                return 1005;
            }
            case 8: {
                return 1006;
            }
            case 6: {
                return 1007;
            }
            case -6: 
            case 4: 
            case 5: {
                return 1001;
            }
        }
        return -1;
    }

    private void fillPrepareParameters(PreparedStatement preparedStatement, QueryArguments queryArguments) throws Throwable {
        if (queryArguments == null) {
            return;
        }
        if (queryArguments.supportType()) {
            int n2 = queryArguments.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = queryArguments.getType(i2);
                Object object = queryArguments.get(i2);
                this.setParameter(preparedStatement, i2 + 1, object, n3);
            }
            return;
        }
        int n4 = queryArguments.size();
        for (int i3 = 0; i3 < n4; ++i3) {
            Object object = queryArguments.get(i3);
            if (!(object instanceof Timestamp) && !(object instanceof Date) && object instanceof java.util.Date) {
                object = new Timestamp(((java.util.Date)object).getTime());
            }
            preparedStatement.setObject(i3 + 1, object);
        }
    }

    private DataTable execPrepareQuery(String string, QueryArguments queryArguments, IQueryColumnMetaData iQueryColumnMetaData) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.prepareStatement(string);
            resultSet = this.executeQuery(preparedStatement, string, queryArguments);
            iQueryColumnMetaData = iQueryColumnMetaData != null ? DocumentDBUtil.populate((IDBManager)this, (ResultSet)resultSet, (IQueryColumnMetaData)iQueryColumnMetaData) : DocumentDBUtil.populate((IDBManager)this, (ResultSet)resultSet);
        }
        catch (Throwable throwable) {
            this.sqlErrorLog(string, queryArguments, throwable);
            throw throwable;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return iQueryColumnMetaData;
    }

    public DataTable execPrepareQuery(String string, Object ... objectArray) throws Throwable {
        return this.execPrepareQuery(string, (QueryArguments)new NormalQueryArguments(objectArray), null);
    }

    public DataTable execPrepareQuery(String string, IQueryColumnMetaData iQueryColumnMetaData, Object ... objectArray) throws Throwable {
        return this.execPrepareQuery(string, (QueryArguments)new NormalQueryArguments(objectArray), iQueryColumnMetaData);
    }

    public DataTable execPrepareQuery(String string, List<Object> list) throws Throwable {
        return this.execPrepareQuery(string, (QueryArguments)new ListQueryArguments(null, list), null);
    }

    public DataTable execPrepareQuery(String string, IQueryColumnMetaData iQueryColumnMetaData, List<Object> list) throws Throwable {
        return this.execPrepareQuery(string, (QueryArguments)new ListQueryArguments(null, list), iQueryColumnMetaData);
    }

    public DataTable execPrepareQuery(String string, List<Integer> list, List<Object> list2) throws Throwable {
        return this.execPrepareQuery(string, (QueryArguments)new ListQueryArguments(list, list2), null);
    }

    public DataTable execPrepareQuery(String string, IQueryColumnMetaData iQueryColumnMetaData, List<Integer> list, List<Object> list2) throws Throwable {
        return this.execPrepareQuery(string, (QueryArguments)new ListQueryArguments(list, list2), iQueryColumnMetaData);
    }

    public DataTable execQuery(String string) throws Throwable {
        return this.execQuery(string, null);
    }

    public DataTable execQuery(String string, IQueryColumnMetaData iQueryColumnMetaData) throws Throwable {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            this.sqlLog(string, null);
            statement = this.createStatement();
            resultSet = statement.executeQuery(string);
            iQueryColumnMetaData = iQueryColumnMetaData != null ? DocumentDBUtil.populate((IDBManager)this, (ResultSet)resultSet, (IQueryColumnMetaData)iQueryColumnMetaData) : DocumentDBUtil.populate((IDBManager)this, (ResultSet)resultSet);
        }
        catch (Throwable throwable) {
            this.sqlErrorLog(string, null, throwable);
            throw throwable;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return iQueryColumnMetaData;
    }

    private int execPrepareUpdate(String string, QueryArguments queryArguments) throws Throwable {
        int n2;
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = this.prepareStatement(string);
            n2 = this.executeUpdate(preparedStatement, string, queryArguments);
        }
        return n2;
    }

    public int execPrepareUpdate(String string, Object ... objectArray) throws Throwable {
        return this.execPrepareUpdate(string, (QueryArguments)new NormalQueryArguments(objectArray));
    }

    public int execPrepareUpdate(String string, List<Object> list) throws Throwable {
        return this.execPrepareUpdate(string, (QueryArguments)new ListQueryArguments(null, list));
    }

    public int execPrepareUpdate(String string, List<Integer> list, List<Object> list2) throws Throwable {
        return this.execPrepareUpdate(string, (QueryArguments)new ListQueryArguments(list, list2));
    }

    public int execUpdate(String string) throws Throwable {
        try (Statement statement = null;){
            statement = this.createStatement();
            this.sqlLog(string, null);
            int n2 = statement.executeUpdate(string);
            return n2;
        }
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void close() throws SQLException {
        if (this.connection == null) {
            return;
        }
        if (!this.connection.isClosed()) {
            this.connection.rollback();
            this.connection.close();
        }
    }

    public void setParameter(PreparedStatement preparedStatement, int n2, Object object, int n3) throws SQLException, MidCoreException {
        switch (n3) {
            case 1001: {
                if (object == null) {
                    preparedStatement.setNull(n2, 4);
                    return;
                }
                preparedStatement.setInt(n2, (Integer)object);
                return;
            }
            case 1002: 
            case 1011: 
            case 1012: {
                preparedStatement.setString(n2, object == null ? null : object.toString());
                return;
            }
            case 1005: {
                preparedStatement.setBigDecimal(n2, object == null ? null : (BigDecimal)object);
                return;
            }
            case 1008: {
                preparedStatement.setBytes(n2, object == null ? null : (byte[])object);
                return;
            }
            case 1010: {
                if (object == null) {
                    preparedStatement.setNull(n2, -5);
                    return;
                }
                preparedStatement.setLong(n2, (Long)object);
                return;
            }
            case 1004: {
                if (object == null) {
                    preparedStatement.setNull(n2, 93);
                    return;
                }
                preparedStatement.setTimestamp(n2, new Timestamp(((java.util.Date)object).getTime()));
                return;
            }
            case 1003: {
                if (object == null) {
                    preparedStatement.setNull(n2, 91);
                    return;
                }
                preparedStatement.setDate(n2, new Date(((java.util.Date)object).getTime()));
                return;
            }
            case 1006: {
                if (object == null) {
                    preparedStatement.setNull(n2, 8);
                    return;
                }
                preparedStatement.setDouble(n2, ((BigDecimal)object).doubleValue());
                return;
            }
            case 1007: {
                if (object == null) {
                    preparedStatement.setNull(n2, 6);
                    return;
                }
                preparedStatement.setFloat(n2, ((BigDecimal)object).floatValue());
                return;
            }
            case 1009: {
                preparedStatement.setInt(n2, object == null ? null : Integer.valueOf((Boolean)object != false ? 1 : 0));
                return;
            }
            case 1101: {
                if (object == null) {
                    preparedStatement.setNull(n2, 93);
                    return;
                }
                preparedStatement.setTimestamp(n2, object == null ? null : new Timestamp(((java.util.Date)object).getTime()));
                return;
            }
        }
        throw new MidCoreException(8, "\u65e0\u6cd5\u8f6c\u5316\u7684\u6570\u636e\u7c7b\u578b");
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public ResultSet executeQuery(PreparedStatement preparedStatement, String string, QueryArguments queryArguments) throws Throwable {
        this.fillPrepareParameters(preparedStatement, queryArguments);
        this.sqlLog(string, queryArguments);
        try {
            return preparedStatement.executeQuery();
        }
        catch (Throwable throwable) {
            this.sqlErrorLog(string, queryArguments, throwable);
            throw throwable;
        }
    }

    public int executeUpdate(PreparedStatement preparedStatement, String string, QueryArguments queryArguments) throws Throwable {
        int n2;
        try {
            this.fillPrepareParameters(preparedStatement, queryArguments);
            n2 = preparedStatement.executeUpdate();
            this.sqlLog(string, queryArguments);
        }
        catch (Throwable throwable) {
            this.sqlErrorLog(string, queryArguments, throwable);
            throw throwable;
        }
        return n2;
    }

    public ResultSet executeQuery(PsPara psPara, QueryArguments queryArguments) throws Throwable {
        return this.executeQuery(psPara.getPs(), psPara.getSql(), queryArguments);
    }

    public int executeUpdate(PsPara psPara, QueryArguments queryArguments) throws Throwable {
        return this.executeUpdate(psPara.getPs(), psPara.getSql(), queryArguments);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeUpdate(BatchPsPara object) throws Throwable {
        String string = object.getSql();
        if (string == null || string.length() == 0 || object.getBatchArgumentList().size() == 0) {
            return;
        }
        this.sqlLog((BatchPsPara)object);
        PreparedStatement preparedStatement = null;
        PSArgs pSArgs2 = null;
        try {
            preparedStatement = this.prepareStatement(string);
            int n2 = 0;
            for (PSArgs pSArgs2 : object.getBatchArgumentList()) {
                for (int i2 = 0; i2 < pSArgs2.size(); ++i2) {
                    this.setParameter(preparedStatement, i2 + 1, pSArgs2.get(i2), pSArgs2.getType(i2));
                }
                preparedStatement.addBatch();
                if (++n2 == 100) {
                    preparedStatement.executeBatch();
                    n2 = 0;
                }
                this.sqlLog("", (QueryArguments)pSArgs2);
            }
            if (n2 > 0) {
                preparedStatement.executeBatch();
            }
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            try {
                this.sqlErrorLog(string, (QueryArguments)pSArgs2, throwable);
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (preparedStatement == null) throw throwable2;
                preparedStatement.close();
                throw throwable2;
            }
        }
        preparedStatement.close();
        return;
    }

    private String createLogInfo(String string, QueryArguments queryArguments) {
        if (queryArguments != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            for (int i2 = 0; i2 < queryArguments.size(); ++i2) {
                stringBuffer.append("#");
                stringBuffer.append(i2);
                stringBuffer.append(":");
                stringBuffer.append(queryArguments.get(i2));
                stringBuffer.append(";");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    protected final void sqlErrorLog(String string, QueryArguments queryArguments, Throwable throwable) {
        throwable.printStackTrace();
        LogSvr.getInstance().error(this.createLogInfo(string, queryArguments), throwable);
    }

    protected final void sqlLog(String string, QueryArguments queryArguments) {
        if (SvrInfo.isNeedDebug()) {
            LogSvr.getInstance().debug(this.createLogInfo(string, queryArguments));
        }
    }

    protected final void sqlLog(BatchPsPara batchPsPara) {
        if (SvrInfo.isNeedDebug()) {
            LogSvr.getInstance().debug(this.createLogInfo(batchPsPara.getSql(), null) + "#batchUpdate" + batchPsPara.getBatchArgumentList().size() + "times");
        }
    }

    public final void setRowLock(String string, String string2, Long l2) throws Throwable {
        string = "update " + this.keyWordEscape(string) + " set Slock=1 where " + this.keyWordEscape(string2) + "=?";
        string2 = new PSArgs();
        string2.addLongArg(l2);
        this.setRowLock(string, (QueryArguments)string2);
    }

    public void setRowLock(String string, String string2, QueryArguments queryArguments) throws Throwable {
        string = "update " + this.keyWordEscape(string) + " set Slock=1 where " + string2;
        this.setRowLock(string, queryArguments);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setRowLock(String string, QueryArguments queryArguments) throws Throwable {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(string);
            this.executeUpdate(preparedStatement, string, queryArguments);
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            try {
                this.sqlErrorLog(string, queryArguments, throwable);
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (preparedStatement == null) throw throwable2;
                preparedStatement.close();
                throw throwable2;
            }
        }
        preparedStatement.close();
        return;
    }

    public void setRowLockEnsureInSYSLock(String string) throws Throwable {
        Statement statement;
        block10: {
            PSArgs pSArgs = new PSArgs();
            pSArgs.addStringArg(string);
            String string2 = "update SYS_Lock set Slock=1 where UniqueKey=?";
            PreparedStatement preparedStatement = null;
            statement = null;
            try {
                preparedStatement = this.preparedUpdateStatement(string2);
                if (this.executeUpdate(preparedStatement, string2, (QueryArguments)pSArgs) == 0) {
                    Object object = new PSArgs();
                    object.addStringArg(STR_SYS_Lock_GlobalKey);
                    this.executeUpdate(preparedStatement, string2, (QueryArguments)object);
                    if (this.executeUpdate(preparedStatement, string2, (QueryArguments)pSArgs) == 0) {
                        object = "insert into SYS_Lock (UniqueKey) values (?)";
                        statement = this.prepareStatement((String)object);
                        this.executeUpdate((PreparedStatement)statement, (String)object, (QueryArguments)pSArgs);
                        if (this.executeUpdate(preparedStatement, string2, (QueryArguments)pSArgs) != 1) {
                            throw new RuntimeException("\u6570\u636e\u8868SYS_Lock\u52a0\u884c\u9501\u5931\u8d25\uff0c".concat(String.valueOf(string)));
                        }
                    }
                }
                if (preparedStatement == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    throw throwable2;
                }
            }
            preparedStatement.close();
        }
        if (statement != null) {
            statement.close();
            return;
        }
    }

    public IDBManager getNewDBManager() throws Throwable {
        IDBManager iDBManager = new DBManagerFactory().getDBManager(this.profile);
        iDBManager.setVE(this.ve);
        return iDBManager;
    }

    public long getCurTime() throws Throwable {
        return System.currentTimeMillis();
    }

    public int getTimezoneOffset() throws Throwable {
        Calendar.getInstance().getTimeZone();
        return 0;
    }

    public Statement createUpdateStatement() throws Throwable {
        return this.createStatement();
    }

    public Statement createQueryStatement() throws Throwable {
        return this.createStatement();
    }

    public PreparedStatement preparedQueryStatement(String string) throws Throwable {
        return this.prepareStatement(string);
    }

    public PreparedStatement preparedUpdateStatement(String string) throws Throwable {
        return this.prepareStatement(string);
    }

    protected PreparedStatement prepareStatement(String string) throws SQLException {
        return this.connection.prepareStatement(string);
    }

    private Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public abstract String getTableStructSql();

    public abstract String getColumnStructSql();

    public abstract String getIndexStructSql();

    public abstract String getViewStructSql();

    public PrepareSQL getCountString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 100);
        PrepareSQL prepareSQL = new PrepareSQL();
        stringBuilder.append("select count(1) as count from (");
        stringBuilder.append(string);
        stringBuilder.append(") t");
        prepareSQL.setSQL(stringBuilder.toString());
        return prepareSQL;
    }

    public void initDataBaseInfo(DataBaseInfo dataBaseInfo) throws Throwable {
        PreparedStatement preparedStatement;
        block23: {
            String string = this.getTableStructSql();
            preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, null);
                dataBaseInfo.initTable(resultSet);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            try {
                string = this.getViewStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, null);
                dataBaseInfo.initView(resultSet);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            try {
                string = this.getColumnStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, null);
                dataBaseInfo.initColumn(resultSet);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            try {
                string = this.getIndexStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, null);
                dataBaseInfo.initIndex(resultSet);
                if (resultSet == null) break block23;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
            return;
        }
    }

    public boolean saveDataTable(DataTable dataTable, String string, MetaTable metaTable, Object object) throws SQLException {
        return true;
    }

    public String getDefaultValueString(int n2, String string) {
        String string2 = "";
        if (n2 == 1002 || n2 == 1012) {
            if (StringUtil.isBlankOrNull((String)string)) {
                string2 = " DEFAULT '  ' NOT NULL";
            } else {
                string2 = " DEFAULT '" + TypeConvertor.toDataType((int)n2, (Object)string) + "'";
                string2 = string2 + " NOT NULL";
            }
        } else if (n2 == 1001 || n2 == 1005 || n2 == 1006 || n2 == 1007 || n2 == 1010) {
            if (StringUtil.isBlankOrNull((String)string)) {
                string2 = " DEFAULT 0 NOT NULL";
            } else {
                string2 = " DEFAULT ".concat(String.valueOf(string));
                string2 = string2 + " NOT NULL";
            }
        }
        return string2;
    }
}

