/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class DMDBManager
extends GeneralDBManager {
    public DMDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
    }

    @Override
    public String getAlterTableStr(MetaSchemaTable object, List<MetaSchemaColumn> object2) throws Throwable {
        MetaSchemaColumn metaSchemaColumn;
        object2 = object2.iterator();
        object = "alter table " + this.keyWordEscape(object.getKey()) + " add (";
        if (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        while (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + "," + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        return (String)object + ")";
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        String string;
        switch (metaSchemaColumn.getDataType()) {
            case 1001: {
                string = " int ";
                break;
            }
            case 1002: {
                string = " varchar(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1003: {
                string = " date ";
                break;
            }
            case 1004: {
                string = " datetime ";
                break;
            }
            case 1005: {
                string = " numeric(" + metaSchemaColumn.getPrecision() + "," + metaSchemaColumn.getScale() + ") ";
                break;
            }
            case 1006: {
                string = " double ";
                break;
            }
            case 1007: {
                string = " float ";
                break;
            }
            case 1008: {
                string = " blob ";
                break;
            }
            case 1009: {
                string = " int ";
                break;
            }
            case 1011: {
                string = " text ";
                break;
            }
            case 1012: {
                string = " char(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1010: {
                string = " bigint ";
                break;
            }
            case 1101: {
                string = " timestamp ";
                break;
            }
            default: {
                throw new MidCoreException(6, "\u6570\u636e\u7c7b\u578b" + DataType.toString((Integer)metaSchemaColumn.getDataType()) + "\u5728DMDBManager\u4e2d\u672a\u5b9a\u4e49\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5217\u7c7b\u578b\uff01");
            }
        }
        return this.keyWordEscape(metaSchemaColumn.getKey()) + string;
    }

    public String keyWordEscape(String string) {
        return "\"" + string.toUpperCase() + "\"";
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String string) {
        return stringBuilder.append("\"").append(string.toUpperCase()).append("\"");
    }

    public int getDBType() {
        return 8;
    }

    public String getConditionValue(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string = string.replaceAll("\\D+", "");
            stringBuilder.append(string);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string = "to_date('" + stringBuilder.toString() + "','yyyy-mm-dd')";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string = "to_date('" + stringBuilder.toString() + "','yyyy-mm-dd hh24:mi:ss')";
            }
            return string;
        }
        stringBuilder.append(string);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.insert(stringBuilder2.length(), "'").insert(0, "'");
        return stringBuilder.toString();
    }

    public String getLikeConditionValue(String string, int n2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string2 = string2.replaceAll("\\D+", "");
            stringBuilder.append(string2);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = string + " like to_date('" + string2 + "','yyyy-mm-dd')";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = string + " like to_date('" + string2 + "','yyyy-mm-dd hh24:mi:ss')";
            }
            return string2;
        }
        return string + " like " + string2;
    }

    public PrepareSQL getLimitString(String string, String string2, boolean bl, int n2, int n3) {
        boolean bl2 = string2 != null && string2.length() != 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(" order by ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(bl ? " limit ?, ?" : " limit ?");
        string = new PrepareSQL();
        string.setSQL(stringBuilder.toString());
        if (bl) {
            string.addValue((Object)n2);
            string.addValue((Object)(n3 - n2));
        } else {
            string.addValue((Object)n3);
        }
        return string;
    }

    @Override
    public String getTableExistCheckSql() {
        return "select count(*) from user_tables where UPPER(table_name)=?";
    }

    @Override
    public String getIndexSearchSql() {
        return "select table_name from user_indexes where UPPER(index_name)=?";
    }

    @Override
    public String getIndexCheckSql() {
        return "select index_name from user_indexes where UPPER(table_name)=?";
    }

    @Override
    public String getColumnCheckSql() {
        return "select column_name from user_tab_columns where UPPER(table_name) =?";
    }

    @Override
    public String getTableStructSql() {
        return "select TABLE_NAME from user_tables";
    }

    @Override
    public String getColumnStructSql() {
        return "select user_tab_columns.column_name as column_name, user_tab_columns.table_name as table_name from user_tab_columns join user_tables on user_tables.table_Name = user_tab_columns.table_Name";
    }

    @Override
    public String getIndexStructSql() {
        return "select * from (SELECT O1.NAME INDEX_NAME, O.NAME TABLE_NAME,COLS.NAME COLUMN_NAME,  CASE WHEN I.ISUNIQUE='N' THEN 1 ELSE 0 END AS NON_UNIQUE,CAST(SF_GET_INDEX_KEY_SEQ(I.KEYNUM, I.KEYINFO, COLs.COLID) AS NUMBER(10,0))  COLUMN_POSITION FROM SYS.SYSINDEXES I,SYS.SYSOBJECTS O ,SYS.SYSOBJECTS O1,SYS.SYSCOLUMNS COLS WHERE O1.ID=I.ID  AND O.ID = O1.PID AND O.SUBTYPE$='UTAB'  AND O.SCHID IN(SELECT ID FROM SYS.SYSOBJECTS WHERE TYPE$='SCH' AND PID = UID()) AND COLS.ID=O1.PID AND SF_COL_IS_IDX_KEY(I.KEYNUM, I.KEYINFO, COLS.COLID) = 1) t order by TABLE_NAME, INDEX_NAME, COLUMN_POSITION;";
    }

    @Override
    public String getViewExistCheckSql() {
        return "select count(*) from user_views where UPPER(view_name)=?";
    }

    @Override
    public String getViewStructSql() {
        return "select view_name from user_views";
    }

    @Override
    public void setParameter(PreparedStatement preparedStatement, int n2, Object object, int n3) throws SQLException, MidCoreException {
        super.setParameter(preparedStatement, n2, object, n3);
        switch (n3) {
            case 1004: {
                if (object == null) {
                    preparedStatement.setString(n2, "");
                }
                return;
            }
        }
    }
}

