/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.cmd.migration;

import com.bokesoft.yes.mid.migration.MigrationProcess;
import com.bokesoft.yes.mid.migration.process.IStrategy;
import com.bokesoft.yes.mid.migration.process.MigrationStrategyFactory;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadData;
import com.bokesoft.yigo.struct.document.Document;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class ReMigrateProxy {
    private MetaDataObject metaDataObject = null;
    private TreeMap<String, MetaDataMigration> migrationMap;
    private boolean exitMigration = true;

    public ReMigrateProxy(String object, DefaultContext defaultContext) throws Throwable {
        defaultContext = defaultContext.getVE().getMetaFactory();
        this.metaDataObject = defaultContext.getDataObject((String)object);
        object = defaultContext.getDataMigrationList().getTgtTree((String)object);
        if (object != null) {
            this.migrationMap = new TreeMap();
            object = object.iterator();
            while (object.hasNext()) {
                MetaDataMigrationProfile metaDataMigrationProfile = (MetaDataMigrationProfile)object.next();
                MetaDataMigration metaDataMigration = metaDataMigrationProfile.getDataMigration();
                if (metaDataMigration == null) {
                    metaDataMigration = defaultContext.getDataMigration(metaDataMigrationProfile.getKey());
                }
                this.migrationMap.put(metaDataMigrationProfile.getKey(), metaDataMigration);
            }
            return;
        }
        this.exitMigration = false;
    }

    private void deleteData(DefaultContext defaultContext) throws Throwable {
        Object object = (MetaTable)this.metaDataObject.getTableCollection().get(0);
        String string = object.getBindingDBTableName();
        String string2 = string + "_LP";
        object = object.getOIDColumn().getBindingDBColumnName();
        defaultContext = defaultContext.getDBManager();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" delete  from ");
        stringBuilder.append(defaultContext.keyWordEscape(string));
        stringBuilder.append(" where ");
        stringBuilder.append(defaultContext.keyWordEscape((String)object));
        stringBuilder.append(" >0 ");
        string = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(" delete  from ");
        stringBuilder.append(defaultContext.keyWordEscape(string2));
        stringBuilder.append(" where ");
        stringBuilder.append(defaultContext.keyWordEscape((String)object));
        stringBuilder.append(" >0 ");
        object = stringBuilder.toString();
        defaultContext.execUpdate(string);
        if (defaultContext.checkTableExist(string2)) {
            defaultContext.execUpdate((String)object);
        }
    }

    private List<Long> loadOIDs(DefaultContext defaultContext, String string) throws Throwable {
        string = defaultContext.getVE().getMetaFactory().getDataObject(string).getMainTable();
        if (string == null) {
            return null;
        }
        defaultContext = defaultContext.getDBManager();
        string = string.getBindingDBTableName();
        string = "select OID from " + defaultContext.keyWordEscape(string);
        ResultSet resultSet = null;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = defaultContext.preparedQueryStatement(string);
            resultSet = defaultContext.executeQuery(preparedStatement, string, null);
            while (resultSet.next()) {
                long l2 = resultSet.getLong(1);
                if (l2 <= 0L) continue;
                arrayList.add(l2);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return arrayList;
    }

    private Document loadData(DefaultContext defaultContext, String string, Long l2) throws Throwable {
        return new LoadData(string, (long)l2).load(defaultContext, null);
    }

    public void process(DefaultContext defaultContext) throws Throwable {
        if (!this.exitMigration) {
            return;
        }
        this.deleteData(defaultContext);
        for (MetaDataMigration metaDataMigration : this.migrationMap.values()) {
            String string = metaDataMigration.getSrcDataObjectKey();
            List<Long> list = this.loadOIDs(defaultContext, string);
            if (list == null || list.size() == 0) continue;
            for (Long l2 : list) {
                DefaultContext defaultContext2 = new DefaultContext(defaultContext);
                l2 = this.loadData(defaultContext2, string, l2);
                l2.setNew();
                l2 = new MigrationProcess(defaultContext2, (Document)l2, metaDataMigration, true, false);
                IStrategy iStrategy = MigrationStrategyFactory.getMigrationProcess((MetaDataMigration)metaDataMigration, (DefaultContext)defaultContext2);
                l2.setProcess(iStrategy);
                l2.doProcess(defaultContext2);
            }
        }
    }
}

