/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.right;

import com.bokesoft.yes.mid.base.BaseEventDispatcher;
import com.bokesoft.yes.mid.base.EventDispatcher;
import com.bokesoft.yes.mid.right.FormRightsProxyFactory;
import com.bokesoft.yes.mid.rights.FormRightsHandler;
import com.bokesoft.yigo.mid.base.EventHandler;
import com.bokesoft.yigo.mid.base.IServiceEvent;
import com.bokesoft.yigo.mid.base.RightsContext;
import com.bokesoft.yigo.mid.rights.IFormRightsProxy;
import com.bokesoft.yigo.mid.rights.RightsObject;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.List;

public class FormRightsLoader {
    private RightsContext context;
    private EventDispatcher<IServiceEvent> dispatcher = null;

    public FormRightsLoader(RightsContext rightsContext) {
        this.context = rightsContext;
        this.dispatcher = new BaseEventDispatcher();
    }

    public RightsObject fireLoad(IServiceEvent iServiceEvent) throws Throwable {
        this.addHandlers();
        this.dispatcher.dispatch(iServiceEvent);
        return (RightsObject)this.context.getResult();
    }

    private void addHandlers() throws Throwable {
        if (!this.addExtHandlers()) {
            this.addBPMHandler();
            this.addFormOwnHandler();
            this.addFormHandler();
        }
    }

    private boolean addExtHandlers() throws Throwable {
        List list = FormRightsProxyFactory.getInstance().newExtProxy((VE)this.context.getVE(), this.context.getFormKey());
        for (IFormRightsProxy iFormRightsProxy : list) {
            this.dispatcher.addEventHandler((EventHandler)new FormRightsHandler(iFormRightsProxy, this.context));
        }
        return !list.isEmpty();
    }

    private void addFormOwnHandler() throws Throwable {
        IFormRightsProxy iFormRightsProxy = FormRightsProxyFactory.getInstance().newFormOwnProxy();
        iFormRightsProxy = new FormRightsHandler(iFormRightsProxy, this.context);
        this.dispatcher.addEventHandler((EventHandler)iFormRightsProxy);
    }

    private void addBPMHandler() throws Throwable {
        IFormRightsProxy iFormRightsProxy = FormRightsProxyFactory.getInstance().newBPMProxy((VE)this.context.getVE());
        iFormRightsProxy = new FormRightsHandler(iFormRightsProxy, this.context);
        this.dispatcher.addEventHandler((EventHandler)iFormRightsProxy);
    }

    private void addFormHandler() throws Throwable {
        IFormRightsProxy iFormRightsProxy = FormRightsProxyFactory.getInstance().newDefaultProxy((VE)this.context.getVE());
        iFormRightsProxy = new FormRightsHandler(iFormRightsProxy, this.context);
        this.dispatcher.addEventHandler((EventHandler)iFormRightsProxy);
    }
}

