/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.hotdeploy.schema;

import com.bokesoft.yes.mid.schema.ISchemaProvider;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.deploy.MetaDeploy;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class HotDeploySchemaProvider
implements ISchemaProvider {
    private IMetaFactory oldMetafactory;
    private IMetaFactory newMetafactory;
    private MetaDeploy deploy;
    private HashSet<String> deployedMap;
    private HashSet<String> dictsToMaintain = new HashSet();

    public HotDeploySchemaProvider(IMetaFactory object, IMetaFactory iMetaFactory2, MetaDeploy metaDeploy) {
        this.oldMetafactory = object;
        this.newMetafactory = iMetaFactory2;
        this.deploy = metaDeploy;
        if (metaDeploy != null) {
            this.deployedMap = new HashSet();
            for (IMetaFactory iMetaFactory2 : metaDeploy.getProjects()) {
                this.deployedMap.add(iMetaFactory2.getKey());
            }
        }
    }

    public boolean needDeploy(MetaDataObject object) {
        if (this.deployedMap == null) {
            return true;
        }
        if ((object = object.getProject()) != null) {
            object = object.getKey();
            return this.deployedMap.contains(object);
        }
        return true;
    }

    public List<MetaSchemaTable> getAllTable() throws Throwable {
        LinkedList<MetaSchemaTable> linkedList = new LinkedList<MetaSchemaTable>();
        MetaDataObjectList metaDataObjectList = this.oldMetafactory.getDataObjectList();
        Iterator iterator = this.newMetafactory.getDataObjectList().iterator();
        List list = null;
        while (iterator.hasNext()) {
            MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)iterator.next();
            MetaDataObject metaDataObject = metaDataObjectProfile.getDataObject();
            metaDataObjectProfile = (MetaDataObjectProfile)metaDataObjectList.get(metaDataObjectProfile.getKey());
            MetaDataObject metaDataObject2 = null;
            if (metaDataObjectProfile != null) {
                metaDataObject2 = metaDataObjectProfile.getDataObject();
            }
            if (this.deploy == null || this.needDeploy(metaDataObject)) {
                list = metaDataObject.compareAndGet(metaDataObject2, false);
            } else if (this.deploy != null && this.deploy.isIncludedRightsSchema().booleanValue()) {
                list = metaDataObject.compareAndGet(metaDataObject2, true);
            }
            if (list == null || list.size() <= 1) continue;
            linkedList.addAll(list);
            if (this.oldMetafactory == null || metaDataObject.getSecondaryType() != 3 && metaDataObject.getSecondaryType() != 5) continue;
            this.dictsToMaintain.add(metaDataObject.getKey());
        }
        return linkedList;
    }

    public Set<String> getDictsToMaintain() {
        return this.dictsToMaintain;
    }
}

