/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.document.io;

import com.bokesoft.yes.mid.document.DocumentProcess;
import com.bokesoft.yes.mid.document.io.DocumentXMLIOUtil;
import com.bokesoft.yes.mid.oid.OIDAllocatorFactory;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.oid.IOIDAllocator;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentXMLIOSaveImpl {
    private String providerKey = "";
    private MetaDataObject metaDataObject = null;
    private Map<String, Map<String, Boolean>> asCDATAMap = null;

    public DocumentXMLIOSaveImpl(String string, MetaDataObject metaDataObject) {
        this.providerKey = string;
        this.metaDataObject = metaDataObject;
        this.asCDATAMap = new HashMap<String, Map<String, Boolean>>();
    }

    public Document save(DefaultContext object, Document document) throws Throwable {
        Object object2;
        boolean bl = document.getOID() == -1L;
        if (bl) {
            object = new DefaultContext(object);
            object.setDocument(document);
        } else {
            object = ContextBuilder.getDefaultContext((DefaultContext)object, (Document)document);
        }
        DocumentProcess documentProcess2 = new DocumentProcess(this.metaDataObject, document);
        IOIDAllocator iOIDAllocator = OIDAllocatorFactory.getInstance().create(object);
        documentProcess2.process(object, iOIDAllocator);
        if (bl && object.getContextContainer() != null) {
            object.getContextContainer().putContext(Long.valueOf(document.getOID()), DefaultContext.TYPE, (IServiceContext)object);
            object.getContextContainer().putContext(document.getObjectKey(), DefaultContext.TYPE, (IServiceContext)object);
        }
        if (!((File)(object2 = new File((String)(object = DocumentXMLIOUtil.getPath(object, this.providerKey))))).exists()) {
            ((File)object2).mkdir();
        }
        for (DocumentProcess documentProcess2 : document) {
            iOIDAllocator = (MetaTable)this.metaDataObject.getTableCollection().get(documentProcess2.getKey());
            String string = DocumentXMLIOUtil.getTableName((MetaTable)iOIDAllocator);
            string = (String)object + string + ".xml";
            DomHelper.writeDocumentToFile((org.w3c.dom.Document)this.writeTable(string, (MetaTable)iOIDAllocator, (DataTable)documentProcess2), (String)string);
        }
        return document;
    }

    private org.w3c.dom.Document writeTable(String object, MetaTable metaTable, DataTable dataTable) throws Throwable {
        if ((object = DomHelper.readDocumentFromFile((String)object)) == null) {
            object = DomHelper.createDocument();
            this.initTableDocument(metaTable, (org.w3c.dom.Document)object);
        } else {
            Map<String, Boolean> map = DocumentXMLIOUtil.readAsCDATA((org.w3c.dom.Document)object);
            this.asCDATAMap.put(metaTable.getKey(), map);
        }
        this.writeTable((org.w3c.dom.Document)object, metaTable, dataTable);
        return object;
    }

    private void writeTable(org.w3c.dom.Document document, MetaTable metaTable, DataTable dataTable) throws Throwable {
        Element element = (Element)document.getElementsByTagName("Table").item(0);
        Element element2 = DomHelper.getElement((Element)element, (String)"Rows");
        if (element2 == null) {
            element2 = document.createElement("Rows");
            element.appendChild(element2);
        }
        dataTable.setShowDeleted(true);
        dataTable.beforeFirst();
        while (dataTable.next()) {
            Object object;
            int n2 = dataTable.getState();
            int n3 = dataTable.getPos();
            if (n2 == 1) {
                object = this.newRow(document, metaTable, dataTable, n3);
                element2.appendChild((Node)object);
                continue;
            }
            if (n2 != 2 && n2 != 3) continue;
            object = DomHelper.getChildList((Element)element2, (String)"Row");
            long l2 = TypeConvertor.toLong((Object)dataTable.getObject("OID"));
            if ((object = DocumentXMLIOUtil.searchElement((List<Element>)object, "OID", l2)).size() == 0) {
                throw new RuntimeException("\u627e\u4e0d\u5230\u5217:".concat(String.valueOf(l2)));
            }
            if (object.size() > 1) {
                throw new RuntimeException("\u5217\u4e0d\u552f\u4e00:".concat(String.valueOf(l2)));
            }
            object = object.get(0);
            if (n2 == 2) {
                this.modifyRow((Element)object, metaTable, dataTable, n3);
                continue;
            }
            element2.removeChild((Node)object);
        }
    }

    private Element newRow(org.w3c.dom.Document document, MetaTable object, DataTable dataTable, int n2) {
        Map map = this.asCDATAMap.getOrDefault(object.getKey(), null);
        Element element = document.createElement("Row");
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (MetaColumn)object.next();
            Object object3 = object2.getKey();
            if ((object3 = dataTable.getObject(n2, (String)object3)) == null) continue;
            object2 = this.newColumn(document, (MetaColumn)object2, object3, map);
            element.appendChild((Node)object2);
        }
        return element;
    }

    private void modifyRow(Element element, MetaTable object, DataTable dataTable, int n2) {
        Map map = this.asCDATAMap.getOrDefault(object.getKey(), null);
        object = object.iterator();
        while (object.hasNext()) {
            MetaColumn metaColumn = (MetaColumn)object.next();
            Object object2 = metaColumn.getKey();
            Object object3 = dataTable.getObject(n2, (String)object2);
            if (object3 == null) continue;
            object2 = DomHelper.getElement((Element)element, (String)object2);
            this.modifyColumn((Element)object2, metaColumn, object3, map);
        }
    }

    private Element newColumn(org.w3c.dom.Document document, MetaColumn metaColumn, Object object, Map<String, Boolean> map) {
        Object object2 = metaColumn.getKey();
        object2 = document.createElement((String)object2);
        object = TypeConvertor.toString((Object)object);
        boolean bl = false;
        if (map != null) {
            bl = map.getOrDefault(metaColumn.getKey(), Boolean.FALSE);
        }
        if (bl) {
            DomHelper.writeCDATAContent((org.w3c.dom.Document)document, (Element)object2, (String)object);
        } else {
            object2.appendChild(document.createTextNode((String)object));
        }
        return object2;
    }

    private void modifyColumn(Element element, MetaColumn metaColumn, Object object, Map<String, Boolean> map) {
        object = TypeConvertor.toString((Object)object);
        boolean bl = false;
        if (map != null) {
            bl = map.getOrDefault(metaColumn.getKey(), Boolean.FALSE);
        }
        if (bl) {
            ((CDATASection)element.getChildNodes().item(0)).setData((String)object);
            return;
        }
        element.setTextContent((String)object);
    }

    private void initTableDocument(MetaTable object, org.w3c.dom.Document document) {
        Element element = document.createElement("Table");
        document.appendChild(element);
        Element element2 = document.createElement("Columns");
        element.appendChild(element2);
        object = object.iterator();
        while (object.hasNext()) {
            element = (MetaColumn)object.next();
            Element element3 = document.createElement("Column");
            DomHelper.writeAttr((Element)element3, (String)"Key", (String)element.getKey(), (String)"");
            DomHelper.writeAttr((Element)element3, (String)"Caption", (String)element.getCaption(), (String)"");
            DomHelper.writeAttr((Element)element3, (String)"DataType", (String)("" + element.getDataType()), (String)"");
            element2.appendChild(element3);
        }
    }
}

