/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ShenTongDBManager
extends GeneralDBManager {
    private static final String[] keyWord = new String[]{"ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AT", "BEGIN", "BETWEEN", "BY", "CASE", "CHECK", "CLUSTERS", "CLUSTER", "COLAUTH", "COLUMNS", "COMPRESS", "CONNECT", "CRASH", "CREATE", "CURSOR", "DATE", "DECLARE", "DEFAULT", "DESC", "DISTINCT", "DROP", "ELSE", "END", "EXCEPTION", "EXCLUSIVE", "FETCH", "FOR", "FOREIGN", "FROM", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IF", "IN", "INDEX", "INDEXES", "INSERT", "INTERSECT", "INTO", "IS", "LIKE", "LOCK", "LEVEL", "MINUS", "MODE", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "OF", "ON", "OPTION", "OR", "ORDER", "OVERLAPS", "PROCEDURE", "PUBLIC", "RESOURCE", "REVOKE", "SELECT", "SHARE", "SIZE", "SQL", "START", "SUBTYPE", "TABAUTH", "TABLE", "THEN", "TO", "TYPE", "UNION", "UNIQUE", "UPDATE", "VALUES", "VIEW", "VIEWS", "WHEN", "WHERE", "WITH", "LONG", "NUMBER", "INTEGER"};
    private Set<String> keySet = null;

    public ShenTongDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
    }

    public String getTableExistCheckSql() {
        return "select count(TABLE_NAME) from user_tables where UPPER(table_name)=?";
    }

    public String getColumnCheckSql() {
        return "select column_name from user_TAB_COLUMNS where UPPER(table_name) =?";
    }

    public String getIndexCheckSql() {
        return "select index_name from user_indexes where UPPER(table_name) =?";
    }

    public String getIndexSearchSql() {
        return "select table_name from user_indexes where UPPER(index_name) =?";
    }

    @Override
    public String getAlterTableStr(MetaSchemaTable object, List<MetaSchemaColumn> object2) throws Throwable {
        MetaSchemaColumn metaSchemaColumn;
        object2 = object2.iterator();
        object = "alter table " + this.keyWordEscape(object.getKey()) + " add (";
        if (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        while (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + "," + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        return (String)object + ")";
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        String string;
        switch (metaSchemaColumn.getDataType()) {
            case 1001: {
                string = " int ";
                break;
            }
            case 1002: {
                string = " varchar(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1003: {
                string = " date ";
                break;
            }
            case 1004: {
                string = " timestamp ";
                break;
            }
            case 1005: {
                string = " numeric(" + metaSchemaColumn.getPrecision() + "," + metaSchemaColumn.getScale() + ") ";
                break;
            }
            case 1006: {
                string = " double precision ";
                break;
            }
            case 1007: {
                string = " float ";
                break;
            }
            case 1008: {
                string = " blob ";
                break;
            }
            case 1009: {
                string = " int";
                break;
            }
            case 1011: {
                string = " clob ";
                break;
            }
            case 1012: {
                string = " char(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1010: {
                string = " NUMBER(20, 0) ";
                break;
            }
            case 1101: {
                string = " timestamp ";
                break;
            }
            default: {
                throw new MidCoreException(6, "\u6570\u636e\u7c7b\u578b" + DataType.toString((Integer)metaSchemaColumn.getDataType()) + "\u5728ShenTongDBManager\u4e2d\u672a\u5b9a\u4e49\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5217\u7c7b\u578b\uff01");
            }
        }
        return this.keyWordEscape(metaSchemaColumn.getKey()) + string;
    }

    public String keyWordEscape(String string) {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>();
            for (int i2 = 0; i2 < keyWord.length; ++i2) {
                this.keySet.add(keyWord[i2].toUpperCase());
            }
        }
        if (this.keySet.contains(string.toUpperCase())) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String string) {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>();
            for (int i2 = 0; i2 < keyWord.length; ++i2) {
                this.keySet.add(keyWord[i2].toUpperCase());
            }
        }
        if (this.keySet.contains(string.toUpperCase())) {
            return stringBuilder.append("\"").append(string).append("\"");
        }
        return stringBuilder.append(string);
    }

    public int getDBType() {
        return 15;
    }

    @Override
    public Object convert(Object object, int n2, int n3) throws Throwable {
        if (n3 == 101 && (n2 == 1006 || n2 == 1007 || n2 == 1005)) {
            return new BigDecimal((Double)object);
        }
        if (n3 == 100 && (n2 == 1007 || n2 == 1006 || n2 == 1005)) {
            return new BigDecimal(((Float)object).floatValue());
        }
        if (n2 == 1011 && (2005 == n3 || 2011 == n3)) {
            if (object instanceof String) {
                return object;
            }
            object = (Clob)object;
            return this.ClobtoString((Clob)object);
        }
        return super.convert(object, n2, n3);
    }

    private String ClobtoString(Clob object) throws Throwable {
        String string;
        block14: {
            if (object == null) {
                return null;
            }
            Reader reader = object.getCharacterStream();
            Throwable throwable = null;
            try {
                char c2;
                StringBuilder stringBuilder = new StringBuilder((int)object.length());
                while ((c2 = reader.read()) != '\uffffffff') {
                    c2 = c2;
                    stringBuilder.append(c2);
                }
                string = stringBuilder.toString();
                if (reader == null) break block14;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (IOException iOException) {
                    LogSvr.getInstance().error(iOException.getMessage(), (Throwable)iOException);
                    return null;
                }
            }
            reader.close();
        }
        return string;
    }

    @Override
    public int convertDataType(int n2) {
        if (n2 == 101) {
            return 1006;
        }
        if (n2 == 100) {
            return 1007;
        }
        return super.convertDataType(n2);
    }

    public String getConditionValue(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string = string.replaceAll("\\D+", "");
            stringBuilder.append(string);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string = "to_date('" + stringBuilder.toString() + "','yyyy-mm-dd')";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string = "to_date('" + stringBuilder.toString() + "','yyyy-mm-dd hh24:mi:ss')";
            }
            return string;
        }
        stringBuilder.append(string);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.insert(stringBuilder2.length(), "'").insert(0, "'");
        return stringBuilder.toString();
    }

    public String getLikeConditionValue(String string, int n2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string2 = string2.replaceAll("\\D+", "");
            stringBuilder.append(string2);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = string + " like to_date('" + string2 + "','yyyy-mm-dd')";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = string + " like to_date('" + string2 + "','yyyy-mm-dd hh24:mi:ss')";
            }
            return string2;
        }
        return string + " like " + string2;
    }

    public PrepareSQL getLimitString(String string, String charSequence, boolean bl, int n2, int n3) {
        if (charSequence != null && ((String)charSequence).length() != 0) {
            string = string + " order by " + (String)charSequence;
        }
        charSequence = new StringBuilder(string.length() + 100);
        PrepareSQL prepareSQL = new PrepareSQL();
        if (bl) {
            ((StringBuilder)charSequence).append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            ((StringBuilder)charSequence).append("select * from ( ");
        }
        ((StringBuilder)charSequence).append(string);
        if (bl) {
            ((StringBuilder)charSequence).append(" ) row_ ) where rownum_ > ? and rownum_ <= ? ");
            prepareSQL.addValue((Object)n2);
            prepareSQL.addValue((Object)n3);
        } else {
            ((StringBuilder)charSequence).append(" ) where rownum <= ?");
            prepareSQL.addValue((Object)n3);
        }
        prepareSQL.setSQL(((StringBuilder)charSequence).toString());
        return prepareSQL;
    }

    public String getTableStructSql() {
        return "select TABLE_NAME from user_tables";
    }

    public String getColumnStructSql() {
        return "select user_tab_columns.column_name as column_name, user_tab_columns.table_name as table_name from user_tab_columns join user_tables on user_tables.table_Name = user_tab_columns.table_Name";
    }

    public String getIndexStructSql() {
        return "select index_name,table_name, '' as COLUMN_NAME, -1 as NON_UNIQUE, 0 as SEQ_IN_INDEX from user_indexes";
    }

    public String getViewExistCheckSql() {
        return "select count(view_name) from user_views where UPPER(view_name)=?";
    }

    public String getViewStructSql() {
        return "select view_name from user_views";
    }
}

