/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import java.sql.Connection;
import java.util.List;

public class QianBaseDBManager
extends GeneralDBManager {
    public QianBaseDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
    }

    @Override
    public String getAlterTableStr(MetaSchemaTable object, List<MetaSchemaColumn> object2) throws Throwable {
        MetaSchemaColumn metaSchemaColumn;
        object2 = object2.iterator();
        object = "alter table " + this.keyWordEscape(object.getKey());
        if (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + " add COLUMN " + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        while (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + ", add COLUMN " + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        return object;
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        String string;
        switch (metaSchemaColumn.getDataType()) {
            case 1001: {
                string = " int4 ";
                break;
            }
            case 1002: {
                string = " varchar(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1003: {
                string = " date ";
                break;
            }
            case 1004: {
                string = " timestamp ";
                break;
            }
            case 1005: {
                string = " numeric(" + metaSchemaColumn.getPrecision() + "," + metaSchemaColumn.getScale() + ") ";
                break;
            }
            case 1006: {
                string = " float ";
                break;
            }
            case 1007: {
                string = " float ";
                break;
            }
            case 1008: {
                string = " blob ";
                break;
            }
            case 1009: {
                string = " int4 ";
                break;
            }
            case 1011: {
                string = " varchar(" + metaSchemaColumn.getLength() + ")  ";
                break;
            }
            case 1012: {
                string = " char(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1010: {
                string = " int8 ";
                break;
            }
            case 1101: {
                string = " timestamp ";
                break;
            }
            default: {
                throw new MidCoreException(6, "\u6570\u636e\u7c7b\u578b" + DataType.toString((Integer)metaSchemaColumn.getDataType()) + "\u5728DMDBManager\u4e2d\u672a\u5b9a\u4e49\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5217\u7c7b\u578b\uff01");
            }
        }
        return this.keyWordEscape(metaSchemaColumn.getKey()) + string;
    }

    public String keyWordEscape(String string) {
        return "\"" + string.toLowerCase() + "\"";
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String string) {
        return stringBuilder.append("\"").append(string.toLowerCase()).append("\"");
    }

    public int getDBType() {
        return 14;
    }

    public String getConditionValue(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string = string.replaceAll("\\D+", "");
            stringBuilder.append(string);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string = "to_date('" + stringBuilder.toString() + "','yyyy-MM-dd hh24:mi:ss')";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string = "to_timestamp('" + stringBuilder.toString() + "','yyyy-MM-dd hh24:mi:ss')";
            }
            return string;
        }
        stringBuilder.append(string);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.insert(stringBuilder2.length(), "'").insert(0, "'");
        return stringBuilder.toString();
    }

    public String getLikeConditionValue(String string, int n2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string2 = string2.replaceAll("\\D+", "");
            stringBuilder.append(string2);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = string + " like to_date('" + string2 + "','yyyy-MM-dd hh24:mi:ss')";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = string + " like to_timestamp('" + string2 + "','yyyy-MM-dd hh24:mi:ss')";
            }
            return string2;
        }
        return string + " like " + string2;
    }

    public PrepareSQL getLimitString(String string, String string2, boolean bl, int n2, int n3) {
        boolean bl2 = string2 != null && string2.length() != 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(" order by ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(bl ? " limit ? OFFSET ?" : " limit ?");
        string = new PrepareSQL();
        string.setSQL(stringBuilder.toString());
        if (bl) {
            string.addValue((Object)(n3 - n2));
            string.addValue((Object)n2);
        } else {
            string.addValue((Object)n3);
        }
        return string;
    }

    public String getTableExistCheckSql() {
        return "select count(tablename) from pg_tables where schemaname='public' and UPPER(tablename)=?";
    }

    public String getIndexSearchSql() {
        return "select tablename from pg_indexes where schemaname='public' and Upper(indexname)=?";
    }

    public String getIndexCheckSql() {
        return "select indexname from pg_indexes where schemaname='public' and Upper(tablename)=?";
    }

    public String getColumnCheckSql() {
        return "select a.attname as column_name from pg_class c, pg_attribute a where a.attnum>0  and a.attrelid = c.oid and UPPER(c.relname)=?";
    }

    public String getTableStructSql() {
        return "select tablename from pg_tables where schemaname='public'";
    }

    public String getColumnStructSql() {
        return "select a.attname as column_name,c.relname as table_name  from pg_class c, pg_attribute a,pg_tables t where a.attnum>0 and a.attrelid = c.oid and t.tablename=c.relname and t.schemaname='public'";
    }

    public String getIndexStructSql() {
        return "select indexname,tablename, '' as COLUMN_NAME, -1 as NON_UNIQUE, 0 as SEQ_IN_INDEX from pg_indexes where schemaname='public'";
    }

    public String getViewExistCheckSql() {
        return "select count(viewname) from pg_views where UPPER(viewname)=?";
    }

    public String getViewStructSql() {
        return "select viewname from pg_views";
    }
}

