/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.MySqlDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.connection.PartitionInfo;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class MySqlClusterDBManager
extends MySqlDBManager {
    public MySqlClusterDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
    }

    @Override
    public void initDataBaseInfo(DataBaseInfo dataBaseInfo) throws Throwable {
        Statement statement;
        block5: {
            statement = null;
            ResultSet resultSet = null;
            try {
                PSArgs pSArgs = new PSArgs();
                pSArgs.addStringArg(this.connection.getCatalog());
                String string = this.getTableStructSql();
                statement = this.prepareStatement(string);
                resultSet = this.executeQuery((PreparedStatement)statement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initTable(resultSet);
                statement.close();
                resultSet.close();
                string = this.getViewStructSql();
                statement = this.prepareStatement(string);
                pSArgs = new PSArgs();
                pSArgs.addStringArg(this.connection.getCatalog());
                resultSet = this.executeQuery((PreparedStatement)statement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initView(resultSet);
                statement.close();
                resultSet.close();
                string = this.getColumnStructSql();
                statement = this.prepareStatement(string);
                resultSet = this.executeQuery((PreparedStatement)statement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initColumn(resultSet);
                statement.close();
                resultSet.close();
                string = this.getIndexStructSql();
                statement = this.prepareStatement(string);
                resultSet = this.executeQuery((PreparedStatement)statement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initIndex(resultSet);
                string = this.getPartitionStructSql();
                statement = this.prepareStatement(string);
                resultSet = this.executeQuery((PreparedStatement)statement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initPartition(resultSet);
                if (resultSet == null) break block5;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
            return;
        }
    }

    @Override
    public int getDBType() {
        return 6;
    }

    public String getPartitionStructSql() {
        return "select TABLE_NAME,PARTITION_METHOD,PARTITION_EXPRESSION FROM information_schema.PARTITIONS where TABLE_SCHEMA = ?";
    }

    public String getTablePartitionCheckSql() {
        if (DBManagerUtil.isLowerCaseTableNames()) {
            return "select TABLE_NAME,PARTITION_METHOD,PARTITION_EXPRESSION from information_schema.`PARTITIONS` WHERE TABLE_NAME = ?  and TABLE_SCHEMA = ?";
        }
        return "select TABLE_NAME,PARTITION_METHOD,PARTITION_EXPRESSION from information_schema.`PARTITIONS` WHERE LOWER(TABLE_NAME) = ?  and TABLE_SCHEMA = ?";
    }

    public PartitionInfo getPartitionInfo(String string) throws Throwable {
        PartitionInfo partitionInfo = new PartitionInfo();
        String string2 = this.getTablePartitionCheckSql();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toLowerCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getCatalog());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.first();
            partitionInfo.setPartitionMethod(resultSet.getString(2));
            while (resultSet.next()) {
                partitionInfo.putPartitionColumnSet(resultSet.getString(3));
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return partitionInfo;
    }

    public static String getAlterPartitionSql(IDBManager iDBManager, MetaSchemaTable object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ALTER TABLE ").append(iDBManager.keyWordEscape(object.getKey())).append(" PARTITION BY ").append(object.getPartitionMethod()).append('(');
        boolean bl = false;
        for (MetaSchemaColumn metaSchemaColumn : object.getColumnCollection()) {
            if (!metaSchemaColumn.isPartition()) continue;
            bl = true;
            stringBuilder.append(iDBManager.keyWordEscape(metaSchemaColumn.getKey())).append(',');
        }
        if (bl) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.setCharAt(stringBuilder2.length() - 1, ')');
        } else {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getColumnDef(MetaSchemaColumn object) throws Throwable {
        object = object.isAutoGen() && object.getDataType() == 1002 && object.getLength() > 255 ? this.keyWordEscape(object.getKey()) + " text(" + object.getLength() + ") " : super.getColumnDef((MetaSchemaColumn)object);
        return object;
    }
}

